package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.runtime.RawExtensionBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.runtime.RawExtensionFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.openshift.api.model.runtime.RawExtension;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageFluent<A extends ImageFluent<A>> extends BaseFluent<A>{
  public ImageFluent() {
  }
  
  public ImageFluent(Image instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String dockerImageConfig;
  private ArrayList<ImageLayerBuilder> dockerImageLayers = new ArrayList<ImageLayerBuilder>();
  private String dockerImageManifest;
  private String dockerImageManifestMediaType;
  private ArrayList<ImageManifestBuilder> dockerImageManifests = new ArrayList<ImageManifestBuilder>();
  private RawExtensionBuilder dockerImageMetadata;
  private String dockerImageMetadataVersion;
  private String dockerImageReference;
  private List<String> dockerImageSignatures = new ArrayList<String>();
  private String kind;
  private ObjectMetaBuilder metadata;
  private ArrayList<ImageSignatureBuilder> signatures = new ArrayList<ImageSignatureBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Image instance) {
    instance = (instance != null ? instance : new Image());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withDockerImageConfig(instance.getDockerImageConfig());
          this.withDockerImageLayers(instance.getDockerImageLayers());
          this.withDockerImageManifest(instance.getDockerImageManifest());
          this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
          this.withDockerImageManifests(instance.getDockerImageManifests());
          this.withDockerImageMetadata(instance.getDockerImageMetadata());
          this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
          this.withDockerImageReference(instance.getDockerImageReference());
          this.withDockerImageSignatures(instance.getDockerImageSignatures());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withSignatures(instance.getSignatures());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getDockerImageConfig() {
    return this.dockerImageConfig;
  }
  
  public A withDockerImageConfig(String dockerImageConfig) {
    this.dockerImageConfig = dockerImageConfig;
    return (A) this;
  }
  
  public boolean hasDockerImageConfig() {
    return this.dockerImageConfig != null;
  }
  
  public A addToDockerImageLayers(int index,ImageLayer item) {
    if (this.dockerImageLayers == null) {this.dockerImageLayers = new ArrayList<ImageLayerBuilder>();}
    ImageLayerBuilder builder = new ImageLayerBuilder(item);
    if (index < 0 || index >= dockerImageLayers.size()) { _visitables.get("dockerImageLayers").add(builder); dockerImageLayers.add(builder); } else { _visitables.get("dockerImageLayers").add(index, builder); dockerImageLayers.add(index, builder);}
    return (A)this;
  }
  
  public A setToDockerImageLayers(int index,ImageLayer item) {
    if (this.dockerImageLayers == null) {this.dockerImageLayers = new ArrayList<ImageLayerBuilder>();}
    ImageLayerBuilder builder = new ImageLayerBuilder(item);
    if (index < 0 || index >= dockerImageLayers.size()) { _visitables.get("dockerImageLayers").add(builder); dockerImageLayers.add(builder); } else { _visitables.get("dockerImageLayers").set(index, builder); dockerImageLayers.set(index, builder);}
    return (A)this;
  }
  
  public A addToDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... items) {
    if (this.dockerImageLayers == null) {this.dockerImageLayers = new ArrayList<ImageLayerBuilder>();}
    for (ImageLayer item : items) {ImageLayerBuilder builder = new ImageLayerBuilder(item);_visitables.get("dockerImageLayers").add(builder);this.dockerImageLayers.add(builder);} return (A)this;
  }
  
  public A addAllToDockerImageLayers(Collection<ImageLayer> items) {
    if (this.dockerImageLayers == null) {this.dockerImageLayers = new ArrayList<ImageLayerBuilder>();}
    for (ImageLayer item : items) {ImageLayerBuilder builder = new ImageLayerBuilder(item);_visitables.get("dockerImageLayers").add(builder);this.dockerImageLayers.add(builder);} return (A)this;
  }
  
  public A removeFromDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... items) {
    if (this.dockerImageLayers == null) return (A)this;
    for (ImageLayer item : items) {ImageLayerBuilder builder = new ImageLayerBuilder(item);_visitables.get("dockerImageLayers").remove(builder); this.dockerImageLayers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDockerImageLayers(Collection<ImageLayer> items) {
    if (this.dockerImageLayers == null) return (A)this;
    for (ImageLayer item : items) {ImageLayerBuilder builder = new ImageLayerBuilder(item);_visitables.get("dockerImageLayers").remove(builder); this.dockerImageLayers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDockerImageLayers(Predicate<ImageLayerBuilder> predicate) {
    if (dockerImageLayers == null) return (A) this;
    final Iterator<ImageLayerBuilder> each = dockerImageLayers.iterator();
    final List visitables = _visitables.get("dockerImageLayers");
    while (each.hasNext()) {
      ImageLayerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ImageLayer> buildDockerImageLayers() {
    return this.dockerImageLayers != null ? build(dockerImageLayers) : null;
  }
  
  public ImageLayer buildDockerImageLayer(int index) {
    return this.dockerImageLayers.get(index).build();
  }
  
  public ImageLayer buildFirstDockerImageLayer() {
    return this.dockerImageLayers.get(0).build();
  }
  
  public ImageLayer buildLastDockerImageLayer() {
    return this.dockerImageLayers.get(dockerImageLayers.size() - 1).build();
  }
  
  public ImageLayer buildMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
      for (ImageLayerBuilder item : dockerImageLayers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
      for (ImageLayerBuilder item : dockerImageLayers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDockerImageLayers(List<ImageLayer> dockerImageLayers) {
    if (this.dockerImageLayers != null) {
      this._visitables.get("dockerImageLayers").clear();
    }
    if (dockerImageLayers != null) {
        this.dockerImageLayers = new ArrayList();
        for (ImageLayer item : dockerImageLayers) {
          this.addToDockerImageLayers(item);
        }
    } else {
      this.dockerImageLayers = null;
    }
    return (A) this;
  }
  
  public A withDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... dockerImageLayers) {
    if (this.dockerImageLayers != null) {
        this.dockerImageLayers.clear();
        _visitables.remove("dockerImageLayers");
    }
    if (dockerImageLayers != null) {
      for (ImageLayer item : dockerImageLayers) {
        this.addToDockerImageLayers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDockerImageLayers() {
    return this.dockerImageLayers != null && !this.dockerImageLayers.isEmpty();
  }
  
  public A addNewDockerImageLayer(String mediaType,String name,Long size) {
    return (A)addToDockerImageLayers(new ImageLayer(mediaType, name, size));
  }
  
  public DockerImageLayersNested<A> addNewDockerImageLayer() {
    return new DockerImageLayersNested(-1, null);
  }
  
  public DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item) {
    return new DockerImageLayersNested(-1, item);
  }
  
  public DockerImageLayersNested<A> setNewDockerImageLayerLike(int index,ImageLayer item) {
    return new DockerImageLayersNested(index, item);
  }
  
  public DockerImageLayersNested<A> editDockerImageLayer(int index) {
    if (dockerImageLayers.size() <= index) throw new RuntimeException("Can't edit dockerImageLayers. Index exceeds size.");
    return setNewDockerImageLayerLike(index, buildDockerImageLayer(index));
  }
  
  public DockerImageLayersNested<A> editFirstDockerImageLayer() {
    if (dockerImageLayers.size() == 0) throw new RuntimeException("Can't edit first dockerImageLayers. The list is empty.");
    return setNewDockerImageLayerLike(0, buildDockerImageLayer(0));
  }
  
  public DockerImageLayersNested<A> editLastDockerImageLayer() {
    int index = dockerImageLayers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dockerImageLayers. The list is empty.");
    return setNewDockerImageLayerLike(index, buildDockerImageLayer(index));
  }
  
  public DockerImageLayersNested<A> editMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dockerImageLayers.size();i++) { 
    if (predicate.test(dockerImageLayers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dockerImageLayers. No match found.");
    return setNewDockerImageLayerLike(index, buildDockerImageLayer(index));
  }
  
  public String getDockerImageManifest() {
    return this.dockerImageManifest;
  }
  
  public A withDockerImageManifest(String dockerImageManifest) {
    this.dockerImageManifest = dockerImageManifest;
    return (A) this;
  }
  
  public boolean hasDockerImageManifest() {
    return this.dockerImageManifest != null;
  }
  
  public String getDockerImageManifestMediaType() {
    return this.dockerImageManifestMediaType;
  }
  
  public A withDockerImageManifestMediaType(String dockerImageManifestMediaType) {
    this.dockerImageManifestMediaType = dockerImageManifestMediaType;
    return (A) this;
  }
  
  public boolean hasDockerImageManifestMediaType() {
    return this.dockerImageManifestMediaType != null;
  }
  
  public A addToDockerImageManifests(int index,ImageManifest item) {
    if (this.dockerImageManifests == null) {this.dockerImageManifests = new ArrayList<ImageManifestBuilder>();}
    ImageManifestBuilder builder = new ImageManifestBuilder(item);
    if (index < 0 || index >= dockerImageManifests.size()) { _visitables.get("dockerImageManifests").add(builder); dockerImageManifests.add(builder); } else { _visitables.get("dockerImageManifests").add(index, builder); dockerImageManifests.add(index, builder);}
    return (A)this;
  }
  
  public A setToDockerImageManifests(int index,ImageManifest item) {
    if (this.dockerImageManifests == null) {this.dockerImageManifests = new ArrayList<ImageManifestBuilder>();}
    ImageManifestBuilder builder = new ImageManifestBuilder(item);
    if (index < 0 || index >= dockerImageManifests.size()) { _visitables.get("dockerImageManifests").add(builder); dockerImageManifests.add(builder); } else { _visitables.get("dockerImageManifests").set(index, builder); dockerImageManifests.set(index, builder);}
    return (A)this;
  }
  
  public A addToDockerImageManifests(io.fabric8.openshift.api.model.ImageManifest... items) {
    if (this.dockerImageManifests == null) {this.dockerImageManifests = new ArrayList<ImageManifestBuilder>();}
    for (ImageManifest item : items) {ImageManifestBuilder builder = new ImageManifestBuilder(item);_visitables.get("dockerImageManifests").add(builder);this.dockerImageManifests.add(builder);} return (A)this;
  }
  
  public A addAllToDockerImageManifests(Collection<ImageManifest> items) {
    if (this.dockerImageManifests == null) {this.dockerImageManifests = new ArrayList<ImageManifestBuilder>();}
    for (ImageManifest item : items) {ImageManifestBuilder builder = new ImageManifestBuilder(item);_visitables.get("dockerImageManifests").add(builder);this.dockerImageManifests.add(builder);} return (A)this;
  }
  
  public A removeFromDockerImageManifests(io.fabric8.openshift.api.model.ImageManifest... items) {
    if (this.dockerImageManifests == null) return (A)this;
    for (ImageManifest item : items) {ImageManifestBuilder builder = new ImageManifestBuilder(item);_visitables.get("dockerImageManifests").remove(builder); this.dockerImageManifests.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDockerImageManifests(Collection<ImageManifest> items) {
    if (this.dockerImageManifests == null) return (A)this;
    for (ImageManifest item : items) {ImageManifestBuilder builder = new ImageManifestBuilder(item);_visitables.get("dockerImageManifests").remove(builder); this.dockerImageManifests.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDockerImageManifests(Predicate<ImageManifestBuilder> predicate) {
    if (dockerImageManifests == null) return (A) this;
    final Iterator<ImageManifestBuilder> each = dockerImageManifests.iterator();
    final List visitables = _visitables.get("dockerImageManifests");
    while (each.hasNext()) {
      ImageManifestBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ImageManifest> buildDockerImageManifests() {
    return this.dockerImageManifests != null ? build(dockerImageManifests) : null;
  }
  
  public ImageManifest buildDockerImageManifest(int index) {
    return this.dockerImageManifests.get(index).build();
  }
  
  public ImageManifest buildFirstDockerImageManifest() {
    return this.dockerImageManifests.get(0).build();
  }
  
  public ImageManifest buildLastDockerImageManifest() {
    return this.dockerImageManifests.get(dockerImageManifests.size() - 1).build();
  }
  
  public ImageManifest buildMatchingDockerImageManifest(Predicate<ImageManifestBuilder> predicate) {
      for (ImageManifestBuilder item : dockerImageManifests) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDockerImageManifest(Predicate<ImageManifestBuilder> predicate) {
      for (ImageManifestBuilder item : dockerImageManifests) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDockerImageManifests(List<ImageManifest> dockerImageManifests) {
    if (this.dockerImageManifests != null) {
      this._visitables.get("dockerImageManifests").clear();
    }
    if (dockerImageManifests != null) {
        this.dockerImageManifests = new ArrayList();
        for (ImageManifest item : dockerImageManifests) {
          this.addToDockerImageManifests(item);
        }
    } else {
      this.dockerImageManifests = null;
    }
    return (A) this;
  }
  
  public A withDockerImageManifests(io.fabric8.openshift.api.model.ImageManifest... dockerImageManifests) {
    if (this.dockerImageManifests != null) {
        this.dockerImageManifests.clear();
        _visitables.remove("dockerImageManifests");
    }
    if (dockerImageManifests != null) {
      for (ImageManifest item : dockerImageManifests) {
        this.addToDockerImageManifests(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDockerImageManifests() {
    return this.dockerImageManifests != null && !this.dockerImageManifests.isEmpty();
  }
  
  public DockerImageManifestsNested<A> addNewDockerImageManifest() {
    return new DockerImageManifestsNested(-1, null);
  }
  
  public DockerImageManifestsNested<A> addNewDockerImageManifestLike(ImageManifest item) {
    return new DockerImageManifestsNested(-1, item);
  }
  
  public DockerImageManifestsNested<A> setNewDockerImageManifestLike(int index,ImageManifest item) {
    return new DockerImageManifestsNested(index, item);
  }
  
  public DockerImageManifestsNested<A> editDockerImageManifest(int index) {
    if (dockerImageManifests.size() <= index) throw new RuntimeException("Can't edit dockerImageManifests. Index exceeds size.");
    return setNewDockerImageManifestLike(index, buildDockerImageManifest(index));
  }
  
  public DockerImageManifestsNested<A> editFirstDockerImageManifest() {
    if (dockerImageManifests.size() == 0) throw new RuntimeException("Can't edit first dockerImageManifests. The list is empty.");
    return setNewDockerImageManifestLike(0, buildDockerImageManifest(0));
  }
  
  public DockerImageManifestsNested<A> editLastDockerImageManifest() {
    int index = dockerImageManifests.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dockerImageManifests. The list is empty.");
    return setNewDockerImageManifestLike(index, buildDockerImageManifest(index));
  }
  
  public DockerImageManifestsNested<A> editMatchingDockerImageManifest(Predicate<ImageManifestBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dockerImageManifests.size();i++) { 
    if (predicate.test(dockerImageManifests.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dockerImageManifests. No match found.");
    return setNewDockerImageManifestLike(index, buildDockerImageManifest(index));
  }
  
  public RawExtension buildDockerImageMetadata() {
    return this.dockerImageMetadata != null ? this.dockerImageMetadata.build() : null;
  }
  
  public A withDockerImageMetadata(RawExtension dockerImageMetadata) {
    this._visitables.remove("dockerImageMetadata");
    if (dockerImageMetadata != null) {
        this.dockerImageMetadata = new RawExtensionBuilder(dockerImageMetadata);
        this._visitables.get("dockerImageMetadata").add(this.dockerImageMetadata);
    } else {
        this.dockerImageMetadata = null;
        this._visitables.get("dockerImageMetadata").remove(this.dockerImageMetadata);
    }
    return (A) this;
  }
  
  public boolean hasDockerImageMetadata() {
    return this.dockerImageMetadata != null;
  }
  
  public A withNewOpenshiftDockerImageMetadata(Object value) {
    return (A)withDockerImageMetadata(new RawExtension(value));
  }
  
  public OpenshiftDockerImageMetadataNested<A> withNewOpenshiftDockerImageMetadata() {
    return new OpenshiftDockerImageMetadataNested(null);
  }
  
  public OpenshiftDockerImageMetadataNested<A> withNewDockerImageMetadataLike(RawExtension item) {
    return new OpenshiftDockerImageMetadataNested(item);
  }
  
  public OpenshiftDockerImageMetadataNested<A> editOpenshiftDockerImageMetadata() {
    return withNewDockerImageMetadataLike(java.util.Optional.ofNullable(buildDockerImageMetadata()).orElse(null));
  }
  
  public OpenshiftDockerImageMetadataNested<A> editOrNewDockerImageMetadata() {
    return withNewDockerImageMetadataLike(java.util.Optional.ofNullable(buildDockerImageMetadata()).orElse(new RawExtensionBuilder().build()));
  }
  
  public OpenshiftDockerImageMetadataNested<A> editOrNewDockerImageMetadataLike(RawExtension item) {
    return withNewDockerImageMetadataLike(java.util.Optional.ofNullable(buildDockerImageMetadata()).orElse(item));
  }
  
  public String getDockerImageMetadataVersion() {
    return this.dockerImageMetadataVersion;
  }
  
  public A withDockerImageMetadataVersion(String dockerImageMetadataVersion) {
    this.dockerImageMetadataVersion = dockerImageMetadataVersion;
    return (A) this;
  }
  
  public boolean hasDockerImageMetadataVersion() {
    return this.dockerImageMetadataVersion != null;
  }
  
  public String getDockerImageReference() {
    return this.dockerImageReference;
  }
  
  public A withDockerImageReference(String dockerImageReference) {
    this.dockerImageReference = dockerImageReference;
    return (A) this;
  }
  
  public boolean hasDockerImageReference() {
    return this.dockerImageReference != null;
  }
  
  public A addToDockerImageSignatures(int index,String item) {
    if (this.dockerImageSignatures == null) {this.dockerImageSignatures = new ArrayList<String>();}
    this.dockerImageSignatures.add(index, item);
    return (A)this;
  }
  
  public A setToDockerImageSignatures(int index,String item) {
    if (this.dockerImageSignatures == null) {this.dockerImageSignatures = new ArrayList<String>();}
    this.dockerImageSignatures.set(index, item); return (A)this;
  }
  
  public A addToDockerImageSignatures(java.lang.String... items) {
    if (this.dockerImageSignatures == null) {this.dockerImageSignatures = new ArrayList<String>();}
    for (String item : items) {this.dockerImageSignatures.add(item);} return (A)this;
  }
  
  public A addAllToDockerImageSignatures(Collection<String> items) {
    if (this.dockerImageSignatures == null) {this.dockerImageSignatures = new ArrayList<String>();}
    for (String item : items) {this.dockerImageSignatures.add(item);} return (A)this;
  }
  
  public A removeFromDockerImageSignatures(java.lang.String... items) {
    if (this.dockerImageSignatures == null) return (A)this;
    for (String item : items) { this.dockerImageSignatures.remove(item);} return (A)this;
  }
  
  public A removeAllFromDockerImageSignatures(Collection<String> items) {
    if (this.dockerImageSignatures == null) return (A)this;
    for (String item : items) { this.dockerImageSignatures.remove(item);} return (A)this;
  }
  
  public List<String> getDockerImageSignatures() {
    return this.dockerImageSignatures;
  }
  
  public String getDockerImageSignature(int index) {
    return this.dockerImageSignatures.get(index);
  }
  
  public String getFirstDockerImageSignature() {
    return this.dockerImageSignatures.get(0);
  }
  
  public String getLastDockerImageSignature() {
    return this.dockerImageSignatures.get(dockerImageSignatures.size() - 1);
  }
  
  public String getMatchingDockerImageSignature(Predicate<String> predicate) {
      for (String item : dockerImageSignatures) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingDockerImageSignature(Predicate<String> predicate) {
      for (String item : dockerImageSignatures) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDockerImageSignatures(List<String> dockerImageSignatures) {
    if (dockerImageSignatures != null) {
        this.dockerImageSignatures = new ArrayList();
        for (String item : dockerImageSignatures) {
          this.addToDockerImageSignatures(item);
        }
    } else {
      this.dockerImageSignatures = null;
    }
    return (A) this;
  }
  
  public A withDockerImageSignatures(java.lang.String... dockerImageSignatures) {
    if (this.dockerImageSignatures != null) {
        this.dockerImageSignatures.clear();
        _visitables.remove("dockerImageSignatures");
    }
    if (dockerImageSignatures != null) {
      for (String item : dockerImageSignatures) {
        this.addToDockerImageSignatures(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDockerImageSignatures() {
    return this.dockerImageSignatures != null && !this.dockerImageSignatures.isEmpty();
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public A addToSignatures(int index,ImageSignature item) {
    if (this.signatures == null) {this.signatures = new ArrayList<ImageSignatureBuilder>();}
    ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
    if (index < 0 || index >= signatures.size()) { _visitables.get("signatures").add(builder); signatures.add(builder); } else { _visitables.get("signatures").add(index, builder); signatures.add(index, builder);}
    return (A)this;
  }
  
  public A setToSignatures(int index,ImageSignature item) {
    if (this.signatures == null) {this.signatures = new ArrayList<ImageSignatureBuilder>();}
    ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
    if (index < 0 || index >= signatures.size()) { _visitables.get("signatures").add(builder); signatures.add(builder); } else { _visitables.get("signatures").set(index, builder); signatures.set(index, builder);}
    return (A)this;
  }
  
  public A addToSignatures(io.fabric8.openshift.api.model.ImageSignature... items) {
    if (this.signatures == null) {this.signatures = new ArrayList<ImageSignatureBuilder>();}
    for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("signatures").add(builder);this.signatures.add(builder);} return (A)this;
  }
  
  public A addAllToSignatures(Collection<ImageSignature> items) {
    if (this.signatures == null) {this.signatures = new ArrayList<ImageSignatureBuilder>();}
    for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("signatures").add(builder);this.signatures.add(builder);} return (A)this;
  }
  
  public A removeFromSignatures(io.fabric8.openshift.api.model.ImageSignature... items) {
    if (this.signatures == null) return (A)this;
    for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("signatures").remove(builder); this.signatures.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSignatures(Collection<ImageSignature> items) {
    if (this.signatures == null) return (A)this;
    for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("signatures").remove(builder); this.signatures.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSignatures(Predicate<ImageSignatureBuilder> predicate) {
    if (signatures == null) return (A) this;
    final Iterator<ImageSignatureBuilder> each = signatures.iterator();
    final List visitables = _visitables.get("signatures");
    while (each.hasNext()) {
      ImageSignatureBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ImageSignature> buildSignatures() {
    return this.signatures != null ? build(signatures) : null;
  }
  
  public ImageSignature buildSignature(int index) {
    return this.signatures.get(index).build();
  }
  
  public ImageSignature buildFirstSignature() {
    return this.signatures.get(0).build();
  }
  
  public ImageSignature buildLastSignature() {
    return this.signatures.get(signatures.size() - 1).build();
  }
  
  public ImageSignature buildMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
      for (ImageSignatureBuilder item : signatures) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
      for (ImageSignatureBuilder item : signatures) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSignatures(List<ImageSignature> signatures) {
    if (this.signatures != null) {
      this._visitables.get("signatures").clear();
    }
    if (signatures != null) {
        this.signatures = new ArrayList();
        for (ImageSignature item : signatures) {
          this.addToSignatures(item);
        }
    } else {
      this.signatures = null;
    }
    return (A) this;
  }
  
  public A withSignatures(io.fabric8.openshift.api.model.ImageSignature... signatures) {
    if (this.signatures != null) {
        this.signatures.clear();
        _visitables.remove("signatures");
    }
    if (signatures != null) {
      for (ImageSignature item : signatures) {
        this.addToSignatures(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSignatures() {
    return this.signatures != null && !this.signatures.isEmpty();
  }
  
  public SignaturesNested<A> addNewSignature() {
    return new SignaturesNested(-1, null);
  }
  
  public SignaturesNested<A> addNewSignatureLike(ImageSignature item) {
    return new SignaturesNested(-1, item);
  }
  
  public SignaturesNested<A> setNewSignatureLike(int index,ImageSignature item) {
    return new SignaturesNested(index, item);
  }
  
  public SignaturesNested<A> editSignature(int index) {
    if (signatures.size() <= index) throw new RuntimeException("Can't edit signatures. Index exceeds size.");
    return setNewSignatureLike(index, buildSignature(index));
  }
  
  public SignaturesNested<A> editFirstSignature() {
    if (signatures.size() == 0) throw new RuntimeException("Can't edit first signatures. The list is empty.");
    return setNewSignatureLike(0, buildSignature(0));
  }
  
  public SignaturesNested<A> editLastSignature() {
    int index = signatures.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last signatures. The list is empty.");
    return setNewSignatureLike(index, buildSignature(index));
  }
  
  public SignaturesNested<A> editMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
    int index = -1;
    for (int i=0;i<signatures.size();i++) { 
    if (predicate.test(signatures.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching signatures. No match found.");
    return setNewSignatureLike(index, buildSignature(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageFluent that = (ImageFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(dockerImageConfig, that.dockerImageConfig)) return false;
    if (!java.util.Objects.equals(dockerImageLayers, that.dockerImageLayers)) return false;
    if (!java.util.Objects.equals(dockerImageManifest, that.dockerImageManifest)) return false;
    if (!java.util.Objects.equals(dockerImageManifestMediaType, that.dockerImageManifestMediaType)) return false;
    if (!java.util.Objects.equals(dockerImageManifests, that.dockerImageManifests)) return false;
    if (!java.util.Objects.equals(dockerImageMetadata, that.dockerImageMetadata)) return false;
    if (!java.util.Objects.equals(dockerImageMetadataVersion, that.dockerImageMetadataVersion)) return false;
    if (!java.util.Objects.equals(dockerImageReference, that.dockerImageReference)) return false;
    if (!java.util.Objects.equals(dockerImageSignatures, that.dockerImageSignatures)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(signatures, that.signatures)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  dockerImageConfig,  dockerImageLayers,  dockerImageManifest,  dockerImageManifestMediaType,  dockerImageManifests,  dockerImageMetadata,  dockerImageMetadataVersion,  dockerImageReference,  dockerImageSignatures,  kind,  metadata,  signatures,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (dockerImageConfig != null) { sb.append("dockerImageConfig:"); sb.append(dockerImageConfig + ","); }
    if (dockerImageLayers != null && !dockerImageLayers.isEmpty()) { sb.append("dockerImageLayers:"); sb.append(dockerImageLayers + ","); }
    if (dockerImageManifest != null) { sb.append("dockerImageManifest:"); sb.append(dockerImageManifest + ","); }
    if (dockerImageManifestMediaType != null) { sb.append("dockerImageManifestMediaType:"); sb.append(dockerImageManifestMediaType + ","); }
    if (dockerImageManifests != null && !dockerImageManifests.isEmpty()) { sb.append("dockerImageManifests:"); sb.append(dockerImageManifests + ","); }
    if (dockerImageMetadata != null) { sb.append("dockerImageMetadata:"); sb.append(dockerImageMetadata + ","); }
    if (dockerImageMetadataVersion != null) { sb.append("dockerImageMetadataVersion:"); sb.append(dockerImageMetadataVersion + ","); }
    if (dockerImageReference != null) { sb.append("dockerImageReference:"); sb.append(dockerImageReference + ","); }
    if (dockerImageSignatures != null && !dockerImageSignatures.isEmpty()) { sb.append("dockerImageSignatures:"); sb.append(dockerImageSignatures + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (signatures != null && !signatures.isEmpty()) { sb.append("signatures:"); sb.append(signatures + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DockerImageLayersNested<N> extends ImageLayerFluent<DockerImageLayersNested<N>> implements Nested<N>{
    DockerImageLayersNested(int index,ImageLayer item) {
      this.index = index;
      this.builder = new ImageLayerBuilder(this, item);
    }
    ImageLayerBuilder builder;
    int index;
    
    public N and() {
      return (N) ImageFluent.this.setToDockerImageLayers(index,builder.build());
    }
    
    public N endDockerImageLayer() {
      return and();
    }
    
  
  }
  public class DockerImageManifestsNested<N> extends ImageManifestFluent<DockerImageManifestsNested<N>> implements Nested<N>{
    DockerImageManifestsNested(int index,ImageManifest item) {
      this.index = index;
      this.builder = new ImageManifestBuilder(this, item);
    }
    ImageManifestBuilder builder;
    int index;
    
    public N and() {
      return (N) ImageFluent.this.setToDockerImageManifests(index,builder.build());
    }
    
    public N endDockerImageManifest() {
      return and();
    }
    
  
  }
  public class OpenshiftDockerImageMetadataNested<N> extends RawExtensionFluent<OpenshiftDockerImageMetadataNested<N>> implements Nested<N>{
    OpenshiftDockerImageMetadataNested(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionBuilder builder;
    
    public N and() {
      return (N) ImageFluent.this.withDockerImageMetadata(builder.build());
    }
    
    public N endOpenshiftDockerImageMetadata() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) ImageFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class SignaturesNested<N> extends ImageSignatureFluent<SignaturesNested<N>> implements Nested<N>{
    SignaturesNested(int index,ImageSignature item) {
      this.index = index;
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureBuilder builder;
    int index;
    
    public N and() {
      return (N) ImageFluent.this.setToSignatures(index,builder.build());
    }
    
    public N endSignature() {
      return and();
    }
    
  
  }

}