package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RoutePortFluent<A extends RoutePortFluent<A>> extends BaseFluent<A>{
  public RoutePortFluent() {
  }
  
  public RoutePortFluent(RoutePort instance) {
    this.copyInstance(instance);
  }
  private IntOrStringBuilder targetPort;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RoutePort instance) {
    instance = (instance != null ? instance : new RoutePort());
    if (instance != null) {
          this.withTargetPort(instance.getTargetPort());
          this.withTargetPort(instance.getTargetPort());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IntOrString buildTargetPort() {
    return this.targetPort != null ? this.targetPort.build() : null;
  }
  
  public A withTargetPort(IntOrString targetPort) {
    this._visitables.remove(this.targetPort);
    if (targetPort != null) {
        this.targetPort = new IntOrStringBuilder(targetPort);
        this._visitables.get("targetPort").add(this.targetPort);
    } else {
        this.targetPort = null;
        this._visitables.get("targetPort").remove(this.targetPort);
    }
    return (A) this;
  }
  
  public boolean hasTargetPort() {
    return this.targetPort != null;
  }
  
  public A withNewTargetPort(Object value) {
    return (A)withTargetPort(new IntOrString(value));
  }
  
  public TargetPortNested<A> withNewTargetPort() {
    return new TargetPortNested(null);
  }
  
  public TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
    return new TargetPortNested(item);
  }
  
  public TargetPortNested<A> editTargetPort() {
    return withNewTargetPortLike(java.util.Optional.ofNullable(buildTargetPort()).orElse(null));
  }
  
  public TargetPortNested<A> editOrNewTargetPort() {
    return withNewTargetPortLike(java.util.Optional.ofNullable(buildTargetPort()).orElse(new IntOrStringBuilder().build()));
  }
  
  public TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
    return withNewTargetPortLike(java.util.Optional.ofNullable(buildTargetPort()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RoutePortFluent that = (RoutePortFluent) o;
    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(targetPort,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TargetPortNested<N> extends IntOrStringFluent<TargetPortNested<N>> implements Nested<N>{
    TargetPortNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) RoutePortFluent.this.withTargetPort(builder.build());
    }
    
    public N endTargetPort() {
      return and();
    }
    
  
  }

}