package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageImportStatusFluent<A extends ImageImportStatusFluent<A>> extends BaseFluent<A>{
  public ImageImportStatusFluent() {
  }
  
  public ImageImportStatusFluent(ImageImportStatus instance) {
    this.copyInstance(instance);
  }
  private ImageBuilder image;
  private ArrayList<ImageBuilder> manifests = new ArrayList<ImageBuilder>();
  private Status status;
  private String tag;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageImportStatus instance) {
    instance = (instance != null ? instance : new ImageImportStatus());
    if (instance != null) {
          this.withImage(instance.getImage());
          this.withManifests(instance.getManifests());
          this.withStatus(instance.getStatus());
          this.withTag(instance.getTag());
          this.withImage(instance.getImage());
          this.withManifests(instance.getManifests());
          this.withStatus(instance.getStatus());
          this.withTag(instance.getTag());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Image buildImage() {
    return this.image != null ? this.image.build() : null;
  }
  
  public A withImage(Image image) {
    this._visitables.remove(this.image);
    if (image != null) {
        this.image = new ImageBuilder(image);
        this._visitables.get("image").add(this.image);
    } else {
        this.image = null;
        this._visitables.get("image").remove(this.image);
    }
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public ImageNested<A> withNewImage() {
    return new ImageNested(null);
  }
  
  public ImageNested<A> withNewImageLike(Image item) {
    return new ImageNested(item);
  }
  
  public ImageNested<A> editImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(null));
  }
  
  public ImageNested<A> editOrNewImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(new ImageBuilder().build()));
  }
  
  public ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(item));
  }
  
  public A addToManifests(int index,Image item) {
    if (this.manifests == null) {this.manifests = new ArrayList<ImageBuilder>();}
    ImageBuilder builder = new ImageBuilder(item);
    if (index < 0 || index >= manifests.size()) { _visitables.get("manifests").add(builder); manifests.add(builder); } else { _visitables.get("manifests").add(index, builder); manifests.add(index, builder);}
    return (A)this;
  }
  
  public A setToManifests(int index,Image item) {
    if (this.manifests == null) {this.manifests = new ArrayList<ImageBuilder>();}
    ImageBuilder builder = new ImageBuilder(item);
    if (index < 0 || index >= manifests.size()) { _visitables.get("manifests").add(builder); manifests.add(builder); } else { _visitables.get("manifests").set(index, builder); manifests.set(index, builder);}
    return (A)this;
  }
  
  public A addToManifests(io.fabric8.openshift.api.model.Image... items) {
    if (this.manifests == null) {this.manifests = new ArrayList<ImageBuilder>();}
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("manifests").add(builder);this.manifests.add(builder);} return (A)this;
  }
  
  public A addAllToManifests(Collection<Image> items) {
    if (this.manifests == null) {this.manifests = new ArrayList<ImageBuilder>();}
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("manifests").add(builder);this.manifests.add(builder);} return (A)this;
  }
  
  public A removeFromManifests(io.fabric8.openshift.api.model.Image... items) {
    if (this.manifests == null) return (A)this;
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("manifests").remove(builder); this.manifests.remove(builder);} return (A)this;
  }
  
  public A removeAllFromManifests(Collection<Image> items) {
    if (this.manifests == null) return (A)this;
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("manifests").remove(builder); this.manifests.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromManifests(Predicate<ImageBuilder> predicate) {
    if (manifests == null) return (A) this;
    final Iterator<ImageBuilder> each = manifests.iterator();
    final List visitables = _visitables.get("manifests");
    while (each.hasNext()) {
      ImageBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Image> buildManifests() {
    return this.manifests != null ? build(manifests) : null;
  }
  
  public Image buildManifest(int index) {
    return this.manifests.get(index).build();
  }
  
  public Image buildFirstManifest() {
    return this.manifests.get(0).build();
  }
  
  public Image buildLastManifest() {
    return this.manifests.get(manifests.size() - 1).build();
  }
  
  public Image buildMatchingManifest(Predicate<ImageBuilder> predicate) {
      for (ImageBuilder item : manifests) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingManifest(Predicate<ImageBuilder> predicate) {
      for (ImageBuilder item : manifests) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withManifests(List<Image> manifests) {
    if (this.manifests != null) {
      this._visitables.get("manifests").clear();
    }
    if (manifests != null) {
        this.manifests = new ArrayList();
        for (Image item : manifests) {
          this.addToManifests(item);
        }
    } else {
      this.manifests = null;
    }
    return (A) this;
  }
  
  public A withManifests(io.fabric8.openshift.api.model.Image... manifests) {
    if (this.manifests != null) {this.manifests.clear(); _visitables.remove("manifests"); }
    if (manifests != null) {for (Image item :manifests){ this.addToManifests(item);}} return (A) this;
  }
  
  public boolean hasManifests() {
    return this.manifests != null && !this.manifests.isEmpty();
  }
  
  public ManifestsNested<A> addNewManifest() {
    return new ManifestsNested(-1, null);
  }
  
  public ManifestsNested<A> addNewManifestLike(Image item) {
    return new ManifestsNested(-1, item);
  }
  
  public ManifestsNested<A> setNewManifestLike(int index,Image item) {
    return new ManifestsNested(index, item);
  }
  
  public ManifestsNested<A> editManifest(int index) {
    if (manifests.size() <= index) throw new RuntimeException("Can't edit manifests. Index exceeds size.");
    return setNewManifestLike(index, buildManifest(index));
  }
  
  public ManifestsNested<A> editFirstManifest() {
    if (manifests.size() == 0) throw new RuntimeException("Can't edit first manifests. The list is empty.");
    return setNewManifestLike(0, buildManifest(0));
  }
  
  public ManifestsNested<A> editLastManifest() {
    int index = manifests.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last manifests. The list is empty.");
    return setNewManifestLike(index, buildManifest(index));
  }
  
  public ManifestsNested<A> editMatchingManifest(Predicate<ImageBuilder> predicate) {
    int index = -1;
    for (int i=0;i<manifests.size();i++) { 
    if (predicate.test(manifests.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching manifests. No match found.");
    return setNewManifestLike(index, buildManifest(index));
  }
  
  public Status getStatus() {
    return this.status;
  }
  
  public A withStatus(Status status) {
    this.status = status;
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public String getTag() {
    return this.tag;
  }
  
  public A withTag(String tag) {
    this.tag = tag;
    return (A) this;
  }
  
  public boolean hasTag() {
    return this.tag != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageImportStatusFluent that = (ImageImportStatusFluent) o;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(manifests, that.manifests)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    if (!java.util.Objects.equals(tag, that.tag)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(image,  manifests,  status,  tag,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (manifests != null && !manifests.isEmpty()) { sb.append("manifests:"); sb.append(manifests + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ImageNested<N> extends ImageFluent<ImageNested<N>> implements Nested<N>{
    ImageNested(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageBuilder builder;
    
    public N and() {
      return (N) ImageImportStatusFluent.this.withImage(builder.build());
    }
    
    public N endImage() {
      return and();
    }
    
  
  }
  public class ManifestsNested<N> extends ImageFluent<ManifestsNested<N>> implements Nested<N>{
    ManifestsNested(int index,Image item) {
      this.index = index;
      this.builder = new ImageBuilder(this, item);
    }
    ImageBuilder builder;
    int index;
    
    public N and() {
      return (N) ImageImportStatusFluent.this.setToManifests(index,builder.build());
    }
    
    public N endManifest() {
      return and();
    }
    
  
  }

}