package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GroupRestrictionFluent<A extends GroupRestrictionFluent<A>> extends BaseFluent<A>{
  public GroupRestrictionFluent() {
  }
  
  public GroupRestrictionFluent(GroupRestriction instance) {
    this.copyInstance(instance);
  }
  private List<String> groups = new ArrayList<String>();
  private ArrayList<LabelSelectorBuilder> labels = new ArrayList<LabelSelectorBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GroupRestriction instance) {
    instance = (instance != null ? instance : new GroupRestriction());
    if (instance != null) {
          this.withGroups(instance.getGroups());
          this.withLabels(instance.getLabels());
          this.withGroups(instance.getGroups());
          this.withLabels(instance.getLabels());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToGroups(int index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  
  public A setToGroups(int index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  
  public A removeFromGroups(java.lang.String... items) {
    if (this.groups == null) return (A)this;
    for (String item : items) { this.groups.remove(item);} return (A)this;
  }
  
  public A removeAllFromGroups(Collection<String> items) {
    if (this.groups == null) return (A)this;
    for (String item : items) { this.groups.remove(item);} return (A)this;
  }
  
  public List<String> getGroups() {
    return this.groups;
  }
  
  public String getGroup(int index) {
    return this.groups.get(index);
  }
  
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  
  public String getMatchingGroup(Predicate<String> predicate) {
      for (String item : groups) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingGroup(Predicate<String> predicate) {
      for (String item : groups) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGroups(List<String> groups) {
    if (groups != null) {
        this.groups = new ArrayList();
        for (String item : groups) {
          this.addToGroups(item);
        }
    } else {
      this.groups = null;
    }
    return (A) this;
  }
  
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear(); _visitables.remove("groups"); }
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  
  public boolean hasGroups() {
    return this.groups != null && !this.groups.isEmpty();
  }
  
  public A addToLabels(int index,LabelSelector item) {
    if (this.labels == null) {this.labels = new ArrayList<LabelSelectorBuilder>();}
    LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
    if (index < 0 || index >= labels.size()) { _visitables.get("labels").add(builder); labels.add(builder); } else { _visitables.get("labels").add(index, builder); labels.add(index, builder);}
    return (A)this;
  }
  
  public A setToLabels(int index,LabelSelector item) {
    if (this.labels == null) {this.labels = new ArrayList<LabelSelectorBuilder>();}
    LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
    if (index < 0 || index >= labels.size()) { _visitables.get("labels").add(builder); labels.add(builder); } else { _visitables.get("labels").set(index, builder); labels.set(index, builder);}
    return (A)this;
  }
  
  public A addToLabels(io.fabric8.kubernetes.api.model.LabelSelector... items) {
    if (this.labels == null) {this.labels = new ArrayList<LabelSelectorBuilder>();}
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("labels").add(builder);this.labels.add(builder);} return (A)this;
  }
  
  public A addAllToLabels(Collection<LabelSelector> items) {
    if (this.labels == null) {this.labels = new ArrayList<LabelSelectorBuilder>();}
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("labels").add(builder);this.labels.add(builder);} return (A)this;
  }
  
  public A removeFromLabels(io.fabric8.kubernetes.api.model.LabelSelector... items) {
    if (this.labels == null) return (A)this;
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("labels").remove(builder); this.labels.remove(builder);} return (A)this;
  }
  
  public A removeAllFromLabels(Collection<LabelSelector> items) {
    if (this.labels == null) return (A)this;
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("labels").remove(builder); this.labels.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromLabels(Predicate<LabelSelectorBuilder> predicate) {
    if (labels == null) return (A) this;
    final Iterator<LabelSelectorBuilder> each = labels.iterator();
    final List visitables = _visitables.get("labels");
    while (each.hasNext()) {
      LabelSelectorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LabelSelector> buildLabels() {
    return this.labels != null ? build(labels) : null;
  }
  
  public LabelSelector buildLabel(int index) {
    return this.labels.get(index).build();
  }
  
  public LabelSelector buildFirstLabel() {
    return this.labels.get(0).build();
  }
  
  public LabelSelector buildLastLabel() {
    return this.labels.get(labels.size() - 1).build();
  }
  
  public LabelSelector buildMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
      for (LabelSelectorBuilder item : labels) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
      for (LabelSelectorBuilder item : labels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withLabels(List<LabelSelector> labels) {
    if (this.labels != null) {
      this._visitables.get("labels").clear();
    }
    if (labels != null) {
        this.labels = new ArrayList();
        for (LabelSelector item : labels) {
          this.addToLabels(item);
        }
    } else {
      this.labels = null;
    }
    return (A) this;
  }
  
  public A withLabels(io.fabric8.kubernetes.api.model.LabelSelector... labels) {
    if (this.labels != null) {this.labels.clear(); _visitables.remove("labels"); }
    if (labels != null) {for (LabelSelector item :labels){ this.addToLabels(item);}} return (A) this;
  }
  
  public boolean hasLabels() {
    return this.labels != null && !this.labels.isEmpty();
  }
  
  public LabelsNested<A> addNewLabel() {
    return new LabelsNested(-1, null);
  }
  
  public LabelsNested<A> addNewLabelLike(LabelSelector item) {
    return new LabelsNested(-1, item);
  }
  
  public LabelsNested<A> setNewLabelLike(int index,LabelSelector item) {
    return new LabelsNested(index, item);
  }
  
  public LabelsNested<A> editLabel(int index) {
    if (labels.size() <= index) throw new RuntimeException("Can't edit labels. Index exceeds size.");
    return setNewLabelLike(index, buildLabel(index));
  }
  
  public LabelsNested<A> editFirstLabel() {
    if (labels.size() == 0) throw new RuntimeException("Can't edit first labels. The list is empty.");
    return setNewLabelLike(0, buildLabel(0));
  }
  
  public LabelsNested<A> editLastLabel() {
    int index = labels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last labels. The list is empty.");
    return setNewLabelLike(index, buildLabel(index));
  }
  
  public LabelsNested<A> editMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<labels.size();i++) { 
    if (predicate.test(labels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching labels. No match found.");
    return setNewLabelLike(index, buildLabel(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GroupRestrictionFluent that = (GroupRestrictionFluent) o;
    if (!java.util.Objects.equals(groups, that.groups)) return false;
    if (!java.util.Objects.equals(labels, that.labels)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(groups,  labels,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class LabelsNested<N> extends LabelSelectorFluent<LabelsNested<N>> implements Nested<N>{
    LabelsNested(int index,LabelSelector item) {
      this.index = index;
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    int index;
    
    public N and() {
      return (N) GroupRestrictionFluent.this.setToLabels(index,builder.build());
    }
    
    public N endLabel() {
      return and();
    }
    
  
  }

}