package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CustomBuildStrategyFluent<A extends CustomBuildStrategyFluent<A>> extends BaseFluent<A>{
  public CustomBuildStrategyFluent() {
  }
  
  public CustomBuildStrategyFluent(CustomBuildStrategy instance) {
    this.copyInstance(instance);
  }
  private String buildAPIVersion;
  private List<EnvVar> env = new ArrayList<EnvVar>();
  private Boolean exposeDockerSocket;
  private Boolean forcePull;
  private ObjectReferenceBuilder from;
  private LocalObjectReferenceBuilder pullSecret;
  private ArrayList<SecretSpecBuilder> secrets = new ArrayList<SecretSpecBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CustomBuildStrategy instance) {
    instance = (instance != null ? instance : new CustomBuildStrategy());
    if (instance != null) {
          this.withBuildAPIVersion(instance.getBuildAPIVersion());
          this.withEnv(instance.getEnv());
          this.withExposeDockerSocket(instance.getExposeDockerSocket());
          this.withForcePull(instance.getForcePull());
          this.withFrom(instance.getFrom());
          this.withPullSecret(instance.getPullSecret());
          this.withSecrets(instance.getSecrets());
          this.withBuildAPIVersion(instance.getBuildAPIVersion());
          this.withEnv(instance.getEnv());
          this.withExposeDockerSocket(instance.getExposeDockerSocket());
          this.withForcePull(instance.getForcePull());
          this.withFrom(instance.getFrom());
          this.withPullSecret(instance.getPullSecret());
          this.withSecrets(instance.getSecrets());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBuildAPIVersion() {
    return this.buildAPIVersion;
  }
  
  public A withBuildAPIVersion(String buildAPIVersion) {
    this.buildAPIVersion = buildAPIVersion;
    return (A) this;
  }
  
  public boolean hasBuildAPIVersion() {
    return this.buildAPIVersion != null;
  }
  
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) return (A)this;
    for (EnvVar item : items) { this.env.remove(item);} return (A)this;
  }
  
  public A removeAllFromEnv(Collection<EnvVar> items) {
    if (this.env == null) return (A)this;
    for (EnvVar item : items) { this.env.remove(item);} return (A)this;
  }
  
  public List<EnvVar> getEnv() {
    return this.env;
  }
  
  public EnvVar getEnv(int index) {
    return this.env.get(index);
  }
  
  public EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  
  public EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  
  public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
      for (EnvVar item : env) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
      for (EnvVar item : env) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnv(List<EnvVar> env) {
    if (env != null) {
        this.env = new ArrayList();
        for (EnvVar item : env) {
          this.addToEnv(item);
        }
    } else {
      this.env = null;
    }
    return (A) this;
  }
  
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  
  public boolean hasEnv() {
    return this.env != null && !this.env.isEmpty();
  }
  
  public Boolean getExposeDockerSocket() {
    return this.exposeDockerSocket;
  }
  
  public A withExposeDockerSocket(Boolean exposeDockerSocket) {
    this.exposeDockerSocket = exposeDockerSocket;
    return (A) this;
  }
  
  public boolean hasExposeDockerSocket() {
    return this.exposeDockerSocket != null;
  }
  
  public Boolean getForcePull() {
    return this.forcePull;
  }
  
  public A withForcePull(Boolean forcePull) {
    this.forcePull = forcePull;
    return (A) this;
  }
  
  public boolean hasForcePull() {
    return this.forcePull != null;
  }
  
  public ObjectReference buildFrom() {
    return this.from != null ? this.from.build() : null;
  }
  
  public A withFrom(ObjectReference from) {
    this._visitables.remove(this.from);
    if (from != null) {
        this.from = new ObjectReferenceBuilder(from);
        this._visitables.get("from").add(this.from);
    } else {
        this.from = null;
        this._visitables.get("from").remove(this.from);
    }
    return (A) this;
  }
  
  public boolean hasFrom() {
    return this.from != null;
  }
  
  public FromNested<A> withNewFrom() {
    return new FromNested(null);
  }
  
  public FromNested<A> withNewFromLike(ObjectReference item) {
    return new FromNested(item);
  }
  
  public FromNested<A> editFrom() {
    return withNewFromLike(java.util.Optional.ofNullable(buildFrom()).orElse(null));
  }
  
  public FromNested<A> editOrNewFrom() {
    return withNewFromLike(java.util.Optional.ofNullable(buildFrom()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public FromNested<A> editOrNewFromLike(ObjectReference item) {
    return withNewFromLike(java.util.Optional.ofNullable(buildFrom()).orElse(item));
  }
  
  public LocalObjectReference buildPullSecret() {
    return this.pullSecret != null ? this.pullSecret.build() : null;
  }
  
  public A withPullSecret(LocalObjectReference pullSecret) {
    this._visitables.remove(this.pullSecret);
    if (pullSecret != null) {
        this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
        this._visitables.get("pullSecret").add(this.pullSecret);
    } else {
        this.pullSecret = null;
        this._visitables.get("pullSecret").remove(this.pullSecret);
    }
    return (A) this;
  }
  
  public boolean hasPullSecret() {
    return this.pullSecret != null;
  }
  
  public A withNewPullSecret(String name) {
    return (A)withPullSecret(new LocalObjectReference(name));
  }
  
  public PullSecretNested<A> withNewPullSecret() {
    return new PullSecretNested(null);
  }
  
  public PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
    return new PullSecretNested(item);
  }
  
  public PullSecretNested<A> editPullSecret() {
    return withNewPullSecretLike(java.util.Optional.ofNullable(buildPullSecret()).orElse(null));
  }
  
  public PullSecretNested<A> editOrNewPullSecret() {
    return withNewPullSecretLike(java.util.Optional.ofNullable(buildPullSecret()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
    return withNewPullSecretLike(java.util.Optional.ofNullable(buildPullSecret()).orElse(item));
  }
  
  public A addToSecrets(int index,SecretSpec item) {
    if (this.secrets == null) {this.secrets = new ArrayList<SecretSpecBuilder>();}
    SecretSpecBuilder builder = new SecretSpecBuilder(item);
    if (index < 0 || index >= secrets.size()) { _visitables.get("secrets").add(builder); secrets.add(builder); } else { _visitables.get("secrets").add(index, builder); secrets.add(index, builder);}
    return (A)this;
  }
  
  public A setToSecrets(int index,SecretSpec item) {
    if (this.secrets == null) {this.secrets = new ArrayList<SecretSpecBuilder>();}
    SecretSpecBuilder builder = new SecretSpecBuilder(item);
    if (index < 0 || index >= secrets.size()) { _visitables.get("secrets").add(builder); secrets.add(builder); } else { _visitables.get("secrets").set(index, builder); secrets.set(index, builder);}
    return (A)this;
  }
  
  public A addToSecrets(io.fabric8.openshift.api.model.SecretSpec... items) {
    if (this.secrets == null) {this.secrets = new ArrayList<SecretSpecBuilder>();}
    for (SecretSpec item : items) {SecretSpecBuilder builder = new SecretSpecBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
  }
  
  public A addAllToSecrets(Collection<SecretSpec> items) {
    if (this.secrets == null) {this.secrets = new ArrayList<SecretSpecBuilder>();}
    for (SecretSpec item : items) {SecretSpecBuilder builder = new SecretSpecBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
  }
  
  public A removeFromSecrets(io.fabric8.openshift.api.model.SecretSpec... items) {
    if (this.secrets == null) return (A)this;
    for (SecretSpec item : items) {SecretSpecBuilder builder = new SecretSpecBuilder(item);_visitables.get("secrets").remove(builder); this.secrets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSecrets(Collection<SecretSpec> items) {
    if (this.secrets == null) return (A)this;
    for (SecretSpec item : items) {SecretSpecBuilder builder = new SecretSpecBuilder(item);_visitables.get("secrets").remove(builder); this.secrets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSecrets(Predicate<SecretSpecBuilder> predicate) {
    if (secrets == null) return (A) this;
    final Iterator<SecretSpecBuilder> each = secrets.iterator();
    final List visitables = _visitables.get("secrets");
    while (each.hasNext()) {
      SecretSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SecretSpec> buildSecrets() {
    return this.secrets != null ? build(secrets) : null;
  }
  
  public SecretSpec buildSecret(int index) {
    return this.secrets.get(index).build();
  }
  
  public SecretSpec buildFirstSecret() {
    return this.secrets.get(0).build();
  }
  
  public SecretSpec buildLastSecret() {
    return this.secrets.get(secrets.size() - 1).build();
  }
  
  public SecretSpec buildMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
      for (SecretSpecBuilder item : secrets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
      for (SecretSpecBuilder item : secrets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSecrets(List<SecretSpec> secrets) {
    if (this.secrets != null) {
      this._visitables.get("secrets").clear();
    }
    if (secrets != null) {
        this.secrets = new ArrayList();
        for (SecretSpec item : secrets) {
          this.addToSecrets(item);
        }
    } else {
      this.secrets = null;
    }
    return (A) this;
  }
  
  public A withSecrets(io.fabric8.openshift.api.model.SecretSpec... secrets) {
    if (this.secrets != null) {this.secrets.clear(); _visitables.remove("secrets"); }
    if (secrets != null) {for (SecretSpec item :secrets){ this.addToSecrets(item);}} return (A) this;
  }
  
  public boolean hasSecrets() {
    return this.secrets != null && !this.secrets.isEmpty();
  }
  
  public SecretsNested<A> addNewSecret() {
    return new SecretsNested(-1, null);
  }
  
  public SecretsNested<A> addNewSecretLike(SecretSpec item) {
    return new SecretsNested(-1, item);
  }
  
  public SecretsNested<A> setNewSecretLike(int index,SecretSpec item) {
    return new SecretsNested(index, item);
  }
  
  public SecretsNested<A> editSecret(int index) {
    if (secrets.size() <= index) throw new RuntimeException("Can't edit secrets. Index exceeds size.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public SecretsNested<A> editFirstSecret() {
    if (secrets.size() == 0) throw new RuntimeException("Can't edit first secrets. The list is empty.");
    return setNewSecretLike(0, buildSecret(0));
  }
  
  public SecretsNested<A> editLastSecret() {
    int index = secrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secrets. The list is empty.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public SecretsNested<A> editMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secrets.size();i++) { 
    if (predicate.test(secrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secrets. No match found.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomBuildStrategyFluent that = (CustomBuildStrategyFluent) o;
    if (!java.util.Objects.equals(buildAPIVersion, that.buildAPIVersion)) return false;
    if (!java.util.Objects.equals(env, that.env)) return false;
    if (!java.util.Objects.equals(exposeDockerSocket, that.exposeDockerSocket)) return false;
    if (!java.util.Objects.equals(forcePull, that.forcePull)) return false;
    if (!java.util.Objects.equals(from, that.from)) return false;
    if (!java.util.Objects.equals(pullSecret, that.pullSecret)) return false;
    if (!java.util.Objects.equals(secrets, that.secrets)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(buildAPIVersion,  env,  exposeDockerSocket,  forcePull,  from,  pullSecret,  secrets,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (buildAPIVersion != null) { sb.append("buildAPIVersion:"); sb.append(buildAPIVersion + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (exposeDockerSocket != null) { sb.append("exposeDockerSocket:"); sb.append(exposeDockerSocket + ","); }
    if (forcePull != null) { sb.append("forcePull:"); sb.append(forcePull + ","); }
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (pullSecret != null) { sb.append("pullSecret:"); sb.append(pullSecret + ","); }
    if (secrets != null && !secrets.isEmpty()) { sb.append("secrets:"); sb.append(secrets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withExposeDockerSocket() {
    return withExposeDockerSocket(true);
  }
  
  public A withForcePull() {
    return withForcePull(true);
  }
  public class FromNested<N> extends ObjectReferenceFluent<FromNested<N>> implements Nested<N>{
    FromNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) CustomBuildStrategyFluent.this.withFrom(builder.build());
    }
    
    public N endFrom() {
      return and();
    }
    
  
  }
  public class PullSecretNested<N> extends LocalObjectReferenceFluent<PullSecretNested<N>> implements Nested<N>{
    PullSecretNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) CustomBuildStrategyFluent.this.withPullSecret(builder.build());
    }
    
    public N endPullSecret() {
      return and();
    }
    
  
  }
  public class SecretsNested<N> extends SecretSpecFluent<SecretsNested<N>> implements Nested<N>{
    SecretsNested(int index,SecretSpec item) {
      this.index = index;
      this.builder = new SecretSpecBuilder(this, item);
    }
    SecretSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) CustomBuildStrategyFluent.this.setToSecrets(index,builder.build());
    }
    
    public N endSecret() {
      return and();
    }
    
  
  }

}