package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildSourceFluent<A extends BuildSourceFluent<A>> extends BaseFluent<A>{
  public BuildSourceFluent() {
  }
  
  public BuildSourceFluent(BuildSource instance) {
    this.copyInstance(instance);
  }
  private BinaryBuildSourceBuilder binary;
  private ArrayList<ConfigMapBuildSourceBuilder> configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();
  private String contextDir;
  private String dockerfile;
  private GitBuildSourceBuilder git;
  private ArrayList<ImageSourceBuilder> images = new ArrayList<ImageSourceBuilder>();
  private ArrayList<SecretBuildSourceBuilder> secrets = new ArrayList<SecretBuildSourceBuilder>();
  private LocalObjectReferenceBuilder sourceSecret;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BuildSource instance) {
    instance = (instance != null ? instance : new BuildSource());
    if (instance != null) {
          this.withBinary(instance.getBinary());
          this.withConfigMaps(instance.getConfigMaps());
          this.withContextDir(instance.getContextDir());
          this.withDockerfile(instance.getDockerfile());
          this.withGit(instance.getGit());
          this.withImages(instance.getImages());
          this.withSecrets(instance.getSecrets());
          this.withSourceSecret(instance.getSourceSecret());
          this.withType(instance.getType());
          this.withBinary(instance.getBinary());
          this.withConfigMaps(instance.getConfigMaps());
          this.withContextDir(instance.getContextDir());
          this.withDockerfile(instance.getDockerfile());
          this.withGit(instance.getGit());
          this.withImages(instance.getImages());
          this.withSecrets(instance.getSecrets());
          this.withSourceSecret(instance.getSourceSecret());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public BinaryBuildSource buildBinary() {
    return this.binary != null ? this.binary.build() : null;
  }
  
  public A withBinary(BinaryBuildSource binary) {
    this._visitables.remove(this.binary);
    if (binary != null) {
        this.binary = new BinaryBuildSourceBuilder(binary);
        this._visitables.get("binary").add(this.binary);
    } else {
        this.binary = null;
        this._visitables.get("binary").remove(this.binary);
    }
    return (A) this;
  }
  
  public boolean hasBinary() {
    return this.binary != null;
  }
  
  public A withNewBinary(String asFile) {
    return (A)withBinary(new BinaryBuildSource(asFile));
  }
  
  public BinaryNested<A> withNewBinary() {
    return new BinaryNested(null);
  }
  
  public BinaryNested<A> withNewBinaryLike(BinaryBuildSource item) {
    return new BinaryNested(item);
  }
  
  public BinaryNested<A> editBinary() {
    return withNewBinaryLike(java.util.Optional.ofNullable(buildBinary()).orElse(null));
  }
  
  public BinaryNested<A> editOrNewBinary() {
    return withNewBinaryLike(java.util.Optional.ofNullable(buildBinary()).orElse(new BinaryBuildSourceBuilder().build()));
  }
  
  public BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item) {
    return withNewBinaryLike(java.util.Optional.ofNullable(buildBinary()).orElse(item));
  }
  
  public A addToConfigMaps(int index,ConfigMapBuildSource item) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();}
    ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
    if (index < 0 || index >= configMaps.size()) { _visitables.get("configMaps").add(builder); configMaps.add(builder); } else { _visitables.get("configMaps").add(index, builder); configMaps.add(index, builder);}
    return (A)this;
  }
  
  public A setToConfigMaps(int index,ConfigMapBuildSource item) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();}
    ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
    if (index < 0 || index >= configMaps.size()) { _visitables.get("configMaps").add(builder); configMaps.add(builder); } else { _visitables.get("configMaps").set(index, builder); configMaps.set(index, builder);}
    return (A)this;
  }
  
  public A addToConfigMaps(io.fabric8.openshift.api.model.ConfigMapBuildSource... items) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();}
    for (ConfigMapBuildSource item : items) {ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);_visitables.get("configMaps").add(builder);this.configMaps.add(builder);} return (A)this;
  }
  
  public A addAllToConfigMaps(Collection<ConfigMapBuildSource> items) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();}
    for (ConfigMapBuildSource item : items) {ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);_visitables.get("configMaps").add(builder);this.configMaps.add(builder);} return (A)this;
  }
  
  public A removeFromConfigMaps(io.fabric8.openshift.api.model.ConfigMapBuildSource... items) {
    if (this.configMaps == null) return (A)this;
    for (ConfigMapBuildSource item : items) {ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);_visitables.get("configMaps").remove(builder); this.configMaps.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConfigMaps(Collection<ConfigMapBuildSource> items) {
    if (this.configMaps == null) return (A)this;
    for (ConfigMapBuildSource item : items) {ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);_visitables.get("configMaps").remove(builder); this.configMaps.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConfigMaps(Predicate<ConfigMapBuildSourceBuilder> predicate) {
    if (configMaps == null) return (A) this;
    final Iterator<ConfigMapBuildSourceBuilder> each = configMaps.iterator();
    final List visitables = _visitables.get("configMaps");
    while (each.hasNext()) {
      ConfigMapBuildSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ConfigMapBuildSource> buildConfigMaps() {
    return this.configMaps != null ? build(configMaps) : null;
  }
  
  public ConfigMapBuildSource buildConfigMap(int index) {
    return this.configMaps.get(index).build();
  }
  
  public ConfigMapBuildSource buildFirstConfigMap() {
    return this.configMaps.get(0).build();
  }
  
  public ConfigMapBuildSource buildLastConfigMap() {
    return this.configMaps.get(configMaps.size() - 1).build();
  }
  
  public ConfigMapBuildSource buildMatchingConfigMap(Predicate<ConfigMapBuildSourceBuilder> predicate) {
      for (ConfigMapBuildSourceBuilder item : configMaps) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingConfigMap(Predicate<ConfigMapBuildSourceBuilder> predicate) {
      for (ConfigMapBuildSourceBuilder item : configMaps) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConfigMaps(List<ConfigMapBuildSource> configMaps) {
    if (this.configMaps != null) {
      this._visitables.get("configMaps").clear();
    }
    if (configMaps != null) {
        this.configMaps = new ArrayList();
        for (ConfigMapBuildSource item : configMaps) {
          this.addToConfigMaps(item);
        }
    } else {
      this.configMaps = null;
    }
    return (A) this;
  }
  
  public A withConfigMaps(io.fabric8.openshift.api.model.ConfigMapBuildSource... configMaps) {
    if (this.configMaps != null) {this.configMaps.clear(); _visitables.remove("configMaps"); }
    if (configMaps != null) {for (ConfigMapBuildSource item :configMaps){ this.addToConfigMaps(item);}} return (A) this;
  }
  
  public boolean hasConfigMaps() {
    return this.configMaps != null && !this.configMaps.isEmpty();
  }
  
  public ConfigMapsNested<A> addNewConfigMap() {
    return new ConfigMapsNested(-1, null);
  }
  
  public ConfigMapsNested<A> addNewConfigMapLike(ConfigMapBuildSource item) {
    return new ConfigMapsNested(-1, item);
  }
  
  public ConfigMapsNested<A> setNewConfigMapLike(int index,ConfigMapBuildSource item) {
    return new ConfigMapsNested(index, item);
  }
  
  public ConfigMapsNested<A> editConfigMap(int index) {
    if (configMaps.size() <= index) throw new RuntimeException("Can't edit configMaps. Index exceeds size.");
    return setNewConfigMapLike(index, buildConfigMap(index));
  }
  
  public ConfigMapsNested<A> editFirstConfigMap() {
    if (configMaps.size() == 0) throw new RuntimeException("Can't edit first configMaps. The list is empty.");
    return setNewConfigMapLike(0, buildConfigMap(0));
  }
  
  public ConfigMapsNested<A> editLastConfigMap() {
    int index = configMaps.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configMaps. The list is empty.");
    return setNewConfigMapLike(index, buildConfigMap(index));
  }
  
  public ConfigMapsNested<A> editMatchingConfigMap(Predicate<ConfigMapBuildSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configMaps.size();i++) { 
    if (predicate.test(configMaps.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configMaps. No match found.");
    return setNewConfigMapLike(index, buildConfigMap(index));
  }
  
  public String getContextDir() {
    return this.contextDir;
  }
  
  public A withContextDir(String contextDir) {
    this.contextDir = contextDir;
    return (A) this;
  }
  
  public boolean hasContextDir() {
    return this.contextDir != null;
  }
  
  public String getDockerfile() {
    return this.dockerfile;
  }
  
  public A withDockerfile(String dockerfile) {
    this.dockerfile = dockerfile;
    return (A) this;
  }
  
  public boolean hasDockerfile() {
    return this.dockerfile != null;
  }
  
  public GitBuildSource buildGit() {
    return this.git != null ? this.git.build() : null;
  }
  
  public A withGit(GitBuildSource git) {
    this._visitables.remove(this.git);
    if (git != null) {
        this.git = new GitBuildSourceBuilder(git);
        this._visitables.get("git").add(this.git);
    } else {
        this.git = null;
        this._visitables.get("git").remove(this.git);
    }
    return (A) this;
  }
  
  public boolean hasGit() {
    return this.git != null;
  }
  
  public A withNewGit(String httpProxy,String httpsProxy,String noProxy,String ref,String uri) {
    return (A)withGit(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
  }
  
  public GitNested<A> withNewGit() {
    return new GitNested(null);
  }
  
  public GitNested<A> withNewGitLike(GitBuildSource item) {
    return new GitNested(item);
  }
  
  public GitNested<A> editGit() {
    return withNewGitLike(java.util.Optional.ofNullable(buildGit()).orElse(null));
  }
  
  public GitNested<A> editOrNewGit() {
    return withNewGitLike(java.util.Optional.ofNullable(buildGit()).orElse(new GitBuildSourceBuilder().build()));
  }
  
  public GitNested<A> editOrNewGitLike(GitBuildSource item) {
    return withNewGitLike(java.util.Optional.ofNullable(buildGit()).orElse(item));
  }
  
  public A addToImages(int index,ImageSource item) {
    if (this.images == null) {this.images = new ArrayList<ImageSourceBuilder>();}
    ImageSourceBuilder builder = new ImageSourceBuilder(item);
    if (index < 0 || index >= images.size()) { _visitables.get("images").add(builder); images.add(builder); } else { _visitables.get("images").add(index, builder); images.add(index, builder);}
    return (A)this;
  }
  
  public A setToImages(int index,ImageSource item) {
    if (this.images == null) {this.images = new ArrayList<ImageSourceBuilder>();}
    ImageSourceBuilder builder = new ImageSourceBuilder(item);
    if (index < 0 || index >= images.size()) { _visitables.get("images").add(builder); images.add(builder); } else { _visitables.get("images").set(index, builder); images.set(index, builder);}
    return (A)this;
  }
  
  public A addToImages(io.fabric8.openshift.api.model.ImageSource... items) {
    if (this.images == null) {this.images = new ArrayList<ImageSourceBuilder>();}
    for (ImageSource item : items) {ImageSourceBuilder builder = new ImageSourceBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  
  public A addAllToImages(Collection<ImageSource> items) {
    if (this.images == null) {this.images = new ArrayList<ImageSourceBuilder>();}
    for (ImageSource item : items) {ImageSourceBuilder builder = new ImageSourceBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  
  public A removeFromImages(io.fabric8.openshift.api.model.ImageSource... items) {
    if (this.images == null) return (A)this;
    for (ImageSource item : items) {ImageSourceBuilder builder = new ImageSourceBuilder(item);_visitables.get("images").remove(builder); this.images.remove(builder);} return (A)this;
  }
  
  public A removeAllFromImages(Collection<ImageSource> items) {
    if (this.images == null) return (A)this;
    for (ImageSource item : items) {ImageSourceBuilder builder = new ImageSourceBuilder(item);_visitables.get("images").remove(builder); this.images.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromImages(Predicate<ImageSourceBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<ImageSourceBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      ImageSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ImageSource> buildImages() {
    return this.images != null ? build(images) : null;
  }
  
  public ImageSource buildImage(int index) {
    return this.images.get(index).build();
  }
  
  public ImageSource buildFirstImage() {
    return this.images.get(0).build();
  }
  
  public ImageSource buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  
  public ImageSource buildMatchingImage(Predicate<ImageSourceBuilder> predicate) {
      for (ImageSourceBuilder item : images) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingImage(Predicate<ImageSourceBuilder> predicate) {
      for (ImageSourceBuilder item : images) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withImages(List<ImageSource> images) {
    if (this.images != null) {
      this._visitables.get("images").clear();
    }
    if (images != null) {
        this.images = new ArrayList();
        for (ImageSource item : images) {
          this.addToImages(item);
        }
    } else {
      this.images = null;
    }
    return (A) this;
  }
  
  public A withImages(io.fabric8.openshift.api.model.ImageSource... images) {
    if (this.images != null) {this.images.clear(); _visitables.remove("images"); }
    if (images != null) {for (ImageSource item :images){ this.addToImages(item);}} return (A) this;
  }
  
  public boolean hasImages() {
    return this.images != null && !this.images.isEmpty();
  }
  
  public ImagesNested<A> addNewImage() {
    return new ImagesNested(-1, null);
  }
  
  public ImagesNested<A> addNewImageLike(ImageSource item) {
    return new ImagesNested(-1, item);
  }
  
  public ImagesNested<A> setNewImageLike(int index,ImageSource item) {
    return new ImagesNested(index, item);
  }
  
  public ImagesNested<A> editImage(int index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  
  public ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  
  public ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  
  public ImagesNested<A> editMatchingImage(Predicate<ImageSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  
  public A addToSecrets(int index,SecretBuildSource item) {
    if (this.secrets == null) {this.secrets = new ArrayList<SecretBuildSourceBuilder>();}
    SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
    if (index < 0 || index >= secrets.size()) { _visitables.get("secrets").add(builder); secrets.add(builder); } else { _visitables.get("secrets").add(index, builder); secrets.add(index, builder);}
    return (A)this;
  }
  
  public A setToSecrets(int index,SecretBuildSource item) {
    if (this.secrets == null) {this.secrets = new ArrayList<SecretBuildSourceBuilder>();}
    SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
    if (index < 0 || index >= secrets.size()) { _visitables.get("secrets").add(builder); secrets.add(builder); } else { _visitables.get("secrets").set(index, builder); secrets.set(index, builder);}
    return (A)this;
  }
  
  public A addToSecrets(io.fabric8.openshift.api.model.SecretBuildSource... items) {
    if (this.secrets == null) {this.secrets = new ArrayList<SecretBuildSourceBuilder>();}
    for (SecretBuildSource item : items) {SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
  }
  
  public A addAllToSecrets(Collection<SecretBuildSource> items) {
    if (this.secrets == null) {this.secrets = new ArrayList<SecretBuildSourceBuilder>();}
    for (SecretBuildSource item : items) {SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
  }
  
  public A removeFromSecrets(io.fabric8.openshift.api.model.SecretBuildSource... items) {
    if (this.secrets == null) return (A)this;
    for (SecretBuildSource item : items) {SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);_visitables.get("secrets").remove(builder); this.secrets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSecrets(Collection<SecretBuildSource> items) {
    if (this.secrets == null) return (A)this;
    for (SecretBuildSource item : items) {SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);_visitables.get("secrets").remove(builder); this.secrets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSecrets(Predicate<SecretBuildSourceBuilder> predicate) {
    if (secrets == null) return (A) this;
    final Iterator<SecretBuildSourceBuilder> each = secrets.iterator();
    final List visitables = _visitables.get("secrets");
    while (each.hasNext()) {
      SecretBuildSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SecretBuildSource> buildSecrets() {
    return this.secrets != null ? build(secrets) : null;
  }
  
  public SecretBuildSource buildSecret(int index) {
    return this.secrets.get(index).build();
  }
  
  public SecretBuildSource buildFirstSecret() {
    return this.secrets.get(0).build();
  }
  
  public SecretBuildSource buildLastSecret() {
    return this.secrets.get(secrets.size() - 1).build();
  }
  
  public SecretBuildSource buildMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
      for (SecretBuildSourceBuilder item : secrets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
      for (SecretBuildSourceBuilder item : secrets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSecrets(List<SecretBuildSource> secrets) {
    if (this.secrets != null) {
      this._visitables.get("secrets").clear();
    }
    if (secrets != null) {
        this.secrets = new ArrayList();
        for (SecretBuildSource item : secrets) {
          this.addToSecrets(item);
        }
    } else {
      this.secrets = null;
    }
    return (A) this;
  }
  
  public A withSecrets(io.fabric8.openshift.api.model.SecretBuildSource... secrets) {
    if (this.secrets != null) {this.secrets.clear(); _visitables.remove("secrets"); }
    if (secrets != null) {for (SecretBuildSource item :secrets){ this.addToSecrets(item);}} return (A) this;
  }
  
  public boolean hasSecrets() {
    return this.secrets != null && !this.secrets.isEmpty();
  }
  
  public SecretsNested<A> addNewSecret() {
    return new SecretsNested(-1, null);
  }
  
  public SecretsNested<A> addNewSecretLike(SecretBuildSource item) {
    return new SecretsNested(-1, item);
  }
  
  public SecretsNested<A> setNewSecretLike(int index,SecretBuildSource item) {
    return new SecretsNested(index, item);
  }
  
  public SecretsNested<A> editSecret(int index) {
    if (secrets.size() <= index) throw new RuntimeException("Can't edit secrets. Index exceeds size.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public SecretsNested<A> editFirstSecret() {
    if (secrets.size() == 0) throw new RuntimeException("Can't edit first secrets. The list is empty.");
    return setNewSecretLike(0, buildSecret(0));
  }
  
  public SecretsNested<A> editLastSecret() {
    int index = secrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secrets. The list is empty.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public SecretsNested<A> editMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secrets.size();i++) { 
    if (predicate.test(secrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secrets. No match found.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public LocalObjectReference buildSourceSecret() {
    return this.sourceSecret != null ? this.sourceSecret.build() : null;
  }
  
  public A withSourceSecret(LocalObjectReference sourceSecret) {
    this._visitables.remove(this.sourceSecret);
    if (sourceSecret != null) {
        this.sourceSecret = new LocalObjectReferenceBuilder(sourceSecret);
        this._visitables.get("sourceSecret").add(this.sourceSecret);
    } else {
        this.sourceSecret = null;
        this._visitables.get("sourceSecret").remove(this.sourceSecret);
    }
    return (A) this;
  }
  
  public boolean hasSourceSecret() {
    return this.sourceSecret != null;
  }
  
  public A withNewSourceSecret(String name) {
    return (A)withSourceSecret(new LocalObjectReference(name));
  }
  
  public SourceSecretNested<A> withNewSourceSecret() {
    return new SourceSecretNested(null);
  }
  
  public SourceSecretNested<A> withNewSourceSecretLike(LocalObjectReference item) {
    return new SourceSecretNested(item);
  }
  
  public SourceSecretNested<A> editSourceSecret() {
    return withNewSourceSecretLike(java.util.Optional.ofNullable(buildSourceSecret()).orElse(null));
  }
  
  public SourceSecretNested<A> editOrNewSourceSecret() {
    return withNewSourceSecretLike(java.util.Optional.ofNullable(buildSourceSecret()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public SourceSecretNested<A> editOrNewSourceSecretLike(LocalObjectReference item) {
    return withNewSourceSecretLike(java.util.Optional.ofNullable(buildSourceSecret()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildSourceFluent that = (BuildSourceFluent) o;
    if (!java.util.Objects.equals(binary, that.binary)) return false;
    if (!java.util.Objects.equals(configMaps, that.configMaps)) return false;
    if (!java.util.Objects.equals(contextDir, that.contextDir)) return false;
    if (!java.util.Objects.equals(dockerfile, that.dockerfile)) return false;
    if (!java.util.Objects.equals(git, that.git)) return false;
    if (!java.util.Objects.equals(images, that.images)) return false;
    if (!java.util.Objects.equals(secrets, that.secrets)) return false;
    if (!java.util.Objects.equals(sourceSecret, that.sourceSecret)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(binary,  configMaps,  contextDir,  dockerfile,  git,  images,  secrets,  sourceSecret,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (binary != null) { sb.append("binary:"); sb.append(binary + ","); }
    if (configMaps != null && !configMaps.isEmpty()) { sb.append("configMaps:"); sb.append(configMaps + ","); }
    if (contextDir != null) { sb.append("contextDir:"); sb.append(contextDir + ","); }
    if (dockerfile != null) { sb.append("dockerfile:"); sb.append(dockerfile + ","); }
    if (git != null) { sb.append("git:"); sb.append(git + ","); }
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (secrets != null && !secrets.isEmpty()) { sb.append("secrets:"); sb.append(secrets + ","); }
    if (sourceSecret != null) { sb.append("sourceSecret:"); sb.append(sourceSecret + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BinaryNested<N> extends BinaryBuildSourceFluent<BinaryNested<N>> implements Nested<N>{
    BinaryNested(BinaryBuildSource item) {
      this.builder = new BinaryBuildSourceBuilder(this, item);
    }
    BinaryBuildSourceBuilder builder;
    
    public N and() {
      return (N) BuildSourceFluent.this.withBinary(builder.build());
    }
    
    public N endBinary() {
      return and();
    }
    
  
  }
  public class ConfigMapsNested<N> extends ConfigMapBuildSourceFluent<ConfigMapsNested<N>> implements Nested<N>{
    ConfigMapsNested(int index,ConfigMapBuildSource item) {
      this.index = index;
      this.builder = new ConfigMapBuildSourceBuilder(this, item);
    }
    ConfigMapBuildSourceBuilder builder;
    int index;
    
    public N and() {
      return (N) BuildSourceFluent.this.setToConfigMaps(index,builder.build());
    }
    
    public N endConfigMap() {
      return and();
    }
    
  
  }
  public class GitNested<N> extends GitBuildSourceFluent<GitNested<N>> implements Nested<N>{
    GitNested(GitBuildSource item) {
      this.builder = new GitBuildSourceBuilder(this, item);
    }
    GitBuildSourceBuilder builder;
    
    public N and() {
      return (N) BuildSourceFluent.this.withGit(builder.build());
    }
    
    public N endGit() {
      return and();
    }
    
  
  }
  public class ImagesNested<N> extends ImageSourceFluent<ImagesNested<N>> implements Nested<N>{
    ImagesNested(int index,ImageSource item) {
      this.index = index;
      this.builder = new ImageSourceBuilder(this, item);
    }
    ImageSourceBuilder builder;
    int index;
    
    public N and() {
      return (N) BuildSourceFluent.this.setToImages(index,builder.build());
    }
    
    public N endImage() {
      return and();
    }
    
  
  }
  public class SecretsNested<N> extends SecretBuildSourceFluent<SecretsNested<N>> implements Nested<N>{
    SecretsNested(int index,SecretBuildSource item) {
      this.index = index;
      this.builder = new SecretBuildSourceBuilder(this, item);
    }
    SecretBuildSourceBuilder builder;
    int index;
    
    public N and() {
      return (N) BuildSourceFluent.this.setToSecrets(index,builder.build());
    }
    
    public N endSecret() {
      return and();
    }
    
  
  }
  public class SourceSecretNested<N> extends LocalObjectReferenceFluent<SourceSecretNested<N>> implements Nested<N>{
    SourceSecretNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) BuildSourceFluent.this.withSourceSecret(builder.build());
    }
    
    public N endSourceSecret() {
      return and();
    }
    
  
  }

}