package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TemplateInstanceStatusFluent<A extends TemplateInstanceStatusFluent<A>> extends BaseFluent<A>{
  public TemplateInstanceStatusFluent() {
  }
  
  public TemplateInstanceStatusFluent(TemplateInstanceStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<TemplateInstanceConditionBuilder> conditions = new ArrayList<TemplateInstanceConditionBuilder>();
  private ArrayList<TemplateInstanceObjectBuilder> objects = new ArrayList<TemplateInstanceObjectBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TemplateInstanceStatus instance) {
    instance = (instance != null ? instance : new TemplateInstanceStatus());
  
    if (instance != null) {
        this.withConditions(instance.getConditions());
        this.withObjects(instance.getObjects());
        this.withConditions(instance.getConditions());
        this.withObjects(instance.getObjects());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToConditions(int index,TemplateInstanceCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<TemplateInstanceConditionBuilder>();}
    TemplateInstanceConditionBuilder builder = new TemplateInstanceConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,TemplateInstanceCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<TemplateInstanceConditionBuilder>();}
    TemplateInstanceConditionBuilder builder = new TemplateInstanceConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.TemplateInstanceCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<TemplateInstanceConditionBuilder>();}
    for (TemplateInstanceCondition item : items) {TemplateInstanceConditionBuilder builder = new TemplateInstanceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<TemplateInstanceCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<TemplateInstanceConditionBuilder>();}
    for (TemplateInstanceCondition item : items) {TemplateInstanceConditionBuilder builder = new TemplateInstanceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.TemplateInstanceCondition... items) {
    if (this.conditions == null) return (A)this;
    for (TemplateInstanceCondition item : items) {TemplateInstanceConditionBuilder builder = new TemplateInstanceConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<TemplateInstanceCondition> items) {
    if (this.conditions == null) return (A)this;
    for (TemplateInstanceCondition item : items) {TemplateInstanceConditionBuilder builder = new TemplateInstanceConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<TemplateInstanceConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<TemplateInstanceConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      TemplateInstanceConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TemplateInstanceCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  
  public TemplateInstanceCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public TemplateInstanceCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public TemplateInstanceCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public TemplateInstanceCondition buildMatchingCondition(Predicate<TemplateInstanceConditionBuilder> predicate) {
    for (TemplateInstanceConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingCondition(Predicate<TemplateInstanceConditionBuilder> predicate) {
    for (TemplateInstanceConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withConditions(List<TemplateInstanceCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (TemplateInstanceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.TemplateInstanceCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (TemplateInstanceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new TemplateInstanceCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(TemplateInstanceCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,TemplateInstanceCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<TemplateInstanceConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public A addToObjects(int index,TemplateInstanceObject item) {
    if (this.objects == null) {this.objects = new ArrayList<TemplateInstanceObjectBuilder>();}
    TemplateInstanceObjectBuilder builder = new TemplateInstanceObjectBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  
  public A setToObjects(int index,TemplateInstanceObject item) {
    if (this.objects == null) {this.objects = new ArrayList<TemplateInstanceObjectBuilder>();}
    TemplateInstanceObjectBuilder builder = new TemplateInstanceObjectBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  
  public A addToObjects(io.fabric8.openshift.api.model.TemplateInstanceObject... items) {
    if (this.objects == null) {this.objects = new ArrayList<TemplateInstanceObjectBuilder>();}
    for (TemplateInstanceObject item : items) {TemplateInstanceObjectBuilder builder = new TemplateInstanceObjectBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  
  public A addAllToObjects(Collection<TemplateInstanceObject> items) {
    if (this.objects == null) {this.objects = new ArrayList<TemplateInstanceObjectBuilder>();}
    for (TemplateInstanceObject item : items) {TemplateInstanceObjectBuilder builder = new TemplateInstanceObjectBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  
  public A removeFromObjects(io.fabric8.openshift.api.model.TemplateInstanceObject... items) {
    if (this.objects == null) return (A)this;
    for (TemplateInstanceObject item : items) {TemplateInstanceObjectBuilder builder = new TemplateInstanceObjectBuilder(item);_visitables.get("objects").remove(builder); this.objects.remove(builder);} return (A)this;
  }
  
  public A removeAllFromObjects(Collection<TemplateInstanceObject> items) {
    if (this.objects == null) return (A)this;
    for (TemplateInstanceObject item : items) {TemplateInstanceObjectBuilder builder = new TemplateInstanceObjectBuilder(item);_visitables.get("objects").remove(builder); this.objects.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromObjects(Predicate<TemplateInstanceObjectBuilder> predicate) {
    if (objects == null) return (A) this;
    final Iterator<TemplateInstanceObjectBuilder> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      TemplateInstanceObjectBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TemplateInstanceObject> buildObjects() {
    return objects != null ? build(objects) : null;
  }
  
  public TemplateInstanceObject buildObject(int index) {
    return this.objects.get(index).build();
  }
  
  public TemplateInstanceObject buildFirstObject() {
    return this.objects.get(0).build();
  }
  
  public TemplateInstanceObject buildLastObject() {
    return this.objects.get(objects.size() - 1).build();
  }
  
  public TemplateInstanceObject buildMatchingObject(Predicate<TemplateInstanceObjectBuilder> predicate) {
    for (TemplateInstanceObjectBuilder item: objects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingObject(Predicate<TemplateInstanceObjectBuilder> predicate) {
    for (TemplateInstanceObjectBuilder item: objects) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withObjects(List<TemplateInstanceObject> objects) {
    if (this.objects != null) { _visitables.get("objects").clear();}
    if (objects != null) {this.objects = new ArrayList(); for (TemplateInstanceObject item : objects){this.addToObjects(item);}} else { this.objects = null;} return (A) this;
  }
  
  public A withObjects(io.fabric8.openshift.api.model.TemplateInstanceObject... objects) {
    if (this.objects != null) {this.objects.clear(); _visitables.remove("objects"); }
    if (objects != null) {for (TemplateInstanceObject item :objects){ this.addToObjects(item);}} return (A) this;
  }
  
  public boolean hasObjects() {
    return objects != null && !objects.isEmpty();
  }
  
  public ObjectsNested<A> addNewObject() {
    return new ObjectsNested(-1, null);
  }
  
  public ObjectsNested<A> addNewObjectLike(TemplateInstanceObject item) {
    return new ObjectsNested(-1, item);
  }
  
  public ObjectsNested<A> setNewObjectLike(int index,TemplateInstanceObject item) {
    return new ObjectsNested(index, item);
  }
  
  public ObjectsNested<A> editObject(int index) {
    if (objects.size() <= index) throw new RuntimeException("Can't edit objects. Index exceeds size.");
    return setNewObjectLike(index, buildObject(index));
  }
  
  public ObjectsNested<A> editFirstObject() {
    if (objects.size() == 0) throw new RuntimeException("Can't edit first objects. The list is empty.");
    return setNewObjectLike(0, buildObject(0));
  }
  
  public ObjectsNested<A> editLastObject() {
    int index = objects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last objects. The list is empty.");
    return setNewObjectLike(index, buildObject(index));
  }
  
  public ObjectsNested<A> editMatchingObject(Predicate<TemplateInstanceObjectBuilder> predicate) {
    int index = -1;
    for (int i=0;i<objects.size();i++) { 
    if (predicate.test(objects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching objects. No match found.");
    return setNewObjectLike(index, buildObject(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TemplateInstanceStatusFluent that = (TemplateInstanceStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
  
    if (!java.util.Objects.equals(objects, that.objects)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  objects,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (objects != null && !objects.isEmpty()) { sb.append("objects:"); sb.append(objects + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends TemplateInstanceConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,TemplateInstanceCondition item) {
      this.index = index;
      this.builder = new TemplateInstanceConditionBuilder(this, item);
    }
    TemplateInstanceConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) TemplateInstanceStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class ObjectsNested<N> extends TemplateInstanceObjectFluent<ObjectsNested<N>> implements Nested<N>{
    ObjectsNested(int index,TemplateInstanceObject item) {
      this.index = index;
      this.builder = new TemplateInstanceObjectBuilder(this, item);
    }
    TemplateInstanceObjectBuilder builder;
    int index;
    
    public N and() {
      return (N) TemplateInstanceStatusFluent.this.setToObjects(index,builder.build());
    }
    
    public N endObject() {
      return and();
    }
    
  
  }

}