package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TemplateInstanceObjectFluent<A extends TemplateInstanceObjectFluent<A>> extends BaseFluent<A>{
  public TemplateInstanceObjectFluent() {
  }
  
  public TemplateInstanceObjectFluent(TemplateInstanceObject instance) {
    this.copyInstance(instance);
  }
  private ObjectReferenceBuilder ref;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TemplateInstanceObject instance) {
    instance = (instance != null ? instance : new TemplateInstanceObject());
  
    if (instance != null) {
        this.withRef(instance.getRef());
        this.withRef(instance.getRef());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public ObjectReference buildRef() {
    return this.ref!=null ?this.ref.build():null;
  }
  
  public A withRef(ObjectReference ref) {
    _visitables.get("ref").remove(this.ref);
    if (ref!=null){ this.ref= new ObjectReferenceBuilder(ref); _visitables.get("ref").add(this.ref);} else { this.ref = null; _visitables.get("ref").remove(this.ref); } return (A) this;
  }
  
  public boolean hasRef() {
    return this.ref != null;
  }
  
  public RefNested<A> withNewRef() {
    return new RefNested(null);
  }
  
  public RefNested<A> withNewRefLike(ObjectReference item) {
    return new RefNested(item);
  }
  
  public RefNested<A> editRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(null));
  }
  
  public RefNested<A> editOrNewRef() {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public RefNested<A> editOrNewRefLike(ObjectReference item) {
    return withNewRefLike(java.util.Optional.ofNullable(buildRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TemplateInstanceObjectFluent that = (TemplateInstanceObjectFluent) o;
    if (!java.util.Objects.equals(ref, that.ref)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ref,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ref != null) { sb.append("ref:"); sb.append(ref + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RefNested<N> extends ObjectReferenceFluent<RefNested<N>> implements Nested<N>{
    RefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) TemplateInstanceObjectFluent.this.withRef(builder.build());
    }
    
    public N endRef() {
      return and();
    }
    
  
  }

}