package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SignatureSubjectFluent<A extends SignatureSubjectFluent<A>> extends BaseFluent<A>{
  public SignatureSubjectFluent() {
  }
  
  public SignatureSubjectFluent(SignatureSubject instance) {
    this.copyInstance(instance);
  }
  private String commonName;
  private String organization;
  private String publicKeyID;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SignatureSubject instance) {
    instance = (instance != null ? instance : new SignatureSubject());
  
    if (instance != null) {
        this.withCommonName(instance.getCommonName());
        this.withOrganization(instance.getOrganization());
        this.withPublicKeyID(instance.getPublicKeyID());
        this.withCommonName(instance.getCommonName());
        this.withOrganization(instance.getOrganization());
        this.withPublicKeyID(instance.getPublicKeyID());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getCommonName() {
    return this.commonName;
  }
  
  public A withCommonName(String commonName) {
    this.commonName=commonName; return (A) this;
  }
  
  public boolean hasCommonName() {
    return this.commonName != null;
  }
  
  public String getOrganization() {
    return this.organization;
  }
  
  public A withOrganization(String organization) {
    this.organization=organization; return (A) this;
  }
  
  public boolean hasOrganization() {
    return this.organization != null;
  }
  
  public String getPublicKeyID() {
    return this.publicKeyID;
  }
  
  public A withPublicKeyID(String publicKeyID) {
    this.publicKeyID=publicKeyID; return (A) this;
  }
  
  public boolean hasPublicKeyID() {
    return this.publicKeyID != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SignatureSubjectFluent that = (SignatureSubjectFluent) o;
    if (!java.util.Objects.equals(commonName, that.commonName)) return false;
  
    if (!java.util.Objects.equals(organization, that.organization)) return false;
  
    if (!java.util.Objects.equals(publicKeyID, that.publicKeyID)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(commonName,  organization,  publicKeyID,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (commonName != null) { sb.append("commonName:"); sb.append(commonName + ","); }
    if (organization != null) { sb.append("organization:"); sb.append(organization + ","); }
    if (publicKeyID != null) { sb.append("publicKeyID:"); sb.append(publicKeyID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}