package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SignatureIssuerFluent<A extends SignatureIssuerFluent<A>> extends BaseFluent<A>{
  public SignatureIssuerFluent() {
  }
  
  public SignatureIssuerFluent(SignatureIssuer instance) {
    this.copyInstance(instance);
  }
  private String commonName;
  private String organization;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SignatureIssuer instance) {
    instance = (instance != null ? instance : new SignatureIssuer());
  
    if (instance != null) {
        this.withCommonName(instance.getCommonName());
        this.withOrganization(instance.getOrganization());
        this.withCommonName(instance.getCommonName());
        this.withOrganization(instance.getOrganization());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getCommonName() {
    return this.commonName;
  }
  
  public A withCommonName(String commonName) {
    this.commonName=commonName; return (A) this;
  }
  
  public boolean hasCommonName() {
    return this.commonName != null;
  }
  
  public String getOrganization() {
    return this.organization;
  }
  
  public A withOrganization(String organization) {
    this.organization=organization; return (A) this;
  }
  
  public boolean hasOrganization() {
    return this.organization != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SignatureIssuerFluent that = (SignatureIssuerFluent) o;
    if (!java.util.Objects.equals(commonName, that.commonName)) return false;
  
    if (!java.util.Objects.equals(organization, that.organization)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(commonName,  organization,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (commonName != null) { sb.append("commonName:"); sb.append(commonName + ","); }
    if (organization != null) { sb.append("organization:"); sb.append(organization + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}