package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ResourceQuotaStatus;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceQuotaStatusByNamespaceFluent<A extends ResourceQuotaStatusByNamespaceFluent<A>> extends BaseFluent<A>{
  public ResourceQuotaStatusByNamespaceFluent() {
  }
  
  public ResourceQuotaStatusByNamespaceFluent(ResourceQuotaStatusByNamespace instance) {
    this.copyInstance(instance);
  }
  private String namespace;
  private ResourceQuotaStatus status;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceQuotaStatusByNamespace instance) {
    instance = (instance != null ? instance : new ResourceQuotaStatusByNamespace());
  
    if (instance != null) {
        this.withNamespace(instance.getNamespace());
        this.withStatus(instance.getStatus());
        this.withNamespace(instance.getNamespace());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public ResourceQuotaStatus getStatus() {
    return this.status;
  }
  
  public A withStatus(ResourceQuotaStatus status) {
    this.status=status; return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceQuotaStatusByNamespaceFluent that = (ResourceQuotaStatusByNamespaceFluent) o;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
  
    if (!java.util.Objects.equals(status, that.status)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(namespace,  status,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}