package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageStreamSpecFluent<A extends ImageStreamSpecFluent<A>> extends BaseFluent<A>{
  public ImageStreamSpecFluent() {
  }
  
  public ImageStreamSpecFluent(ImageStreamSpec instance) {
    this.copyInstance(instance);
  }
  private String dockerImageRepository;
  private ImageLookupPolicyBuilder lookupPolicy;
  private ArrayList<TagReferenceBuilder> tags = new ArrayList<TagReferenceBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageStreamSpec instance) {
    instance = (instance != null ? instance : new ImageStreamSpec());
  
    if (instance != null) {
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withLookupPolicy(instance.getLookupPolicy());
        this.withTags(instance.getTags());
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withLookupPolicy(instance.getLookupPolicy());
        this.withTags(instance.getTags());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getDockerImageRepository() {
    return this.dockerImageRepository;
  }
  
  public A withDockerImageRepository(String dockerImageRepository) {
    this.dockerImageRepository=dockerImageRepository; return (A) this;
  }
  
  public boolean hasDockerImageRepository() {
    return this.dockerImageRepository != null;
  }
  
  public ImageLookupPolicy buildLookupPolicy() {
    return this.lookupPolicy!=null ?this.lookupPolicy.build():null;
  }
  
  public A withLookupPolicy(ImageLookupPolicy lookupPolicy) {
    _visitables.get("lookupPolicy").remove(this.lookupPolicy);
    if (lookupPolicy!=null){ this.lookupPolicy= new ImageLookupPolicyBuilder(lookupPolicy); _visitables.get("lookupPolicy").add(this.lookupPolicy);} else { this.lookupPolicy = null; _visitables.get("lookupPolicy").remove(this.lookupPolicy); } return (A) this;
  }
  
  public boolean hasLookupPolicy() {
    return this.lookupPolicy != null;
  }
  
  public A withNewLookupPolicy(Boolean local) {
    return (A)withLookupPolicy(new ImageLookupPolicy(local));
  }
  
  public LookupPolicyNested<A> withNewLookupPolicy() {
    return new LookupPolicyNested(null);
  }
  
  public LookupPolicyNested<A> withNewLookupPolicyLike(ImageLookupPolicy item) {
    return new LookupPolicyNested(item);
  }
  
  public LookupPolicyNested<A> editLookupPolicy() {
    return withNewLookupPolicyLike(java.util.Optional.ofNullable(buildLookupPolicy()).orElse(null));
  }
  
  public LookupPolicyNested<A> editOrNewLookupPolicy() {
    return withNewLookupPolicyLike(java.util.Optional.ofNullable(buildLookupPolicy()).orElse(new ImageLookupPolicyBuilder().build()));
  }
  
  public LookupPolicyNested<A> editOrNewLookupPolicyLike(ImageLookupPolicy item) {
    return withNewLookupPolicyLike(java.util.Optional.ofNullable(buildLookupPolicy()).orElse(item));
  }
  
  public A addToTags(int index,TagReference item) {
    if (this.tags == null) {this.tags = new ArrayList<TagReferenceBuilder>();}
    TagReferenceBuilder builder = new TagReferenceBuilder(item);
    if (index < 0 || index >= tags.size()) { _visitables.get("tags").add(builder); tags.add(builder); } else { _visitables.get("tags").add(index, builder); tags.add(index, builder);}
    return (A)this;
  }
  
  public A setToTags(int index,TagReference item) {
    if (this.tags == null) {this.tags = new ArrayList<TagReferenceBuilder>();}
    TagReferenceBuilder builder = new TagReferenceBuilder(item);
    if (index < 0 || index >= tags.size()) { _visitables.get("tags").add(builder); tags.add(builder); } else { _visitables.get("tags").set(index, builder); tags.set(index, builder);}
    return (A)this;
  }
  
  public A addToTags(io.fabric8.openshift.api.model.TagReference... items) {
    if (this.tags == null) {this.tags = new ArrayList<TagReferenceBuilder>();}
    for (TagReference item : items) {TagReferenceBuilder builder = new TagReferenceBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
  }
  
  public A addAllToTags(Collection<TagReference> items) {
    if (this.tags == null) {this.tags = new ArrayList<TagReferenceBuilder>();}
    for (TagReference item : items) {TagReferenceBuilder builder = new TagReferenceBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
  }
  
  public A removeFromTags(io.fabric8.openshift.api.model.TagReference... items) {
    if (this.tags == null) return (A)this;
    for (TagReference item : items) {TagReferenceBuilder builder = new TagReferenceBuilder(item);_visitables.get("tags").remove(builder); this.tags.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTags(Collection<TagReference> items) {
    if (this.tags == null) return (A)this;
    for (TagReference item : items) {TagReferenceBuilder builder = new TagReferenceBuilder(item);_visitables.get("tags").remove(builder); this.tags.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTags(Predicate<TagReferenceBuilder> predicate) {
    if (tags == null) return (A) this;
    final Iterator<TagReferenceBuilder> each = tags.iterator();
    final List visitables = _visitables.get("tags");
    while (each.hasNext()) {
      TagReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TagReference> buildTags() {
    return tags != null ? build(tags) : null;
  }
  
  public TagReference buildTag(int index) {
    return this.tags.get(index).build();
  }
  
  public TagReference buildFirstTag() {
    return this.tags.get(0).build();
  }
  
  public TagReference buildLastTag() {
    return this.tags.get(tags.size() - 1).build();
  }
  
  public TagReference buildMatchingTag(Predicate<TagReferenceBuilder> predicate) {
    for (TagReferenceBuilder item: tags) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingTag(Predicate<TagReferenceBuilder> predicate) {
    for (TagReferenceBuilder item: tags) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withTags(List<TagReference> tags) {
    if (this.tags != null) { _visitables.get("tags").clear();}
    if (tags != null) {this.tags = new ArrayList(); for (TagReference item : tags){this.addToTags(item);}} else { this.tags = null;} return (A) this;
  }
  
  public A withTags(io.fabric8.openshift.api.model.TagReference... tags) {
    if (this.tags != null) {this.tags.clear(); _visitables.remove("tags"); }
    if (tags != null) {for (TagReference item :tags){ this.addToTags(item);}} return (A) this;
  }
  
  public boolean hasTags() {
    return tags != null && !tags.isEmpty();
  }
  
  public TagsNested<A> addNewTag() {
    return new TagsNested(-1, null);
  }
  
  public TagsNested<A> addNewTagLike(TagReference item) {
    return new TagsNested(-1, item);
  }
  
  public TagsNested<A> setNewTagLike(int index,TagReference item) {
    return new TagsNested(index, item);
  }
  
  public TagsNested<A> editTag(int index) {
    if (tags.size() <= index) throw new RuntimeException("Can't edit tags. Index exceeds size.");
    return setNewTagLike(index, buildTag(index));
  }
  
  public TagsNested<A> editFirstTag() {
    if (tags.size() == 0) throw new RuntimeException("Can't edit first tags. The list is empty.");
    return setNewTagLike(0, buildTag(0));
  }
  
  public TagsNested<A> editLastTag() {
    int index = tags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tags. The list is empty.");
    return setNewTagLike(index, buildTag(index));
  }
  
  public TagsNested<A> editMatchingTag(Predicate<TagReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tags.size();i++) { 
    if (predicate.test(tags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tags. No match found.");
    return setNewTagLike(index, buildTag(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStreamSpecFluent that = (ImageStreamSpecFluent) o;
    if (!java.util.Objects.equals(dockerImageRepository, that.dockerImageRepository)) return false;
  
    if (!java.util.Objects.equals(lookupPolicy, that.lookupPolicy)) return false;
  
    if (!java.util.Objects.equals(tags, that.tags)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(dockerImageRepository,  lookupPolicy,  tags,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dockerImageRepository != null) { sb.append("dockerImageRepository:"); sb.append(dockerImageRepository + ","); }
    if (lookupPolicy != null) { sb.append("lookupPolicy:"); sb.append(lookupPolicy + ","); }
    if (tags != null && !tags.isEmpty()) { sb.append("tags:"); sb.append(tags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class LookupPolicyNested<N> extends ImageLookupPolicyFluent<LookupPolicyNested<N>> implements Nested<N>{
    LookupPolicyNested(ImageLookupPolicy item) {
      this.builder = new ImageLookupPolicyBuilder(this, item);
    }
    ImageLookupPolicyBuilder builder;
    
    public N and() {
      return (N) ImageStreamSpecFluent.this.withLookupPolicy(builder.build());
    }
    
    public N endLookupPolicy() {
      return and();
    }
    
  
  }
  public class TagsNested<N> extends TagReferenceFluent<TagsNested<N>> implements Nested<N>{
    TagsNested(int index,TagReference item) {
      this.index = index;
      this.builder = new TagReferenceBuilder(this, item);
    }
    TagReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ImageStreamSpecFluent.this.setToTags(index,builder.build());
    }
    
    public N endTag() {
      return and();
    }
    
  
  }

}