package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ExecNewPodHookFluent<A extends ExecNewPodHookFluent<A>> extends BaseFluent<A>{
  public ExecNewPodHookFluent() {
  }
  
  public ExecNewPodHookFluent(ExecNewPodHook instance) {
    this.copyInstance(instance);
  }
  private List<String> command = new ArrayList<String>();
  private String containerName;
  private List<EnvVar> env = new ArrayList<EnvVar>();
  private List<String> volumes = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ExecNewPodHook instance) {
    instance = (instance != null ? instance : new ExecNewPodHook());
  
    if (instance != null) {
        this.withCommand(instance.getCommand());
        this.withContainerName(instance.getContainerName());
        this.withEnv(instance.getEnv());
        this.withVolumes(instance.getVolumes());
        this.withCommand(instance.getCommand());
        this.withContainerName(instance.getContainerName());
        this.withEnv(instance.getEnv());
        this.withVolumes(instance.getVolumes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.add(index, item);
    return (A)this;
  }
  
  public A setToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.set(index, item); return (A)this;
  }
  
  public A addToCommand(java.lang.String... items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  
  public A addAllToCommand(Collection<String> items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  
  public A removeFromCommand(java.lang.String... items) {
    if (this.command == null) return (A)this;
    for (String item : items) { this.command.remove(item);} return (A)this;
  }
  
  public A removeAllFromCommand(Collection<String> items) {
    if (this.command == null) return (A)this;
    for (String item : items) { this.command.remove(item);} return (A)this;
  }
  
  public List<String> getCommand() {
    return this.command;
  }
  
  public String getCommand(int index) {
    return this.command.get(index);
  }
  
  public String getFirstCommand() {
    return this.command.get(0);
  }
  
  public String getLastCommand() {
    return this.command.get(command.size() - 1);
  }
  
  public String getMatchingCommand(Predicate<String> predicate) {
    for (String item: command) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingCommand(Predicate<String> predicate) {
    for (String item: command) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withCommand(List<String> command) {
    if (command != null) {this.command = new ArrayList(); for (String item : command){this.addToCommand(item);}} else { this.command = null;} return (A) this;
  }
  
  public A withCommand(java.lang.String... command) {
    if (this.command != null) {this.command.clear(); _visitables.remove("command"); }
    if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
  }
  
  public boolean hasCommand() {
    return command != null && !command.isEmpty();
  }
  
  public String getContainerName() {
    return this.containerName;
  }
  
  public A withContainerName(String containerName) {
    this.containerName=containerName; return (A) this;
  }
  
  public boolean hasContainerName() {
    return this.containerName != null;
  }
  
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) return (A)this;
    for (EnvVar item : items) { this.env.remove(item);} return (A)this;
  }
  
  public A removeAllFromEnv(Collection<EnvVar> items) {
    if (this.env == null) return (A)this;
    for (EnvVar item : items) { this.env.remove(item);} return (A)this;
  }
  
  public List<EnvVar> getEnv() {
    return this.env;
  }
  
  public EnvVar getEnv(int index) {
    return this.env.get(index);
  }
  
  public EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  
  public EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  
  public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withEnv(List<EnvVar> env) {
    if (env != null) {this.env = new ArrayList(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  
  public boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  
  public A addToVolumes(int index,String item) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    this.volumes.add(index, item);
    return (A)this;
  }
  
  public A setToVolumes(int index,String item) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    this.volumes.set(index, item); return (A)this;
  }
  
  public A addToVolumes(java.lang.String... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    for (String item : items) {this.volumes.add(item);} return (A)this;
  }
  
  public A addAllToVolumes(Collection<String> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    for (String item : items) {this.volumes.add(item);} return (A)this;
  }
  
  public A removeFromVolumes(java.lang.String... items) {
    if (this.volumes == null) return (A)this;
    for (String item : items) { this.volumes.remove(item);} return (A)this;
  }
  
  public A removeAllFromVolumes(Collection<String> items) {
    if (this.volumes == null) return (A)this;
    for (String item : items) { this.volumes.remove(item);} return (A)this;
  }
  
  public List<String> getVolumes() {
    return this.volumes;
  }
  
  public String getVolume(int index) {
    return this.volumes.get(index);
  }
  
  public String getFirstVolume() {
    return this.volumes.get(0);
  }
  
  public String getLastVolume() {
    return this.volumes.get(volumes.size() - 1);
  }
  
  public String getMatchingVolume(Predicate<String> predicate) {
    for (String item: volumes) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingVolume(Predicate<String> predicate) {
    for (String item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withVolumes(List<String> volumes) {
    if (volumes != null) {this.volumes = new ArrayList(); for (String item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  
  public A withVolumes(java.lang.String... volumes) {
    if (this.volumes != null) {this.volumes.clear(); _visitables.remove("volumes"); }
    if (volumes != null) {for (String item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  
  public boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ExecNewPodHookFluent that = (ExecNewPodHookFluent) o;
    if (!java.util.Objects.equals(command, that.command)) return false;
  
    if (!java.util.Objects.equals(containerName, that.containerName)) return false;
  
    if (!java.util.Objects.equals(env, that.env)) return false;
  
    if (!java.util.Objects.equals(volumes, that.volumes)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(command,  containerName,  env,  volumes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (command != null && !command.isEmpty()) { sb.append("command:"); sb.append(command + ","); }
    if (containerName != null) { sb.append("containerName:"); sb.append(containerName + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}