package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterRoleBindingFluent<A extends ClusterRoleBindingFluent<A>> extends BaseFluent<A>{
  public ClusterRoleBindingFluent() {
  }
  
  public ClusterRoleBindingFluent(ClusterRoleBinding instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private List<String> groupNames = new ArrayList<String>();
  private String kind;
  private ObjectMetaBuilder metadata;
  private ObjectReferenceBuilder roleRef;
  private ArrayList<ObjectReferenceBuilder> subjects = new ArrayList<ObjectReferenceBuilder>();
  private List<String> userNames = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterRoleBinding instance) {
    instance = (instance != null ? instance : new ClusterRoleBinding());
  
    if (instance != null) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroupNames(instance.getGroupNames());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.withUserNames(instance.getUserNames());
        this.withApiVersion(instance.getApiVersion());
        this.withGroupNames(instance.getGroupNames());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.withUserNames(instance.getUserNames());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public A addToGroupNames(int index,String item) {
    if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
    this.groupNames.add(index, item);
    return (A)this;
  }
  
  public A setToGroupNames(int index,String item) {
    if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
    this.groupNames.set(index, item); return (A)this;
  }
  
  public A addToGroupNames(java.lang.String... items) {
    if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
    for (String item : items) {this.groupNames.add(item);} return (A)this;
  }
  
  public A addAllToGroupNames(Collection<String> items) {
    if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
    for (String item : items) {this.groupNames.add(item);} return (A)this;
  }
  
  public A removeFromGroupNames(java.lang.String... items) {
    if (this.groupNames == null) return (A)this;
    for (String item : items) { this.groupNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromGroupNames(Collection<String> items) {
    if (this.groupNames == null) return (A)this;
    for (String item : items) { this.groupNames.remove(item);} return (A)this;
  }
  
  public List<String> getGroupNames() {
    return this.groupNames;
  }
  
  public String getGroupName(int index) {
    return this.groupNames.get(index);
  }
  
  public String getFirstGroupName() {
    return this.groupNames.get(0);
  }
  
  public String getLastGroupName() {
    return this.groupNames.get(groupNames.size() - 1);
  }
  
  public String getMatchingGroupName(Predicate<String> predicate) {
    for (String item: groupNames) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingGroupName(Predicate<String> predicate) {
    for (String item: groupNames) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withGroupNames(List<String> groupNames) {
    if (groupNames != null) {this.groupNames = new ArrayList(); for (String item : groupNames){this.addToGroupNames(item);}} else { this.groupNames = null;} return (A) this;
  }
  
  public A withGroupNames(java.lang.String... groupNames) {
    if (this.groupNames != null) {this.groupNames.clear(); _visitables.remove("groupNames"); }
    if (groupNames != null) {for (String item :groupNames){ this.addToGroupNames(item);}} return (A) this;
  }
  
  public boolean hasGroupNames() {
    return groupNames != null && !groupNames.isEmpty();
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public ObjectReference buildRoleRef() {
    return this.roleRef!=null ?this.roleRef.build():null;
  }
  
  public A withRoleRef(ObjectReference roleRef) {
    _visitables.get("roleRef").remove(this.roleRef);
    if (roleRef!=null){ this.roleRef= new ObjectReferenceBuilder(roleRef); _visitables.get("roleRef").add(this.roleRef);} else { this.roleRef = null; _visitables.get("roleRef").remove(this.roleRef); } return (A) this;
  }
  
  public boolean hasRoleRef() {
    return this.roleRef != null;
  }
  
  public RoleRefNested<A> withNewRoleRef() {
    return new RoleRefNested(null);
  }
  
  public RoleRefNested<A> withNewRoleRefLike(ObjectReference item) {
    return new RoleRefNested(item);
  }
  
  public RoleRefNested<A> editRoleRef() {
    return withNewRoleRefLike(java.util.Optional.ofNullable(buildRoleRef()).orElse(null));
  }
  
  public RoleRefNested<A> editOrNewRoleRef() {
    return withNewRoleRefLike(java.util.Optional.ofNullable(buildRoleRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public RoleRefNested<A> editOrNewRoleRefLike(ObjectReference item) {
    return withNewRoleRefLike(java.util.Optional.ofNullable(buildRoleRef()).orElse(item));
  }
  
  public A addToSubjects(int index,ObjectReference item) {
    if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= subjects.size()) { _visitables.get("subjects").add(builder); subjects.add(builder); } else { _visitables.get("subjects").add(index, builder); subjects.add(index, builder);}
    return (A)this;
  }
  
  public A setToSubjects(int index,ObjectReference item) {
    if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= subjects.size()) { _visitables.get("subjects").add(builder); subjects.add(builder); } else { _visitables.get("subjects").set(index, builder); subjects.set(index, builder);}
    return (A)this;
  }
  
  public A addToSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  
  public A addAllToSubjects(Collection<ObjectReference> items) {
    if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  
  public A removeFromSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.subjects == null) return (A)this;
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").remove(builder); this.subjects.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSubjects(Collection<ObjectReference> items) {
    if (this.subjects == null) return (A)this;
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").remove(builder); this.subjects.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSubjects(Predicate<ObjectReferenceBuilder> predicate) {
    if (subjects == null) return (A) this;
    final Iterator<ObjectReferenceBuilder> each = subjects.iterator();
    final List visitables = _visitables.get("subjects");
    while (each.hasNext()) {
      ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ObjectReference> buildSubjects() {
    return subjects != null ? build(subjects) : null;
  }
  
  public ObjectReference buildSubject(int index) {
    return this.subjects.get(index).build();
  }
  
  public ObjectReference buildFirstSubject() {
    return this.subjects.get(0).build();
  }
  
  public ObjectReference buildLastSubject() {
    return this.subjects.get(subjects.size() - 1).build();
  }
  
  public ObjectReference buildMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: subjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: subjects) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withSubjects(List<ObjectReference> subjects) {
    if (this.subjects != null) { _visitables.get("subjects").clear();}
    if (subjects != null) {this.subjects = new ArrayList(); for (ObjectReference item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
  }
  
  public A withSubjects(io.fabric8.kubernetes.api.model.ObjectReference... subjects) {
    if (this.subjects != null) {this.subjects.clear(); _visitables.remove("subjects"); }
    if (subjects != null) {for (ObjectReference item :subjects){ this.addToSubjects(item);}} return (A) this;
  }
  
  public boolean hasSubjects() {
    return subjects != null && !subjects.isEmpty();
  }
  
  public SubjectsNested<A> addNewSubject() {
    return new SubjectsNested(-1, null);
  }
  
  public SubjectsNested<A> addNewSubjectLike(ObjectReference item) {
    return new SubjectsNested(-1, item);
  }
  
  public SubjectsNested<A> setNewSubjectLike(int index,ObjectReference item) {
    return new SubjectsNested(index, item);
  }
  
  public SubjectsNested<A> editSubject(int index) {
    if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  
  public SubjectsNested<A> editFirstSubject() {
    if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
    return setNewSubjectLike(0, buildSubject(0));
  }
  
  public SubjectsNested<A> editLastSubject() {
    int index = subjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  
  public SubjectsNested<A> editMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subjects.size();i++) { 
    if (predicate.test(subjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  
  public A addToUserNames(int index,String item) {
    if (this.userNames == null) {this.userNames = new ArrayList<String>();}
    this.userNames.add(index, item);
    return (A)this;
  }
  
  public A setToUserNames(int index,String item) {
    if (this.userNames == null) {this.userNames = new ArrayList<String>();}
    this.userNames.set(index, item); return (A)this;
  }
  
  public A addToUserNames(java.lang.String... items) {
    if (this.userNames == null) {this.userNames = new ArrayList<String>();}
    for (String item : items) {this.userNames.add(item);} return (A)this;
  }
  
  public A addAllToUserNames(Collection<String> items) {
    if (this.userNames == null) {this.userNames = new ArrayList<String>();}
    for (String item : items) {this.userNames.add(item);} return (A)this;
  }
  
  public A removeFromUserNames(java.lang.String... items) {
    if (this.userNames == null) return (A)this;
    for (String item : items) { this.userNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromUserNames(Collection<String> items) {
    if (this.userNames == null) return (A)this;
    for (String item : items) { this.userNames.remove(item);} return (A)this;
  }
  
  public List<String> getUserNames() {
    return this.userNames;
  }
  
  public String getUserName(int index) {
    return this.userNames.get(index);
  }
  
  public String getFirstUserName() {
    return this.userNames.get(0);
  }
  
  public String getLastUserName() {
    return this.userNames.get(userNames.size() - 1);
  }
  
  public String getMatchingUserName(Predicate<String> predicate) {
    for (String item: userNames) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingUserName(Predicate<String> predicate) {
    for (String item: userNames) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withUserNames(List<String> userNames) {
    if (userNames != null) {this.userNames = new ArrayList(); for (String item : userNames){this.addToUserNames(item);}} else { this.userNames = null;} return (A) this;
  }
  
  public A withUserNames(java.lang.String... userNames) {
    if (this.userNames != null) {this.userNames.clear(); _visitables.remove("userNames"); }
    if (userNames != null) {for (String item :userNames){ this.addToUserNames(item);}} return (A) this;
  }
  
  public boolean hasUserNames() {
    return userNames != null && !userNames.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterRoleBindingFluent that = (ClusterRoleBindingFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
  
    if (!java.util.Objects.equals(groupNames, that.groupNames)) return false;
  
    if (!java.util.Objects.equals(kind, that.kind)) return false;
  
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
  
    if (!java.util.Objects.equals(roleRef, that.roleRef)) return false;
  
    if (!java.util.Objects.equals(subjects, that.subjects)) return false;
  
    if (!java.util.Objects.equals(userNames, that.userNames)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  groupNames,  kind,  metadata,  roleRef,  subjects,  userNames,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (groupNames != null && !groupNames.isEmpty()) { sb.append("groupNames:"); sb.append(groupNames + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (roleRef != null) { sb.append("roleRef:"); sb.append(roleRef + ","); }
    if (subjects != null && !subjects.isEmpty()) { sb.append("subjects:"); sb.append(subjects + ","); }
    if (userNames != null && !userNames.isEmpty()) { sb.append("userNames:"); sb.append(userNames + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) ClusterRoleBindingFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class RoleRefNested<N> extends ObjectReferenceFluent<RoleRefNested<N>> implements Nested<N>{
    RoleRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterRoleBindingFluent.this.withRoleRef(builder.build());
    }
    
    public N endRoleRef() {
      return and();
    }
    
  
  }
  public class SubjectsNested<N> extends ObjectReferenceFluent<SubjectsNested<N>> implements Nested<N>{
    SubjectsNested(int index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterRoleBindingFluent.this.setToSubjects(index,builder.build());
    }
    
    public N endSubject() {
      return and();
    }
    
  
  }

}