package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebHookTriggerBuilder extends WebHookTriggerFluent<WebHookTriggerBuilder> implements VisitableBuilder<WebHookTrigger,WebHookTriggerBuilder>{
  public WebHookTriggerBuilder() {
    this(false);
  }
  public WebHookTriggerBuilder(Boolean validationEnabled) {
    this(new WebHookTrigger(), validationEnabled);
  }
  public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent) {
    this(fluent, false);
  }
  public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WebHookTrigger(), validationEnabled);
  }
  public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent,WebHookTrigger instance) {
    this(fluent, instance, false);
  }
  public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent,WebHookTrigger instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WebHookTrigger());

    if (instance != null) {
      fluent.withAllowEnv(instance.getAllowEnv());
      fluent.withSecret(instance.getSecret());
      fluent.withSecretReference(instance.getSecretReference());
      fluent.withAllowEnv(instance.getAllowEnv());
      fluent.withSecret(instance.getSecret());
      fluent.withSecretReference(instance.getSecretReference());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WebHookTriggerBuilder(WebHookTrigger instance) {
    this(instance,false);
  }
  public WebHookTriggerBuilder(WebHookTrigger instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WebHookTrigger());

    if (instance != null) {
      this.withAllowEnv(instance.getAllowEnv());
      this.withSecret(instance.getSecret());
      this.withSecretReference(instance.getSecretReference());
      this.withAllowEnv(instance.getAllowEnv());
      this.withSecret(instance.getSecret());
      this.withSecretReference(instance.getSecretReference());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  WebHookTriggerFluent<?> fluent;
  Boolean validationEnabled;
  public WebHookTrigger build() {
    WebHookTrigger buildable = new WebHookTrigger(fluent.getAllowEnv(),fluent.getSecret(),fluent.buildSecretReference());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}