package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TemplateFluent<A extends TemplateFluent<A>> extends BaseFluent<A>{
  public TemplateFluent() {
  }
  public TemplateFluent(Template instance) {
    instance = (instance != null ? instance : new Template());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withLabels(instance.getLabels());
      this.withMessage(instance.getMessage());
      this.withMetadata(instance.getMetadata());
      this.withObjects(instance.getObjects());
      this.withParameters(instance.getParameters());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withLabels(instance.getLabels());
      this.withMessage(instance.getMessage());
      this.withMetadata(instance.getMetadata());
      this.withObjects(instance.getObjects());
      this.withParameters(instance.getParameters());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String kind;
  private Map<String,String> labels;
  private String message;
  private ObjectMetaBuilder metadata;
  private ArrayList<VisitableBuilder<? extends HasMetadata,?>> objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();
  private ArrayList<ParameterBuilder> parameters = new ArrayList<ParameterBuilder>();
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public boolean hasLabels() {
    return this.labels != null;
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public boolean hasMessage() {
    return this.message != null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  public A addToObjects(VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    _visitables.get("objects").add(builder);this.objects.add(builder); return (A)this;
  }
  public A addToObjects(int index,VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A addToObjects(int index,HasMetadata item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    VisitableBuilder<? extends HasMetadata,?> builder = builder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToObjects(int index,HasMetadata item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    VisitableBuilder<? extends HasMetadata,?> builder = builder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToObjects(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HasMetadata item : items) { VisitableBuilder<? extends HasMetadata,?> builder = builder(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
    return (A)this;
  }
  public A addAllToObjects(Collection<HasMetadata> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HasMetadata item : items) { VisitableBuilder<? extends HasMetadata,?> builder = builder(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
    return (A)this;
  }
  public A removeFromObjects(VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.objects == null) return (A)this;
    _visitables.get("objects").remove(builder);this.objects.remove(builder); return (A)this;
  }
  public A removeFromObjects(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    if (this.objects == null) return (A)this;
    for (HasMetadata item : items) {
    VisitableBuilder<? extends HasMetadata,?> builder = builder(item); _visitables.get("objects").remove(builder);this.objects.remove(builder);
    } return (A)this;
  }
  public A removeAllFromObjects(Collection<HasMetadata> items) {
    if (this.objects == null) return (A)this;
    for (HasMetadata item : items) {
    VisitableBuilder<? extends HasMetadata,?> builder = builder(item); _visitables.get("objects").remove(builder);this.objects.remove(builder);
    } return (A)this;
  }
  public A removeMatchingFromObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<HasMetadata> buildObjects() {
    return build(objects);
  }
  public HasMetadata buildObject(int index) {
    return this.objects.get(index).build();
  }
  public HasMetadata buildFirstObject() {
    return this.objects.get(0).build();
  }
  public HasMetadata buildLastObject() {
    return this.objects.get(objects.size() - 1).build();
  }
  public HasMetadata buildMatchingObject(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    for (VisitableBuilder<? extends HasMetadata,?> item: objects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingObject(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    for (VisitableBuilder<? extends HasMetadata,?> item: objects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withObjects(List<HasMetadata> objects) {
    if (objects != null) {this.objects = new ArrayList(); for (HasMetadata item : objects){this.addToObjects(item);}} else { this.objects = null;} return (A) this;
  }
  public A withObjects(io.fabric8.kubernetes.api.model.HasMetadata... objects) {
    if (this.objects != null) {this.objects.clear(); _visitables.remove("objects"); }
    if (objects != null) {for (HasMetadata item :objects){ this.addToObjects(item);}} return (A) this;
  }
  public boolean hasObjects() {
    return objects != null && !objects.isEmpty();
  }
  public ImageStreamImportObjectsNested<A> addNewImageStreamImportObject() {
    return new ImageStreamImportObjectsNested(-1, null);
  }
  public ImageStreamImportObjectsNested<A> addNewImageStreamImportObjectLike(ImageStreamImport item) {
    return new ImageStreamImportObjectsNested(-1, item);
  }
  public ImageStreamImportObjectsNested<A> setNewImageStreamImportObjectLike(int index,ImageStreamImport item) {
    return new ImageStreamImportObjectsNested(index, item);
  }
  public ProjectObjectsNested<A> addNewProjectObject() {
    return new ProjectObjectsNested(-1, null);
  }
  public ProjectObjectsNested<A> addNewProjectObjectLike(Project item) {
    return new ProjectObjectsNested(-1, item);
  }
  public ProjectObjectsNested<A> setNewProjectObjectLike(int index,Project item) {
    return new ProjectObjectsNested(index, item);
  }
  public BuildConfigObjectsNested<A> addNewBuildConfigObject() {
    return new BuildConfigObjectsNested(-1, null);
  }
  public BuildConfigObjectsNested<A> addNewBuildConfigObjectLike(BuildConfig item) {
    return new BuildConfigObjectsNested(-1, item);
  }
  public BuildConfigObjectsNested<A> setNewBuildConfigObjectLike(int index,BuildConfig item) {
    return new BuildConfigObjectsNested(index, item);
  }
  public HelmChartRepositoryObjectsNested<A> addNewHelmChartRepositoryObject() {
    return new HelmChartRepositoryObjectsNested(-1, null);
  }
  public HelmChartRepositoryObjectsNested<A> addNewHelmChartRepositoryObjectLike(HelmChartRepository item) {
    return new HelmChartRepositoryObjectsNested(-1, item);
  }
  public HelmChartRepositoryObjectsNested<A> setNewHelmChartRepositoryObjectLike(int index,HelmChartRepository item) {
    return new HelmChartRepositoryObjectsNested(index, item);
  }
  public RangeAllocationObjectsNested<A> addNewRangeAllocationObject() {
    return new RangeAllocationObjectsNested(-1, null);
  }
  public RangeAllocationObjectsNested<A> addNewRangeAllocationObjectLike(RangeAllocation item) {
    return new RangeAllocationObjectsNested(-1, item);
  }
  public RangeAllocationObjectsNested<A> setNewRangeAllocationObjectLike(int index,RangeAllocation item) {
    return new RangeAllocationObjectsNested(index, item);
  }
  public RouteObjectsNested<A> addNewRouteObject() {
    return new RouteObjectsNested(-1, null);
  }
  public RouteObjectsNested<A> addNewRouteObjectLike(Route item) {
    return new RouteObjectsNested(-1, item);
  }
  public RouteObjectsNested<A> setNewRouteObjectLike(int index,Route item) {
    return new RouteObjectsNested(index, item);
  }
  public ClusterNetworkObjectsNested<A> addNewClusterNetworkObject() {
    return new ClusterNetworkObjectsNested(-1, null);
  }
  public ClusterNetworkObjectsNested<A> addNewClusterNetworkObjectLike(ClusterNetwork item) {
    return new ClusterNetworkObjectsNested(-1, item);
  }
  public ClusterNetworkObjectsNested<A> setNewClusterNetworkObjectLike(int index,ClusterNetwork item) {
    return new ClusterNetworkObjectsNested(index, item);
  }
  public OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObject() {
    return new OAuthAuthorizeTokenObjectsNested(-1, null);
  }
  public OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObjectLike(OAuthAuthorizeToken item) {
    return new OAuthAuthorizeTokenObjectsNested(-1, item);
  }
  public OAuthAuthorizeTokenObjectsNested<A> setNewOAuthAuthorizeTokenObjectLike(int index,OAuthAuthorizeToken item) {
    return new OAuthAuthorizeTokenObjectsNested(index, item);
  }
  public UserOAuthAccessTokenObjectsNested<A> addNewUserOAuthAccessTokenObject() {
    return new UserOAuthAccessTokenObjectsNested(-1, null);
  }
  public UserOAuthAccessTokenObjectsNested<A> addNewUserOAuthAccessTokenObjectLike(UserOAuthAccessToken item) {
    return new UserOAuthAccessTokenObjectsNested(-1, item);
  }
  public UserOAuthAccessTokenObjectsNested<A> setNewUserOAuthAccessTokenObjectLike(int index,UserOAuthAccessToken item) {
    return new UserOAuthAccessTokenObjectsNested(index, item);
  }
  public ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObject() {
    return new ClusterRoleBindingObjectsNested(-1, null);
  }
  public ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObjectLike(ClusterRoleBinding item) {
    return new ClusterRoleBindingObjectsNested(-1, item);
  }
  public ClusterRoleBindingObjectsNested<A> setNewClusterRoleBindingObjectLike(int index,ClusterRoleBinding item) {
    return new ClusterRoleBindingObjectsNested(index, item);
  }
  public ClusterResourceQuotaObjectsNested<A> addNewClusterResourceQuotaObject() {
    return new ClusterResourceQuotaObjectsNested(-1, null);
  }
  public ClusterResourceQuotaObjectsNested<A> addNewClusterResourceQuotaObjectLike(ClusterResourceQuota item) {
    return new ClusterResourceQuotaObjectsNested(-1, item);
  }
  public ClusterResourceQuotaObjectsNested<A> setNewClusterResourceQuotaObjectLike(int index,ClusterResourceQuota item) {
    return new ClusterResourceQuotaObjectsNested(index, item);
  }
  public ProjectRequestObjectsNested<A> addNewProjectRequestObject() {
    return new ProjectRequestObjectsNested(-1, null);
  }
  public ProjectRequestObjectsNested<A> addNewProjectRequestObjectLike(ProjectRequest item) {
    return new ProjectRequestObjectsNested(-1, item);
  }
  public ProjectRequestObjectsNested<A> setNewProjectRequestObjectLike(int index,ProjectRequest item) {
    return new ProjectRequestObjectsNested(index, item);
  }
  public TemplateObjectsNested<A> addNewTemplateObject() {
    return new TemplateObjectsNested(-1, null);
  }
  public TemplateObjectsNested<A> addNewTemplateObjectLike(Template item) {
    return new TemplateObjectsNested(-1, item);
  }
  public TemplateObjectsNested<A> setNewTemplateObjectLike(int index,Template item) {
    return new TemplateObjectsNested(index, item);
  }
  public OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObject() {
    return new OAuthClientAuthorizationObjectsNested(-1, null);
  }
  public OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObjectLike(OAuthClientAuthorization item) {
    return new OAuthClientAuthorizationObjectsNested(-1, item);
  }
  public OAuthClientAuthorizationObjectsNested<A> setNewOAuthClientAuthorizationObjectLike(int index,OAuthClientAuthorization item) {
    return new OAuthClientAuthorizationObjectsNested(index, item);
  }
  public ClusterRoleObjectsNested<A> addNewClusterRoleObject() {
    return new ClusterRoleObjectsNested(-1, null);
  }
  public ClusterRoleObjectsNested<A> addNewClusterRoleObjectLike(ClusterRole item) {
    return new ClusterRoleObjectsNested(-1, item);
  }
  public ClusterRoleObjectsNested<A> setNewClusterRoleObjectLike(int index,ClusterRole item) {
    return new ClusterRoleObjectsNested(index, item);
  }
  public ImageTagObjectsNested<A> addNewImageTagObject() {
    return new ImageTagObjectsNested(-1, null);
  }
  public ImageTagObjectsNested<A> addNewImageTagObjectLike(ImageTag item) {
    return new ImageTagObjectsNested(-1, item);
  }
  public ImageTagObjectsNested<A> setNewImageTagObjectLike(int index,ImageTag item) {
    return new ImageTagObjectsNested(index, item);
  }
  public OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObject() {
    return new OAuthAccessTokenObjectsNested(-1, null);
  }
  public OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObjectLike(OAuthAccessToken item) {
    return new OAuthAccessTokenObjectsNested(-1, item);
  }
  public OAuthAccessTokenObjectsNested<A> setNewOAuthAccessTokenObjectLike(int index,OAuthAccessToken item) {
    return new OAuthAccessTokenObjectsNested(index, item);
  }
  public DeploymentConfigObjectsNested<A> addNewDeploymentConfigObject() {
    return new DeploymentConfigObjectsNested(-1, null);
  }
  public DeploymentConfigObjectsNested<A> addNewDeploymentConfigObjectLike(DeploymentConfig item) {
    return new DeploymentConfigObjectsNested(-1, item);
  }
  public DeploymentConfigObjectsNested<A> setNewDeploymentConfigObjectLike(int index,DeploymentConfig item) {
    return new DeploymentConfigObjectsNested(index, item);
  }
  public RoleBindingObjectsNested<A> addNewRoleBindingObject() {
    return new RoleBindingObjectsNested(-1, null);
  }
  public RoleBindingObjectsNested<A> addNewRoleBindingObjectLike(RoleBinding item) {
    return new RoleBindingObjectsNested(-1, item);
  }
  public RoleBindingObjectsNested<A> setNewRoleBindingObjectLike(int index,RoleBinding item) {
    return new RoleBindingObjectsNested(index, item);
  }
  public ImageObjectsNested<A> addNewImageObject() {
    return new ImageObjectsNested(-1, null);
  }
  public ImageObjectsNested<A> addNewImageObjectLike(Image item) {
    return new ImageObjectsNested(-1, item);
  }
  public ImageObjectsNested<A> setNewImageObjectLike(int index,Image item) {
    return new ImageObjectsNested(index, item);
  }
  public PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObject() {
    return new PersistentVolumeClaimObjectsNested(-1, null);
  }
  public PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObjectLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimObjectsNested(-1, item);
  }
  public PersistentVolumeClaimObjectsNested<A> setNewPersistentVolumeClaimObjectLike(int index,PersistentVolumeClaim item) {
    return new PersistentVolumeClaimObjectsNested(index, item);
  }
  public GenericKubernetesResourceObjectsNested<A> addNewGenericKubernetesResourceObject() {
    return new GenericKubernetesResourceObjectsNested(-1, null);
  }
  public GenericKubernetesResourceObjectsNested<A> addNewGenericKubernetesResourceObjectLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceObjectsNested(-1, item);
  }
  public GenericKubernetesResourceObjectsNested<A> setNewGenericKubernetesResourceObjectLike(int index,GenericKubernetesResource item) {
    return new GenericKubernetesResourceObjectsNested(index, item);
  }
  public ImageStreamMappingObjectsNested<A> addNewImageStreamMappingObject() {
    return new ImageStreamMappingObjectsNested(-1, null);
  }
  public ImageStreamMappingObjectsNested<A> addNewImageStreamMappingObjectLike(ImageStreamMapping item) {
    return new ImageStreamMappingObjectsNested(-1, item);
  }
  public ImageStreamMappingObjectsNested<A> setNewImageStreamMappingObjectLike(int index,ImageStreamMapping item) {
    return new ImageStreamMappingObjectsNested(index, item);
  }
  public RoleObjectsNested<A> addNewRoleObject() {
    return new RoleObjectsNested(-1, null);
  }
  public RoleObjectsNested<A> addNewRoleObjectLike(Role item) {
    return new RoleObjectsNested(-1, item);
  }
  public RoleObjectsNested<A> setNewRoleObjectLike(int index,Role item) {
    return new RoleObjectsNested(index, item);
  }
  public BrokerTemplateInstanceObjectsNested<A> addNewBrokerTemplateInstanceObject() {
    return new BrokerTemplateInstanceObjectsNested(-1, null);
  }
  public BrokerTemplateInstanceObjectsNested<A> addNewBrokerTemplateInstanceObjectLike(BrokerTemplateInstance item) {
    return new BrokerTemplateInstanceObjectsNested(-1, item);
  }
  public BrokerTemplateInstanceObjectsNested<A> setNewBrokerTemplateInstanceObjectLike(int index,BrokerTemplateInstance item) {
    return new BrokerTemplateInstanceObjectsNested(index, item);
  }
  public UserObjectsNested<A> addNewUserObject() {
    return new UserObjectsNested(-1, null);
  }
  public UserObjectsNested<A> addNewUserObjectLike(User item) {
    return new UserObjectsNested(-1, item);
  }
  public UserObjectsNested<A> setNewUserObjectLike(int index,User item) {
    return new UserObjectsNested(index, item);
  }
  public ImageStreamImageObjectsNested<A> addNewImageStreamImageObject() {
    return new ImageStreamImageObjectsNested(-1, null);
  }
  public ImageStreamImageObjectsNested<A> addNewImageStreamImageObjectLike(ImageStreamImage item) {
    return new ImageStreamImageObjectsNested(-1, item);
  }
  public ImageStreamImageObjectsNested<A> setNewImageStreamImageObjectLike(int index,ImageStreamImage item) {
    return new ImageStreamImageObjectsNested(index, item);
  }
  public TemplateInstanceObjectsNested<A> addNewTemplateInstanceObject() {
    return new TemplateInstanceObjectsNested(-1, null);
  }
  public TemplateInstanceObjectsNested<A> addNewTemplateInstanceObjectLike(TemplateInstance item) {
    return new TemplateInstanceObjectsNested(-1, item);
  }
  public TemplateInstanceObjectsNested<A> setNewTemplateInstanceObjectLike(int index,TemplateInstance item) {
    return new TemplateInstanceObjectsNested(index, item);
  }
  public BuildObjectsNested<A> addNewBuildObject() {
    return new BuildObjectsNested(-1, null);
  }
  public BuildObjectsNested<A> addNewBuildObjectLike(Build item) {
    return new BuildObjectsNested(-1, item);
  }
  public BuildObjectsNested<A> setNewBuildObjectLike(int index,Build item) {
    return new BuildObjectsNested(index, item);
  }
  public RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObject() {
    return new RoleBindingRestrictionObjectsNested(-1, null);
  }
  public RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObjectLike(RoleBindingRestriction item) {
    return new RoleBindingRestrictionObjectsNested(-1, item);
  }
  public RoleBindingRestrictionObjectsNested<A> setNewRoleBindingRestrictionObjectLike(int index,RoleBindingRestriction item) {
    return new RoleBindingRestrictionObjectsNested(index, item);
  }
  public ImageStreamTagObjectsNested<A> addNewImageStreamTagObject() {
    return new ImageStreamTagObjectsNested(-1, null);
  }
  public ImageStreamTagObjectsNested<A> addNewImageStreamTagObjectLike(ImageStreamTag item) {
    return new ImageStreamTagObjectsNested(-1, item);
  }
  public ImageStreamTagObjectsNested<A> setNewImageStreamTagObjectLike(int index,ImageStreamTag item) {
    return new ImageStreamTagObjectsNested(index, item);
  }
  public GroupObjectsNested<A> addNewGroupObject() {
    return new GroupObjectsNested(-1, null);
  }
  public GroupObjectsNested<A> addNewGroupObjectLike(Group item) {
    return new GroupObjectsNested(-1, item);
  }
  public GroupObjectsNested<A> setNewGroupObjectLike(int index,Group item) {
    return new GroupObjectsNested(index, item);
  }
  public ImageSignatureObjectsNested<A> addNewImageSignatureObject() {
    return new ImageSignatureObjectsNested(-1, null);
  }
  public ImageSignatureObjectsNested<A> addNewImageSignatureObjectLike(ImageSignature item) {
    return new ImageSignatureObjectsNested(-1, item);
  }
  public ImageSignatureObjectsNested<A> setNewImageSignatureObjectLike(int index,ImageSignature item) {
    return new ImageSignatureObjectsNested(index, item);
  }
  public HostSubnetObjectsNested<A> addNewHostSubnetObject() {
    return new HostSubnetObjectsNested(-1, null);
  }
  public HostSubnetObjectsNested<A> addNewHostSubnetObjectLike(HostSubnet item) {
    return new HostSubnetObjectsNested(-1, item);
  }
  public HostSubnetObjectsNested<A> setNewHostSubnetObjectLike(int index,HostSubnet item) {
    return new HostSubnetObjectsNested(index, item);
  }
  public AppliedClusterResourceQuotaObjectsNested<A> addNewAppliedClusterResourceQuotaObject() {
    return new AppliedClusterResourceQuotaObjectsNested(-1, null);
  }
  public AppliedClusterResourceQuotaObjectsNested<A> addNewAppliedClusterResourceQuotaObjectLike(AppliedClusterResourceQuota item) {
    return new AppliedClusterResourceQuotaObjectsNested(-1, item);
  }
  public AppliedClusterResourceQuotaObjectsNested<A> setNewAppliedClusterResourceQuotaObjectLike(int index,AppliedClusterResourceQuota item) {
    return new AppliedClusterResourceQuotaObjectsNested(index, item);
  }
  public SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObject() {
    return new SecurityContextConstraintsObjectsNested(-1, null);
  }
  public SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObjectLike(SecurityContextConstraints item) {
    return new SecurityContextConstraintsObjectsNested(-1, item);
  }
  public SecurityContextConstraintsObjectsNested<A> setNewSecurityContextConstraintsObjectLike(int index,SecurityContextConstraints item) {
    return new SecurityContextConstraintsObjectsNested(index, item);
  }
  public BuildRequestObjectsNested<A> addNewBuildRequestObject() {
    return new BuildRequestObjectsNested(-1, null);
  }
  public BuildRequestObjectsNested<A> addNewBuildRequestObjectLike(BuildRequest item) {
    return new BuildRequestObjectsNested(-1, item);
  }
  public BuildRequestObjectsNested<A> setNewBuildRequestObjectLike(int index,BuildRequest item) {
    return new BuildRequestObjectsNested(index, item);
  }
  public EgressNetworkPolicyObjectsNested<A> addNewEgressNetworkPolicyObject() {
    return new EgressNetworkPolicyObjectsNested(-1, null);
  }
  public EgressNetworkPolicyObjectsNested<A> addNewEgressNetworkPolicyObjectLike(EgressNetworkPolicy item) {
    return new EgressNetworkPolicyObjectsNested(-1, item);
  }
  public EgressNetworkPolicyObjectsNested<A> setNewEgressNetworkPolicyObjectLike(int index,EgressNetworkPolicy item) {
    return new EgressNetworkPolicyObjectsNested(index, item);
  }
  public NetNamespaceObjectsNested<A> addNewNetNamespaceObject() {
    return new NetNamespaceObjectsNested(-1, null);
  }
  public NetNamespaceObjectsNested<A> addNewNetNamespaceObjectLike(NetNamespace item) {
    return new NetNamespaceObjectsNested(-1, item);
  }
  public NetNamespaceObjectsNested<A> setNewNetNamespaceObjectLike(int index,NetNamespace item) {
    return new NetNamespaceObjectsNested(index, item);
  }
  public UserIdentityMappingObjectsNested<A> addNewUserIdentityMappingObject() {
    return new UserIdentityMappingObjectsNested(-1, null);
  }
  public UserIdentityMappingObjectsNested<A> addNewUserIdentityMappingObjectLike(UserIdentityMapping item) {
    return new UserIdentityMappingObjectsNested(-1, item);
  }
  public UserIdentityMappingObjectsNested<A> setNewUserIdentityMappingObjectLike(int index,UserIdentityMapping item) {
    return new UserIdentityMappingObjectsNested(index, item);
  }
  public ImageStreamObjectsNested<A> addNewImageStreamObject() {
    return new ImageStreamObjectsNested(-1, null);
  }
  public ImageStreamObjectsNested<A> addNewImageStreamObjectLike(ImageStream item) {
    return new ImageStreamObjectsNested(-1, item);
  }
  public ImageStreamObjectsNested<A> setNewImageStreamObjectLike(int index,ImageStream item) {
    return new ImageStreamObjectsNested(index, item);
  }
  public OAuthClientObjectsNested<A> addNewOAuthClientObject() {
    return new OAuthClientObjectsNested(-1, null);
  }
  public OAuthClientObjectsNested<A> addNewOAuthClientObjectLike(OAuthClient item) {
    return new OAuthClientObjectsNested(-1, item);
  }
  public OAuthClientObjectsNested<A> setNewOAuthClientObjectLike(int index,OAuthClient item) {
    return new OAuthClientObjectsNested(index, item);
  }
  public IdentityObjectsNested<A> addNewIdentityObject() {
    return new IdentityObjectsNested(-1, null);
  }
  public IdentityObjectsNested<A> addNewIdentityObjectLike(Identity item) {
    return new IdentityObjectsNested(-1, item);
  }
  public IdentityObjectsNested<A> setNewIdentityObjectLike(int index,Identity item) {
    return new IdentityObjectsNested(index, item);
  }
  public A addToParameters(int index,Parameter item) {
    if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
    ParameterBuilder builder = new ParameterBuilder(item);
    if (index < 0 || index >= parameters.size()) { _visitables.get("parameters").add(builder); parameters.add(builder); } else { _visitables.get("parameters").add(index, builder); parameters.add(index, builder);}
    return (A)this;
  }
  public A setToParameters(int index,Parameter item) {
    if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
    ParameterBuilder builder = new ParameterBuilder(item);
    if (index < 0 || index >= parameters.size()) { _visitables.get("parameters").add(builder); parameters.add(builder); } else { _visitables.get("parameters").set(index, builder); parameters.set(index, builder);}
    return (A)this;
  }
  public A addToParameters(io.fabric8.openshift.api.model.Parameter... items) {
    if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
  }
  public A addAllToParameters(Collection<Parameter> items) {
    if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
  }
  public A removeFromParameters(io.fabric8.openshift.api.model.Parameter... items) {
    if (this.parameters == null) return (A)this;
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").remove(builder); this.parameters.remove(builder);} return (A)this;
  }
  public A removeAllFromParameters(Collection<Parameter> items) {
    if (this.parameters == null) return (A)this;
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").remove(builder); this.parameters.remove(builder);} return (A)this;
  }
  public A removeMatchingFromParameters(Predicate<ParameterBuilder> predicate) {
    if (parameters == null) return (A) this;
    final Iterator<ParameterBuilder> each = parameters.iterator();
    final List visitables = _visitables.get("parameters");
    while (each.hasNext()) {
      ParameterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Parameter> buildParameters() {
    return parameters != null ? build(parameters) : null;
  }
  public Parameter buildParameter(int index) {
    return this.parameters.get(index).build();
  }
  public Parameter buildFirstParameter() {
    return this.parameters.get(0).build();
  }
  public Parameter buildLastParameter() {
    return this.parameters.get(parameters.size() - 1).build();
  }
  public Parameter buildMatchingParameter(Predicate<ParameterBuilder> predicate) {
    for (ParameterBuilder item: parameters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingParameter(Predicate<ParameterBuilder> predicate) {
    for (ParameterBuilder item: parameters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParameters(List<Parameter> parameters) {
    if (this.parameters != null) { _visitables.get("parameters").clear();}
    if (parameters != null) {this.parameters = new ArrayList(); for (Parameter item : parameters){this.addToParameters(item);}} else { this.parameters = null;} return (A) this;
  }
  public A withParameters(io.fabric8.openshift.api.model.Parameter... parameters) {
    if (this.parameters != null) {this.parameters.clear(); _visitables.remove("parameters"); }
    if (parameters != null) {for (Parameter item :parameters){ this.addToParameters(item);}} return (A) this;
  }
  public boolean hasParameters() {
    return parameters != null && !parameters.isEmpty();
  }
  public ParametersNested<A> addNewParameter() {
    return new ParametersNested(-1, null);
  }
  public ParametersNested<A> addNewParameterLike(Parameter item) {
    return new ParametersNested(-1, item);
  }
  public ParametersNested<A> setNewParameterLike(int index,Parameter item) {
    return new ParametersNested(index, item);
  }
  public ParametersNested<A> editParameter(int index) {
    if (parameters.size() <= index) throw new RuntimeException("Can't edit parameters. Index exceeds size.");
    return setNewParameterLike(index, buildParameter(index));
  }
  public ParametersNested<A> editFirstParameter() {
    if (parameters.size() == 0) throw new RuntimeException("Can't edit first parameters. The list is empty.");
    return setNewParameterLike(0, buildParameter(0));
  }
  public ParametersNested<A> editLastParameter() {
    int index = parameters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last parameters. The list is empty.");
    return setNewParameterLike(index, buildParameter(index));
  }
  public ParametersNested<A> editMatchingParameter(Predicate<ParameterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<parameters.size();i++) { 
    if (predicate.test(parameters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching parameters. No match found.");
    return setNewParameterLike(index, buildParameter(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TemplateFluent that = (TemplateFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(labels, that.labels)) return false;

    if (!java.util.Objects.equals(message, that.message)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(objects, that.objects)) return false;

    if (!java.util.Objects.equals(parameters, that.parameters)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  labels,  message,  metadata,  objects,  parameters,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (objects != null && !objects.isEmpty()) { sb.append("objects:"); sb.append(objects + ","); }
    if (parameters != null && !parameters.isEmpty()) { sb.append("parameters:"); sb.append(parameters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.openshift.api.model."+"ImageStreamImport": return (VisitableBuilder<T, ?>)new ImageStreamImportBuilder((ImageStreamImport) item);
    case "io.fabric8.openshift.api.model."+"Project": return (VisitableBuilder<T, ?>)new ProjectBuilder((Project) item);
    case "io.fabric8.openshift.api.model."+"BuildConfig": return (VisitableBuilder<T, ?>)new BuildConfigBuilder((BuildConfig) item);
    case "io.fabric8.openshift.api.model."+"HelmChartRepository": return (VisitableBuilder<T, ?>)new HelmChartRepositoryBuilder((HelmChartRepository) item);
    case "io.fabric8.openshift.api.model."+"RangeAllocation": return (VisitableBuilder<T, ?>)new RangeAllocationBuilder((RangeAllocation) item);
    case "io.fabric8.openshift.api.model."+"Route": return (VisitableBuilder<T, ?>)new RouteBuilder((Route) item);
    case "io.fabric8.openshift.api.model."+"ClusterNetwork": return (VisitableBuilder<T, ?>)new ClusterNetworkBuilder((ClusterNetwork) item);
    case "io.fabric8.openshift.api.model."+"OAuthAuthorizeToken": return (VisitableBuilder<T, ?>)new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken) item);
    case "io.fabric8.openshift.api.model."+"UserOAuthAccessToken": return (VisitableBuilder<T, ?>)new UserOAuthAccessTokenBuilder((UserOAuthAccessToken) item);
    case "io.fabric8.openshift.api.model."+"ClusterRoleBinding": return (VisitableBuilder<T, ?>)new ClusterRoleBindingBuilder((ClusterRoleBinding) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuota": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaBuilder((ClusterResourceQuota) item);
    case "io.fabric8.openshift.api.model."+"ProjectRequest": return (VisitableBuilder<T, ?>)new ProjectRequestBuilder((ProjectRequest) item);
    case "io.fabric8.openshift.api.model."+"Template": return (VisitableBuilder<T, ?>)new TemplateBuilder((Template) item);
    case "io.fabric8.openshift.api.model."+"OAuthClientAuthorization": return (VisitableBuilder<T, ?>)new OAuthClientAuthorizationBuilder((OAuthClientAuthorization) item);
    case "io.fabric8.openshift.api.model."+"ClusterRole": return (VisitableBuilder<T, ?>)new ClusterRoleBuilder((ClusterRole) item);
    case "io.fabric8.openshift.api.model."+"ImageTag": return (VisitableBuilder<T, ?>)new ImageTagBuilder((ImageTag) item);
    case "io.fabric8.openshift.api.model."+"OAuthAccessToken": return (VisitableBuilder<T, ?>)new OAuthAccessTokenBuilder((OAuthAccessToken) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfig": return (VisitableBuilder<T, ?>)new DeploymentConfigBuilder((DeploymentConfig) item);
    case "io.fabric8.openshift.api.model."+"RoleBinding": return (VisitableBuilder<T, ?>)new RoleBindingBuilder((RoleBinding) item);
    case "io.fabric8.openshift.api.model."+"Image": return (VisitableBuilder<T, ?>)new ImageBuilder((Image) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamMapping": return (VisitableBuilder<T, ?>)new ImageStreamMappingBuilder((ImageStreamMapping) item);
    case "io.fabric8.openshift.api.model."+"Role": return (VisitableBuilder<T, ?>)new RoleBuilder((Role) item);
    case "io.fabric8.openshift.api.model."+"BrokerTemplateInstance": return (VisitableBuilder<T, ?>)new BrokerTemplateInstanceBuilder((BrokerTemplateInstance) item);
    case "io.fabric8.openshift.api.model."+"User": return (VisitableBuilder<T, ?>)new UserBuilder((User) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamImage": return (VisitableBuilder<T, ?>)new ImageStreamImageBuilder((ImageStreamImage) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstance": return (VisitableBuilder<T, ?>)new TemplateInstanceBuilder((TemplateInstance) item);
    case "io.fabric8.openshift.api.model."+"Build": return (VisitableBuilder<T, ?>)new BuildBuilder((Build) item);
    case "io.fabric8.openshift.api.model."+"RoleBindingRestriction": return (VisitableBuilder<T, ?>)new RoleBindingRestrictionBuilder((RoleBindingRestriction) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamTag": return (VisitableBuilder<T, ?>)new ImageStreamTagBuilder((ImageStreamTag) item);
    case "io.fabric8.openshift.api.model."+"Group": return (VisitableBuilder<T, ?>)new GroupBuilder((Group) item);
    case "io.fabric8.openshift.api.model."+"ImageSignature": return (VisitableBuilder<T, ?>)new ImageSignatureBuilder((ImageSignature) item);
    case "io.fabric8.openshift.api.model."+"HostSubnet": return (VisitableBuilder<T, ?>)new HostSubnetBuilder((HostSubnet) item);
    case "io.fabric8.openshift.api.model."+"AppliedClusterResourceQuota": return (VisitableBuilder<T, ?>)new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota) item);
    case "io.fabric8.openshift.api.model."+"SecurityContextConstraints": return (VisitableBuilder<T, ?>)new SecurityContextConstraintsBuilder((SecurityContextConstraints) item);
    case "io.fabric8.openshift.api.model."+"BuildRequest": return (VisitableBuilder<T, ?>)new BuildRequestBuilder((BuildRequest) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicy": return (VisitableBuilder<T, ?>)new EgressNetworkPolicyBuilder((EgressNetworkPolicy) item);
    case "io.fabric8.openshift.api.model."+"NetNamespace": return (VisitableBuilder<T, ?>)new NetNamespaceBuilder((NetNamespace) item);
    case "io.fabric8.openshift.api.model."+"UserIdentityMapping": return (VisitableBuilder<T, ?>)new UserIdentityMappingBuilder((UserIdentityMapping) item);
    case "io.fabric8.openshift.api.model."+"ImageStream": return (VisitableBuilder<T, ?>)new ImageStreamBuilder((ImageStream) item);
    case "io.fabric8.openshift.api.model."+"OAuthClient": return (VisitableBuilder<T, ?>)new OAuthClientBuilder((OAuthClient) item);
    case "io.fabric8.openshift.api.model."+"Identity": return (VisitableBuilder<T, ?>)new IdentityBuilder((Identity) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) TemplateFluent.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class ImageStreamImportObjectsNested<N> extends ImageStreamImportFluent<ImageStreamImportObjectsNested<N>> implements Nested<N>{
    ImageStreamImportObjectsNested(int index,ImageStreamImport item) {
      this.index = index;
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endImageStreamImportObject() {
      return and();
    }
    
  }
  public class ProjectObjectsNested<N> extends ProjectFluent<ProjectObjectsNested<N>> implements Nested<N>{
    ProjectObjectsNested(int index,Project item) {
      this.index = index;
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endProjectObject() {
      return and();
    }
    
  }
  public class BuildConfigObjectsNested<N> extends BuildConfigFluent<BuildConfigObjectsNested<N>> implements Nested<N>{
    BuildConfigObjectsNested(int index,BuildConfig item) {
      this.index = index;
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endBuildConfigObject() {
      return and();
    }
    
  }
  public class HelmChartRepositoryObjectsNested<N> extends HelmChartRepositoryFluent<HelmChartRepositoryObjectsNested<N>> implements Nested<N>{
    HelmChartRepositoryObjectsNested(int index,HelmChartRepository item) {
      this.index = index;
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endHelmChartRepositoryObject() {
      return and();
    }
    
  }
  public class RangeAllocationObjectsNested<N> extends RangeAllocationFluent<RangeAllocationObjectsNested<N>> implements Nested<N>{
    RangeAllocationObjectsNested(int index,RangeAllocation item) {
      this.index = index;
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endRangeAllocationObject() {
      return and();
    }
    
  }
  public class RouteObjectsNested<N> extends RouteFluent<RouteObjectsNested<N>> implements Nested<N>{
    RouteObjectsNested(int index,Route item) {
      this.index = index;
      this.builder = new RouteBuilder(this, item);
    }
    RouteBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endRouteObject() {
      return and();
    }
    
  }
  public class ClusterNetworkObjectsNested<N> extends ClusterNetworkFluent<ClusterNetworkObjectsNested<N>> implements Nested<N>{
    ClusterNetworkObjectsNested(int index,ClusterNetwork item) {
      this.index = index;
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endClusterNetworkObject() {
      return and();
    }
    
  }
  public class OAuthAuthorizeTokenObjectsNested<N> extends OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenObjectsNested<N>> implements Nested<N>{
    OAuthAuthorizeTokenObjectsNested(int index,OAuthAuthorizeToken item) {
      this.index = index;
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endOAuthAuthorizeTokenObject() {
      return and();
    }
    
  }
  public class UserOAuthAccessTokenObjectsNested<N> extends UserOAuthAccessTokenFluent<UserOAuthAccessTokenObjectsNested<N>> implements Nested<N>{
    UserOAuthAccessTokenObjectsNested(int index,UserOAuthAccessToken item) {
      this.index = index;
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endUserOAuthAccessTokenObject() {
      return and();
    }
    
  }
  public class ClusterRoleBindingObjectsNested<N> extends ClusterRoleBindingFluent<ClusterRoleBindingObjectsNested<N>> implements Nested<N>{
    ClusterRoleBindingObjectsNested(int index,ClusterRoleBinding item) {
      this.index = index;
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endClusterRoleBindingObject() {
      return and();
    }
    
  }
  public class ClusterResourceQuotaObjectsNested<N> extends ClusterResourceQuotaFluent<ClusterResourceQuotaObjectsNested<N>> implements Nested<N>{
    ClusterResourceQuotaObjectsNested(int index,ClusterResourceQuota item) {
      this.index = index;
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endClusterResourceQuotaObject() {
      return and();
    }
    
  }
  public class ProjectRequestObjectsNested<N> extends ProjectRequestFluent<ProjectRequestObjectsNested<N>> implements Nested<N>{
    ProjectRequestObjectsNested(int index,ProjectRequest item) {
      this.index = index;
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endProjectRequestObject() {
      return and();
    }
    
  }
  public class TemplateObjectsNested<N> extends TemplateFluent<TemplateObjectsNested<N>> implements Nested<N>{
    TemplateObjectsNested(int index,Template item) {
      this.index = index;
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endTemplateObject() {
      return and();
    }
    
  }
  public class OAuthClientAuthorizationObjectsNested<N> extends OAuthClientAuthorizationFluent<OAuthClientAuthorizationObjectsNested<N>> implements Nested<N>{
    OAuthClientAuthorizationObjectsNested(int index,OAuthClientAuthorization item) {
      this.index = index;
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endOAuthClientAuthorizationObject() {
      return and();
    }
    
  }
  public class ClusterRoleObjectsNested<N> extends ClusterRoleFluent<ClusterRoleObjectsNested<N>> implements Nested<N>{
    ClusterRoleObjectsNested(int index,ClusterRole item) {
      this.index = index;
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endClusterRoleObject() {
      return and();
    }
    
  }
  public class ImageTagObjectsNested<N> extends ImageTagFluent<ImageTagObjectsNested<N>> implements Nested<N>{
    ImageTagObjectsNested(int index,ImageTag item) {
      this.index = index;
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endImageTagObject() {
      return and();
    }
    
  }
  public class OAuthAccessTokenObjectsNested<N> extends OAuthAccessTokenFluent<OAuthAccessTokenObjectsNested<N>> implements Nested<N>{
    OAuthAccessTokenObjectsNested(int index,OAuthAccessToken item) {
      this.index = index;
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endOAuthAccessTokenObject() {
      return and();
    }
    
  }
  public class DeploymentConfigObjectsNested<N> extends DeploymentConfigFluent<DeploymentConfigObjectsNested<N>> implements Nested<N>{
    DeploymentConfigObjectsNested(int index,DeploymentConfig item) {
      this.index = index;
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endDeploymentConfigObject() {
      return and();
    }
    
  }
  public class RoleBindingObjectsNested<N> extends RoleBindingFluent<RoleBindingObjectsNested<N>> implements Nested<N>{
    RoleBindingObjectsNested(int index,RoleBinding item) {
      this.index = index;
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endRoleBindingObject() {
      return and();
    }
    
  }
  public class ImageObjectsNested<N> extends ImageFluent<ImageObjectsNested<N>> implements Nested<N>{
    ImageObjectsNested(int index,Image item) {
      this.index = index;
      this.builder = new ImageBuilder(this, item);
    }
    ImageBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endImageObject() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimObjectsNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimObjectsNested<N>> implements Nested<N>{
    PersistentVolumeClaimObjectsNested(int index,PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endPersistentVolumeClaimObject() {
      return and();
    }
    
  }
  public class GenericKubernetesResourceObjectsNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceObjectsNested<N>> implements Nested<N>{
    GenericKubernetesResourceObjectsNested(int index,GenericKubernetesResource item) {
      this.index = index;
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endGenericKubernetesResourceObject() {
      return and();
    }
    
  }
  public class ImageStreamMappingObjectsNested<N> extends ImageStreamMappingFluent<ImageStreamMappingObjectsNested<N>> implements Nested<N>{
    ImageStreamMappingObjectsNested(int index,ImageStreamMapping item) {
      this.index = index;
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endImageStreamMappingObject() {
      return and();
    }
    
  }
  public class RoleObjectsNested<N> extends RoleFluent<RoleObjectsNested<N>> implements Nested<N>{
    RoleObjectsNested(int index,Role item) {
      this.index = index;
      this.builder = new RoleBuilder(this, item);
    }
    RoleBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endRoleObject() {
      return and();
    }
    
  }
  public class BrokerTemplateInstanceObjectsNested<N> extends BrokerTemplateInstanceFluent<BrokerTemplateInstanceObjectsNested<N>> implements Nested<N>{
    BrokerTemplateInstanceObjectsNested(int index,BrokerTemplateInstance item) {
      this.index = index;
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endBrokerTemplateInstanceObject() {
      return and();
    }
    
  }
  public class UserObjectsNested<N> extends UserFluent<UserObjectsNested<N>> implements Nested<N>{
    UserObjectsNested(int index,User item) {
      this.index = index;
      this.builder = new UserBuilder(this, item);
    }
    UserBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endUserObject() {
      return and();
    }
    
  }
  public class ImageStreamImageObjectsNested<N> extends ImageStreamImageFluent<ImageStreamImageObjectsNested<N>> implements Nested<N>{
    ImageStreamImageObjectsNested(int index,ImageStreamImage item) {
      this.index = index;
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endImageStreamImageObject() {
      return and();
    }
    
  }
  public class TemplateInstanceObjectsNested<N> extends TemplateInstanceFluent<TemplateInstanceObjectsNested<N>> implements Nested<N>{
    TemplateInstanceObjectsNested(int index,TemplateInstance item) {
      this.index = index;
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endTemplateInstanceObject() {
      return and();
    }
    
  }
  public class BuildObjectsNested<N> extends BuildFluent<BuildObjectsNested<N>> implements Nested<N>{
    BuildObjectsNested(int index,Build item) {
      this.index = index;
      this.builder = new BuildBuilder(this, item);
    }
    BuildBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endBuildObject() {
      return and();
    }
    
  }
  public class RoleBindingRestrictionObjectsNested<N> extends RoleBindingRestrictionFluent<RoleBindingRestrictionObjectsNested<N>> implements Nested<N>{
    RoleBindingRestrictionObjectsNested(int index,RoleBindingRestriction item) {
      this.index = index;
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endRoleBindingRestrictionObject() {
      return and();
    }
    
  }
  public class ImageStreamTagObjectsNested<N> extends ImageStreamTagFluent<ImageStreamTagObjectsNested<N>> implements Nested<N>{
    ImageStreamTagObjectsNested(int index,ImageStreamTag item) {
      this.index = index;
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endImageStreamTagObject() {
      return and();
    }
    
  }
  public class GroupObjectsNested<N> extends GroupFluent<GroupObjectsNested<N>> implements Nested<N>{
    GroupObjectsNested(int index,Group item) {
      this.index = index;
      this.builder = new GroupBuilder(this, item);
    }
    GroupBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endGroupObject() {
      return and();
    }
    
  }
  public class ImageSignatureObjectsNested<N> extends ImageSignatureFluent<ImageSignatureObjectsNested<N>> implements Nested<N>{
    ImageSignatureObjectsNested(int index,ImageSignature item) {
      this.index = index;
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endImageSignatureObject() {
      return and();
    }
    
  }
  public class HostSubnetObjectsNested<N> extends HostSubnetFluent<HostSubnetObjectsNested<N>> implements Nested<N>{
    HostSubnetObjectsNested(int index,HostSubnet item) {
      this.index = index;
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endHostSubnetObject() {
      return and();
    }
    
  }
  public class AppliedClusterResourceQuotaObjectsNested<N> extends AppliedClusterResourceQuotaFluent<AppliedClusterResourceQuotaObjectsNested<N>> implements Nested<N>{
    AppliedClusterResourceQuotaObjectsNested(int index,AppliedClusterResourceQuota item) {
      this.index = index;
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endAppliedClusterResourceQuotaObject() {
      return and();
    }
    
  }
  public class SecurityContextConstraintsObjectsNested<N> extends SecurityContextConstraintsFluent<SecurityContextConstraintsObjectsNested<N>> implements Nested<N>{
    SecurityContextConstraintsObjectsNested(int index,SecurityContextConstraints item) {
      this.index = index;
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endSecurityContextConstraintsObject() {
      return and();
    }
    
  }
  public class BuildRequestObjectsNested<N> extends BuildRequestFluent<BuildRequestObjectsNested<N>> implements Nested<N>{
    BuildRequestObjectsNested(int index,BuildRequest item) {
      this.index = index;
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endBuildRequestObject() {
      return and();
    }
    
  }
  public class EgressNetworkPolicyObjectsNested<N> extends EgressNetworkPolicyFluent<EgressNetworkPolicyObjectsNested<N>> implements Nested<N>{
    EgressNetworkPolicyObjectsNested(int index,EgressNetworkPolicy item) {
      this.index = index;
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endEgressNetworkPolicyObject() {
      return and();
    }
    
  }
  public class NetNamespaceObjectsNested<N> extends NetNamespaceFluent<NetNamespaceObjectsNested<N>> implements Nested<N>{
    NetNamespaceObjectsNested(int index,NetNamespace item) {
      this.index = index;
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endNetNamespaceObject() {
      return and();
    }
    
  }
  public class UserIdentityMappingObjectsNested<N> extends UserIdentityMappingFluent<UserIdentityMappingObjectsNested<N>> implements Nested<N>{
    UserIdentityMappingObjectsNested(int index,UserIdentityMapping item) {
      this.index = index;
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endUserIdentityMappingObject() {
      return and();
    }
    
  }
  public class ImageStreamObjectsNested<N> extends ImageStreamFluent<ImageStreamObjectsNested<N>> implements Nested<N>{
    ImageStreamObjectsNested(int index,ImageStream item) {
      this.index = index;
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endImageStreamObject() {
      return and();
    }
    
  }
  public class OAuthClientObjectsNested<N> extends OAuthClientFluent<OAuthClientObjectsNested<N>> implements Nested<N>{
    OAuthClientObjectsNested(int index,OAuthClient item) {
      this.index = index;
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endOAuthClientObject() {
      return and();
    }
    
  }
  public class IdentityObjectsNested<N> extends IdentityFluent<IdentityObjectsNested<N>> implements Nested<N>{
    IdentityObjectsNested(int index,Identity item) {
      this.index = index;
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToObjects(index,builder.build());
    }
    public N endIdentityObject() {
      return and();
    }
    
  }
  public class ParametersNested<N> extends ParameterFluent<ParametersNested<N>> implements Nested<N>{
    ParametersNested(int index,Parameter item) {
      this.index = index;
      this.builder = new ParameterBuilder(this, item);
    }
    ParameterBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluent.this.setToParameters(index,builder.build());
    }
    public N endParameter() {
      return and();
    }
    
  }
  
}