package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateBuilder extends TemplateFluent<TemplateBuilder> implements VisitableBuilder<Template,TemplateBuilder>{
  public TemplateBuilder() {
    this(false);
  }
  public TemplateBuilder(Boolean validationEnabled) {
    this(new Template(), validationEnabled);
  }
  public TemplateBuilder(TemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateBuilder(TemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Template(), validationEnabled);
  }
  public TemplateBuilder(TemplateFluent<?> fluent,Template instance) {
    this(fluent, instance, false);
  }
  public TemplateBuilder(TemplateFluent<?> fluent,Template instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Template());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withLabels(instance.getLabels());
      fluent.withMessage(instance.getMessage());
      fluent.withMetadata(instance.getMetadata());
      fluent.withObjects(instance.getObjects());
      fluent.withParameters(instance.getParameters());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withLabels(instance.getLabels());
      fluent.withMessage(instance.getMessage());
      fluent.withMetadata(instance.getMetadata());
      fluent.withObjects(instance.getObjects());
      fluent.withParameters(instance.getParameters());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TemplateBuilder(Template instance) {
    this(instance,false);
  }
  public TemplateBuilder(Template instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Template());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withLabels(instance.getLabels());
      this.withMessage(instance.getMessage());
      this.withMetadata(instance.getMetadata());
      this.withObjects(instance.getObjects());
      this.withParameters(instance.getParameters());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withLabels(instance.getLabels());
      this.withMessage(instance.getMessage());
      this.withMetadata(instance.getMetadata());
      this.withObjects(instance.getObjects());
      this.withParameters(instance.getParameters());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TemplateFluent<?> fluent;
  Boolean validationEnabled;
  public Template build() {
    Template buildable = new Template(fluent.getApiVersion(),fluent.getKind(),fluent.getLabels(),fluent.getMessage(),fluent.buildMetadata(),fluent.buildObjects(),fluent.buildParameters());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}