package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TagImportPolicyBuilder extends TagImportPolicyFluent<TagImportPolicyBuilder> implements VisitableBuilder<TagImportPolicy,TagImportPolicyBuilder>{
  public TagImportPolicyBuilder() {
    this(false);
  }
  public TagImportPolicyBuilder(Boolean validationEnabled) {
    this(new TagImportPolicy(), validationEnabled);
  }
  public TagImportPolicyBuilder(TagImportPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public TagImportPolicyBuilder(TagImportPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TagImportPolicy(), validationEnabled);
  }
  public TagImportPolicyBuilder(TagImportPolicyFluent<?> fluent,TagImportPolicy instance) {
    this(fluent, instance, false);
  }
  public TagImportPolicyBuilder(TagImportPolicyFluent<?> fluent,TagImportPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TagImportPolicy());

    if (instance != null) {
      fluent.withImportMode(instance.getImportMode());
      fluent.withInsecure(instance.getInsecure());
      fluent.withScheduled(instance.getScheduled());
      fluent.withImportMode(instance.getImportMode());
      fluent.withInsecure(instance.getInsecure());
      fluent.withScheduled(instance.getScheduled());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TagImportPolicyBuilder(TagImportPolicy instance) {
    this(instance,false);
  }
  public TagImportPolicyBuilder(TagImportPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TagImportPolicy());

    if (instance != null) {
      this.withImportMode(instance.getImportMode());
      this.withInsecure(instance.getInsecure());
      this.withScheduled(instance.getScheduled());
      this.withImportMode(instance.getImportMode());
      this.withInsecure(instance.getInsecure());
      this.withScheduled(instance.getScheduled());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TagImportPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public TagImportPolicy build() {
    TagImportPolicy buildable = new TagImportPolicy(fluent.getImportMode(),fluent.getInsecure(),fluent.getScheduled());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}