package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TagImageHookFluent<A extends TagImageHookFluent<A>> extends BaseFluent<A>{
  public TagImageHookFluent() {
  }
  public TagImageHookFluent(TagImageHook instance) {
    instance = (instance != null ? instance : new TagImageHook());

    if (instance != null) {
      this.withContainerName(instance.getContainerName());
      this.withTo(instance.getTo());
      this.withContainerName(instance.getContainerName());
      this.withTo(instance.getTo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String containerName;
  private ObjectReferenceBuilder to;
  private Map<String,Object> additionalProperties;
  public String getContainerName() {
    return this.containerName;
  }
  public A withContainerName(String containerName) {
    this.containerName=containerName; return (A) this;
  }
  public boolean hasContainerName() {
    return this.containerName != null;
  }
  public ObjectReference buildTo() {
    return this.to!=null ?this.to.build():null;
  }
  public A withTo(ObjectReference to) {
    _visitables.get("to").remove(this.to);
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.get("to").add(this.to);} else { this.to = null; _visitables.get("to").remove(this.to); } return (A) this;
  }
  public boolean hasTo() {
    return this.to != null;
  }
  public ToNested<A> withNewTo() {
    return new ToNested(null);
  }
  public ToNested<A> withNewToLike(ObjectReference item) {
    return new ToNested(item);
  }
  public ToNested<A> editTo() {
    return withNewToLike(java.util.Optional.ofNullable(buildTo()).orElse(null));
  }
  public ToNested<A> editOrNewTo() {
    return withNewToLike(java.util.Optional.ofNullable(buildTo()).orElse(new ObjectReferenceBuilder().build()));
  }
  public ToNested<A> editOrNewToLike(ObjectReference item) {
    return withNewToLike(java.util.Optional.ofNullable(buildTo()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TagImageHookFluent that = (TagImageHookFluent) o;
    if (!java.util.Objects.equals(containerName, that.containerName)) return false;

    if (!java.util.Objects.equals(to, that.to)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerName,  to,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerName != null) { sb.append("containerName:"); sb.append(containerName + ","); }
    if (to != null) { sb.append("to:"); sb.append(to + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ToNested<N> extends ObjectReferenceFluent<ToNested<N>> implements Nested<N>{
    ToNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) TagImageHookFluent.this.withTo(builder.build());
    }
    public N endTo() {
      return and();
    }
    
  }
  
}