package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceStrategyOptionsBuilder extends SourceStrategyOptionsFluent<SourceStrategyOptionsBuilder> implements VisitableBuilder<SourceStrategyOptions,SourceStrategyOptionsBuilder>{
  public SourceStrategyOptionsBuilder() {
    this(false);
  }
  public SourceStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new SourceStrategyOptions(), validationEnabled);
  }
  public SourceStrategyOptionsBuilder(SourceStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceStrategyOptionsBuilder(SourceStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SourceStrategyOptions(), validationEnabled);
  }
  public SourceStrategyOptionsBuilder(SourceStrategyOptionsFluent<?> fluent,SourceStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public SourceStrategyOptionsBuilder(SourceStrategyOptionsFluent<?> fluent,SourceStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SourceStrategyOptions());

    if (instance != null) {
      fluent.withIncremental(instance.getIncremental());
      fluent.withIncremental(instance.getIncremental());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SourceStrategyOptionsBuilder(SourceStrategyOptions instance) {
    this(instance,false);
  }
  public SourceStrategyOptionsBuilder(SourceStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SourceStrategyOptions());

    if (instance != null) {
      this.withIncremental(instance.getIncremental());
      this.withIncremental(instance.getIncremental());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SourceStrategyOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public SourceStrategyOptions build() {
    SourceStrategyOptions buildable = new SourceStrategyOptions(fluent.getIncremental());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}