package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceBuildStrategyBuilder extends SourceBuildStrategyFluent<SourceBuildStrategyBuilder> implements VisitableBuilder<SourceBuildStrategy,SourceBuildStrategyBuilder>{
  public SourceBuildStrategyBuilder() {
    this(false);
  }
  public SourceBuildStrategyBuilder(Boolean validationEnabled) {
    this(new SourceBuildStrategy(), validationEnabled);
  }
  public SourceBuildStrategyBuilder(SourceBuildStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceBuildStrategyBuilder(SourceBuildStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SourceBuildStrategy(), validationEnabled);
  }
  public SourceBuildStrategyBuilder(SourceBuildStrategyFluent<?> fluent,SourceBuildStrategy instance) {
    this(fluent, instance, false);
  }
  public SourceBuildStrategyBuilder(SourceBuildStrategyFluent<?> fluent,SourceBuildStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SourceBuildStrategy());

    if (instance != null) {
      fluent.withEnv(instance.getEnv());
      fluent.withForcePull(instance.getForcePull());
      fluent.withFrom(instance.getFrom());
      fluent.withIncremental(instance.getIncremental());
      fluent.withPullSecret(instance.getPullSecret());
      fluent.withScripts(instance.getScripts());
      fluent.withVolumes(instance.getVolumes());
      fluent.withEnv(instance.getEnv());
      fluent.withForcePull(instance.getForcePull());
      fluent.withFrom(instance.getFrom());
      fluent.withIncremental(instance.getIncremental());
      fluent.withPullSecret(instance.getPullSecret());
      fluent.withScripts(instance.getScripts());
      fluent.withVolumes(instance.getVolumes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SourceBuildStrategyBuilder(SourceBuildStrategy instance) {
    this(instance,false);
  }
  public SourceBuildStrategyBuilder(SourceBuildStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SourceBuildStrategy());

    if (instance != null) {
      this.withEnv(instance.getEnv());
      this.withForcePull(instance.getForcePull());
      this.withFrom(instance.getFrom());
      this.withIncremental(instance.getIncremental());
      this.withPullSecret(instance.getPullSecret());
      this.withScripts(instance.getScripts());
      this.withVolumes(instance.getVolumes());
      this.withEnv(instance.getEnv());
      this.withForcePull(instance.getForcePull());
      this.withFrom(instance.getFrom());
      this.withIncremental(instance.getIncremental());
      this.withPullSecret(instance.getPullSecret());
      this.withScripts(instance.getScripts());
      this.withVolumes(instance.getVolumes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SourceBuildStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public SourceBuildStrategy build() {
    SourceBuildStrategy buildable = new SourceBuildStrategy(fluent.getEnv(),fluent.getForcePull(),fluent.buildFrom(),fluent.getIncremental(),fluent.buildPullSecret(),fluent.getScripts(),fluent.buildVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}