package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamImportStatusBuilder extends ImageStreamImportStatusFluent<ImageStreamImportStatusBuilder> implements VisitableBuilder<ImageStreamImportStatus,ImageStreamImportStatusBuilder>{
  public ImageStreamImportStatusBuilder() {
    this(false);
  }
  public ImageStreamImportStatusBuilder(Boolean validationEnabled) {
    this(new ImageStreamImportStatus(), validationEnabled);
  }
  public ImageStreamImportStatusBuilder(ImageStreamImportStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamImportStatusBuilder(ImageStreamImportStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamImportStatus(), validationEnabled);
  }
  public ImageStreamImportStatusBuilder(ImageStreamImportStatusFluent<?> fluent,ImageStreamImportStatus instance) {
    this(fluent, instance, false);
  }
  public ImageStreamImportStatusBuilder(ImageStreamImportStatusFluent<?> fluent,ImageStreamImportStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageStreamImportStatus());

    if (instance != null) {
      fluent.withImages(instance.getImages());
      fluent.withImport(instance.getImport());
      fluent.withRepository(instance.getRepository());
      fluent.withImages(instance.getImages());
      fluent.withImport(instance.getImport());
      fluent.withRepository(instance.getRepository());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamImportStatusBuilder(ImageStreamImportStatus instance) {
    this(instance,false);
  }
  public ImageStreamImportStatusBuilder(ImageStreamImportStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageStreamImportStatus());

    if (instance != null) {
      this.withImages(instance.getImages());
      this.withImport(instance.getImport());
      this.withRepository(instance.getRepository());
      this.withImages(instance.getImages());
      this.withImport(instance.getImport());
      this.withRepository(instance.getRepository());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStreamImportStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamImportStatus build() {
    ImageStreamImportStatus buildable = new ImageStreamImportStatus(fluent.buildImages(),fluent.buildImport(),fluent.buildRepository());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}