package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostSubnetBuilder extends HostSubnetFluent<HostSubnetBuilder> implements VisitableBuilder<HostSubnet,HostSubnetBuilder>{
  public HostSubnetBuilder() {
    this(false);
  }
  public HostSubnetBuilder(Boolean validationEnabled) {
    this(new HostSubnet(), validationEnabled);
  }
  public HostSubnetBuilder(HostSubnetFluent<?> fluent) {
    this(fluent, false);
  }
  public HostSubnetBuilder(HostSubnetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HostSubnet(), validationEnabled);
  }
  public HostSubnetBuilder(HostSubnetFluent<?> fluent,HostSubnet instance) {
    this(fluent, instance, false);
  }
  public HostSubnetBuilder(HostSubnetFluent<?> fluent,HostSubnet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HostSubnet());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withEgressCIDRs(instance.getEgressCIDRs());
      fluent.withEgressIPs(instance.getEgressIPs());
      fluent.withHost(instance.getHost());
      fluent.withHostIP(instance.getHostIP());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSubnet(instance.getSubnet());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withEgressCIDRs(instance.getEgressCIDRs());
      fluent.withEgressIPs(instance.getEgressIPs());
      fluent.withHost(instance.getHost());
      fluent.withHostIP(instance.getHostIP());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSubnet(instance.getSubnet());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HostSubnetBuilder(HostSubnet instance) {
    this(instance,false);
  }
  public HostSubnetBuilder(HostSubnet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HostSubnet());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withEgressCIDRs(instance.getEgressCIDRs());
      this.withEgressIPs(instance.getEgressIPs());
      this.withHost(instance.getHost());
      this.withHostIP(instance.getHostIP());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSubnet(instance.getSubnet());
      this.withApiVersion(instance.getApiVersion());
      this.withEgressCIDRs(instance.getEgressCIDRs());
      this.withEgressIPs(instance.getEgressIPs());
      this.withHost(instance.getHost());
      this.withHostIP(instance.getHostIP());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSubnet(instance.getSubnet());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HostSubnetFluent<?> fluent;
  Boolean validationEnabled;
  public HostSubnet build() {
    HostSubnet buildable = new HostSubnet(fluent.getApiVersion(),fluent.getEgressCIDRs(),fluent.getEgressIPs(),fluent.getHost(),fluent.getHostIP(),fluent.getKind(),fluent.buildMetadata(),fluent.getSubnet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}