package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubWebHookCauseBuilder extends GitHubWebHookCauseFluent<GitHubWebHookCauseBuilder> implements VisitableBuilder<GitHubWebHookCause,GitHubWebHookCauseBuilder>{
  public GitHubWebHookCauseBuilder() {
    this(false);
  }
  public GitHubWebHookCauseBuilder(Boolean validationEnabled) {
    this(new GitHubWebHookCause(), validationEnabled);
  }
  public GitHubWebHookCauseBuilder(GitHubWebHookCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubWebHookCauseBuilder(GitHubWebHookCauseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHubWebHookCause(), validationEnabled);
  }
  public GitHubWebHookCauseBuilder(GitHubWebHookCauseFluent<?> fluent,GitHubWebHookCause instance) {
    this(fluent, instance, false);
  }
  public GitHubWebHookCauseBuilder(GitHubWebHookCauseFluent<?> fluent,GitHubWebHookCause instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GitHubWebHookCause());

    if (instance != null) {
      fluent.withRevision(instance.getRevision());
      fluent.withSecret(instance.getSecret());
      fluent.withRevision(instance.getRevision());
      fluent.withSecret(instance.getSecret());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitHubWebHookCauseBuilder(GitHubWebHookCause instance) {
    this(instance,false);
  }
  public GitHubWebHookCauseBuilder(GitHubWebHookCause instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GitHubWebHookCause());

    if (instance != null) {
      this.withRevision(instance.getRevision());
      this.withSecret(instance.getSecret());
      this.withRevision(instance.getRevision());
      this.withSecret(instance.getSecret());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitHubWebHookCauseFluent<?> fluent;
  Boolean validationEnabled;
  public GitHubWebHookCause build() {
    GitHubWebHookCause buildable = new GitHubWebHookCause(fluent.buildRevision(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}