package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressNetworkPolicySpecBuilder extends EgressNetworkPolicySpecFluent<EgressNetworkPolicySpecBuilder> implements VisitableBuilder<EgressNetworkPolicySpec,EgressNetworkPolicySpecBuilder>{
  public EgressNetworkPolicySpecBuilder() {
    this(false);
  }
  public EgressNetworkPolicySpecBuilder(Boolean validationEnabled) {
    this(new EgressNetworkPolicySpec(), validationEnabled);
  }
  public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressNetworkPolicySpec(), validationEnabled);
  }
  public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent,EgressNetworkPolicySpec instance) {
    this(fluent, instance, false);
  }
  public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent,EgressNetworkPolicySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EgressNetworkPolicySpec());

    if (instance != null) {
      fluent.withEgress(instance.getEgress());
      fluent.withEgress(instance.getEgress());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpec instance) {
    this(instance,false);
  }
  public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EgressNetworkPolicySpec());

    if (instance != null) {
      this.withEgress(instance.getEgress());
      this.withEgress(instance.getEgress());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressNetworkPolicySpecFluent<?> fluent;
  Boolean validationEnabled;
  public EgressNetworkPolicySpec build() {
    EgressNetworkPolicySpec buildable = new EgressNetworkPolicySpec(fluent.buildEgress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}