package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentTriggerPolicyBuilder extends DeploymentTriggerPolicyFluent<DeploymentTriggerPolicyBuilder> implements VisitableBuilder<DeploymentTriggerPolicy,DeploymentTriggerPolicyBuilder>{
  public DeploymentTriggerPolicyBuilder() {
    this(false);
  }
  public DeploymentTriggerPolicyBuilder(Boolean validationEnabled) {
    this(new DeploymentTriggerPolicy(), validationEnabled);
  }
  public DeploymentTriggerPolicyBuilder(DeploymentTriggerPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentTriggerPolicyBuilder(DeploymentTriggerPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentTriggerPolicy(), validationEnabled);
  }
  public DeploymentTriggerPolicyBuilder(DeploymentTriggerPolicyFluent<?> fluent,DeploymentTriggerPolicy instance) {
    this(fluent, instance, false);
  }
  public DeploymentTriggerPolicyBuilder(DeploymentTriggerPolicyFluent<?> fluent,DeploymentTriggerPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DeploymentTriggerPolicy());

    if (instance != null) {
      fluent.withImageChangeParams(instance.getImageChangeParams());
      fluent.withType(instance.getType());
      fluent.withImageChangeParams(instance.getImageChangeParams());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentTriggerPolicyBuilder(DeploymentTriggerPolicy instance) {
    this(instance,false);
  }
  public DeploymentTriggerPolicyBuilder(DeploymentTriggerPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DeploymentTriggerPolicy());

    if (instance != null) {
      this.withImageChangeParams(instance.getImageChangeParams());
      this.withType(instance.getType());
      this.withImageChangeParams(instance.getImageChangeParams());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentTriggerPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentTriggerPolicy build() {
    DeploymentTriggerPolicy buildable = new DeploymentTriggerPolicy(fluent.buildImageChangeParams(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}