package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentDetailsBuilder extends DeploymentDetailsFluent<DeploymentDetailsBuilder> implements VisitableBuilder<DeploymentDetails,DeploymentDetailsBuilder>{
  public DeploymentDetailsBuilder() {
    this(false);
  }
  public DeploymentDetailsBuilder(Boolean validationEnabled) {
    this(new DeploymentDetails(), validationEnabled);
  }
  public DeploymentDetailsBuilder(DeploymentDetailsFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentDetailsBuilder(DeploymentDetailsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentDetails(), validationEnabled);
  }
  public DeploymentDetailsBuilder(DeploymentDetailsFluent<?> fluent,DeploymentDetails instance) {
    this(fluent, instance, false);
  }
  public DeploymentDetailsBuilder(DeploymentDetailsFluent<?> fluent,DeploymentDetails instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DeploymentDetails());

    if (instance != null) {
      fluent.withCauses(instance.getCauses());
      fluent.withMessage(instance.getMessage());
      fluent.withCauses(instance.getCauses());
      fluent.withMessage(instance.getMessage());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentDetailsBuilder(DeploymentDetails instance) {
    this(instance,false);
  }
  public DeploymentDetailsBuilder(DeploymentDetails instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DeploymentDetails());

    if (instance != null) {
      this.withCauses(instance.getCauses());
      this.withMessage(instance.getMessage());
      this.withCauses(instance.getCauses());
      this.withMessage(instance.getMessage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentDetailsFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentDetails build() {
    DeploymentDetails buildable = new DeploymentDetails(fluent.buildCauses(),fluent.getMessage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}