package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterResourceQuotaSpecBuilder extends ClusterResourceQuotaSpecFluent<ClusterResourceQuotaSpecBuilder> implements VisitableBuilder<ClusterResourceQuotaSpec,ClusterResourceQuotaSpecBuilder>{
  public ClusterResourceQuotaSpecBuilder() {
    this(false);
  }
  public ClusterResourceQuotaSpecBuilder(Boolean validationEnabled) {
    this(new ClusterResourceQuotaSpec(), validationEnabled);
  }
  public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterResourceQuotaSpec(), validationEnabled);
  }
  public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent,ClusterResourceQuotaSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent,ClusterResourceQuotaSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterResourceQuotaSpec());

    if (instance != null) {
      fluent.withQuota(instance.getQuota());
      fluent.withSelector(instance.getSelector());
      fluent.withQuota(instance.getQuota());
      fluent.withSelector(instance.getSelector());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpec instance) {
    this(instance,false);
  }
  public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterResourceQuotaSpec());

    if (instance != null) {
      this.withQuota(instance.getQuota());
      this.withSelector(instance.getSelector());
      this.withQuota(instance.getQuota());
      this.withSelector(instance.getSelector());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterResourceQuotaSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterResourceQuotaSpec build() {
    ClusterResourceQuotaSpec buildable = new ClusterResourceQuotaSpec(fluent.getQuota(),fluent.buildSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}