package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterResourceQuotaSelectorFluent<A extends ClusterResourceQuotaSelectorFluent<A>> extends BaseFluent<A>{
  public ClusterResourceQuotaSelectorFluent() {
  }
  public ClusterResourceQuotaSelectorFluent(ClusterResourceQuotaSelector instance) {
    instance = (instance != null ? instance : new ClusterResourceQuotaSelector());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withLabels(instance.getLabels());
      this.withAnnotations(instance.getAnnotations());
      this.withLabels(instance.getLabels());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Map<String,String> annotations;
  private LabelSelectorBuilder labels;
  private Map<String,Object> additionalProperties;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  public LabelSelector buildLabels() {
    return this.labels!=null ?this.labels.build():null;
  }
  public A withLabels(LabelSelector labels) {
    _visitables.get("labels").remove(this.labels);
    if (labels!=null){ this.labels= new LabelSelectorBuilder(labels); _visitables.get("labels").add(this.labels);} else { this.labels = null; _visitables.get("labels").remove(this.labels); } return (A) this;
  }
  public boolean hasLabels() {
    return this.labels != null;
  }
  public LabelsNested<A> withNewLabels() {
    return new LabelsNested(null);
  }
  public LabelsNested<A> withNewLabelsLike(LabelSelector item) {
    return new LabelsNested(item);
  }
  public LabelsNested<A> editLabels() {
    return withNewLabelsLike(java.util.Optional.ofNullable(buildLabels()).orElse(null));
  }
  public LabelsNested<A> editOrNewLabels() {
    return withNewLabelsLike(java.util.Optional.ofNullable(buildLabels()).orElse(new LabelSelectorBuilder().build()));
  }
  public LabelsNested<A> editOrNewLabelsLike(LabelSelector item) {
    return withNewLabelsLike(java.util.Optional.ofNullable(buildLabels()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterResourceQuotaSelectorFluent that = (ClusterResourceQuotaSelectorFluent) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(labels, that.labels)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  labels,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (labels != null) { sb.append("labels:"); sb.append(labels + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class LabelsNested<N> extends LabelSelectorFluent<LabelsNested<N>> implements Nested<N>{
    LabelsNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ClusterResourceQuotaSelectorFluent.this.withLabels(builder.build());
    }
    public N endLabels() {
      return and();
    }
    
  }
  
}