package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildStatusOutputBuilder extends BuildStatusOutputFluent<BuildStatusOutputBuilder> implements VisitableBuilder<BuildStatusOutput,BuildStatusOutputBuilder>{
  public BuildStatusOutputBuilder() {
    this(false);
  }
  public BuildStatusOutputBuilder(Boolean validationEnabled) {
    this(new BuildStatusOutput(), validationEnabled);
  }
  public BuildStatusOutputBuilder(BuildStatusOutputFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildStatusOutputBuilder(BuildStatusOutputFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildStatusOutput(), validationEnabled);
  }
  public BuildStatusOutputBuilder(BuildStatusOutputFluent<?> fluent,BuildStatusOutput instance) {
    this(fluent, instance, false);
  }
  public BuildStatusOutputBuilder(BuildStatusOutputFluent<?> fluent,BuildStatusOutput instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BuildStatusOutput());

    if (instance != null) {
      fluent.withTo(instance.getTo());
      fluent.withTo(instance.getTo());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildStatusOutputBuilder(BuildStatusOutput instance) {
    this(instance,false);
  }
  public BuildStatusOutputBuilder(BuildStatusOutput instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BuildStatusOutput());

    if (instance != null) {
      this.withTo(instance.getTo());
      this.withTo(instance.getTo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildStatusOutputFluent<?> fluent;
  Boolean validationEnabled;
  public BuildStatusOutput build() {
    BuildStatusOutput buildable = new BuildStatusOutput(fluent.buildTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}