package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildRequestBuilder extends BuildRequestFluent<BuildRequestBuilder> implements VisitableBuilder<BuildRequest,BuildRequestBuilder>{
  public BuildRequestBuilder() {
    this(false);
  }
  public BuildRequestBuilder(Boolean validationEnabled) {
    this(new BuildRequest(), validationEnabled);
  }
  public BuildRequestBuilder(BuildRequestFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildRequestBuilder(BuildRequestFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildRequest(), validationEnabled);
  }
  public BuildRequestBuilder(BuildRequestFluent<?> fluent,BuildRequest instance) {
    this(fluent, instance, false);
  }
  public BuildRequestBuilder(BuildRequestFluent<?> fluent,BuildRequest instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BuildRequest());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withBinary(instance.getBinary());
      fluent.withDockerStrategyOptions(instance.getDockerStrategyOptions());
      fluent.withEnv(instance.getEnv());
      fluent.withFrom(instance.getFrom());
      fluent.withKind(instance.getKind());
      fluent.withLastVersion(instance.getLastVersion());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRevision(instance.getRevision());
      fluent.withSourceStrategyOptions(instance.getSourceStrategyOptions());
      fluent.withTriggeredBy(instance.getTriggeredBy());
      fluent.withTriggeredByImage(instance.getTriggeredByImage());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withBinary(instance.getBinary());
      fluent.withDockerStrategyOptions(instance.getDockerStrategyOptions());
      fluent.withEnv(instance.getEnv());
      fluent.withFrom(instance.getFrom());
      fluent.withKind(instance.getKind());
      fluent.withLastVersion(instance.getLastVersion());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRevision(instance.getRevision());
      fluent.withSourceStrategyOptions(instance.getSourceStrategyOptions());
      fluent.withTriggeredBy(instance.getTriggeredBy());
      fluent.withTriggeredByImage(instance.getTriggeredByImage());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildRequestBuilder(BuildRequest instance) {
    this(instance,false);
  }
  public BuildRequestBuilder(BuildRequest instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BuildRequest());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withBinary(instance.getBinary());
      this.withDockerStrategyOptions(instance.getDockerStrategyOptions());
      this.withEnv(instance.getEnv());
      this.withFrom(instance.getFrom());
      this.withKind(instance.getKind());
      this.withLastVersion(instance.getLastVersion());
      this.withMetadata(instance.getMetadata());
      this.withRevision(instance.getRevision());
      this.withSourceStrategyOptions(instance.getSourceStrategyOptions());
      this.withTriggeredBy(instance.getTriggeredBy());
      this.withTriggeredByImage(instance.getTriggeredByImage());
      this.withApiVersion(instance.getApiVersion());
      this.withBinary(instance.getBinary());
      this.withDockerStrategyOptions(instance.getDockerStrategyOptions());
      this.withEnv(instance.getEnv());
      this.withFrom(instance.getFrom());
      this.withKind(instance.getKind());
      this.withLastVersion(instance.getLastVersion());
      this.withMetadata(instance.getMetadata());
      this.withRevision(instance.getRevision());
      this.withSourceStrategyOptions(instance.getSourceStrategyOptions());
      this.withTriggeredBy(instance.getTriggeredBy());
      this.withTriggeredByImage(instance.getTriggeredByImage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildRequestFluent<?> fluent;
  Boolean validationEnabled;
  public BuildRequest build() {
    BuildRequest buildable = new BuildRequest(fluent.getApiVersion(),fluent.buildBinary(),fluent.buildDockerStrategyOptions(),fluent.getEnv(),fluent.buildFrom(),fluent.getKind(),fluent.getLastVersion(),fluent.buildMetadata(),fluent.buildRevision(),fluent.buildSourceStrategyOptions(),fluent.buildTriggeredBy(),fluent.buildTriggeredByImage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}