package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AppliedClusterResourceQuotaBuilder extends AppliedClusterResourceQuotaFluent<AppliedClusterResourceQuotaBuilder> implements VisitableBuilder<AppliedClusterResourceQuota,AppliedClusterResourceQuotaBuilder>{
  public AppliedClusterResourceQuotaBuilder() {
    this(false);
  }
  public AppliedClusterResourceQuotaBuilder(Boolean validationEnabled) {
    this(new AppliedClusterResourceQuota(), validationEnabled);
  }
  public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuotaFluent<?> fluent) {
    this(fluent, false);
  }
  public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuotaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AppliedClusterResourceQuota(), validationEnabled);
  }
  public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuotaFluent<?> fluent,AppliedClusterResourceQuota instance) {
    this(fluent, instance, false);
  }
  public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuotaFluent<?> fluent,AppliedClusterResourceQuota instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AppliedClusterResourceQuota());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuota instance) {
    this(instance,false);
  }
  public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuota instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AppliedClusterResourceQuota());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AppliedClusterResourceQuotaFluent<?> fluent;
  Boolean validationEnabled;
  public AppliedClusterResourceQuota build() {
    AppliedClusterResourceQuota buildable = new AppliedClusterResourceQuota(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}