package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateInstanceListBuilder extends TemplateInstanceListFluentImpl<TemplateInstanceListBuilder> implements VisitableBuilder<TemplateInstanceList,TemplateInstanceListBuilder>{
  public TemplateInstanceListBuilder() {
    this(false);
  }
  public TemplateInstanceListBuilder(Boolean validationEnabled) {
    this(new TemplateInstanceList(), validationEnabled);
  }
  public TemplateInstanceListBuilder(TemplateInstanceListFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateInstanceListBuilder(TemplateInstanceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TemplateInstanceList(), validationEnabled);
  }
  public TemplateInstanceListBuilder(TemplateInstanceListFluent<?> fluent,TemplateInstanceList instance) {
    this(fluent, instance, false);
  }
  public TemplateInstanceListBuilder(TemplateInstanceListFluent<?> fluent,TemplateInstanceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TemplateInstanceListBuilder(TemplateInstanceList instance) {
    this(instance,false);
  }
  public TemplateInstanceListBuilder(TemplateInstanceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TemplateInstanceListFluent<?> fluent;
  Boolean validationEnabled;
  public TemplateInstanceList build() {
    TemplateInstanceList buildable = new TemplateInstanceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}