package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecurityContextConstraintsListBuilder extends SecurityContextConstraintsListFluentImpl<SecurityContextConstraintsListBuilder> implements VisitableBuilder<SecurityContextConstraintsList,SecurityContextConstraintsListBuilder>{
  public SecurityContextConstraintsListBuilder() {
    this(false);
  }
  public SecurityContextConstraintsListBuilder(Boolean validationEnabled) {
    this(new SecurityContextConstraintsList(), validationEnabled);
  }
  public SecurityContextConstraintsListBuilder(SecurityContextConstraintsListFluent<?> fluent) {
    this(fluent, false);
  }
  public SecurityContextConstraintsListBuilder(SecurityContextConstraintsListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecurityContextConstraintsList(), validationEnabled);
  }
  public SecurityContextConstraintsListBuilder(SecurityContextConstraintsListFluent<?> fluent,SecurityContextConstraintsList instance) {
    this(fluent, instance, false);
  }
  public SecurityContextConstraintsListBuilder(SecurityContextConstraintsListFluent<?> fluent,SecurityContextConstraintsList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecurityContextConstraintsListBuilder(SecurityContextConstraintsList instance) {
    this(instance,false);
  }
  public SecurityContextConstraintsListBuilder(SecurityContextConstraintsList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecurityContextConstraintsListFluent<?> fluent;
  Boolean validationEnabled;
  public SecurityContextConstraintsList build() {
    SecurityContextConstraintsList buildable = new SecurityContextConstraintsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}