package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretLocalReferenceBuilder extends SecretLocalReferenceFluentImpl<SecretLocalReferenceBuilder> implements VisitableBuilder<SecretLocalReference,SecretLocalReferenceBuilder>{
  public SecretLocalReferenceBuilder() {
    this(false);
  }
  public SecretLocalReferenceBuilder(Boolean validationEnabled) {
    this(new SecretLocalReference(), validationEnabled);
  }
  public SecretLocalReferenceBuilder(SecretLocalReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretLocalReferenceBuilder(SecretLocalReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretLocalReference(), validationEnabled);
  }
  public SecretLocalReferenceBuilder(SecretLocalReferenceFluent<?> fluent,SecretLocalReference instance) {
    this(fluent, instance, false);
  }
  public SecretLocalReferenceBuilder(SecretLocalReferenceFluent<?> fluent,SecretLocalReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretLocalReferenceBuilder(SecretLocalReference instance) {
    this(instance,false);
  }
  public SecretLocalReferenceBuilder(SecretLocalReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretLocalReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public SecretLocalReference build() {
    SecretLocalReference buildable = new SecretLocalReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}