package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteTargetReferenceBuilder extends RouteTargetReferenceFluentImpl<RouteTargetReferenceBuilder> implements VisitableBuilder<RouteTargetReference,RouteTargetReferenceBuilder>{
  public RouteTargetReferenceBuilder() {
    this(false);
  }
  public RouteTargetReferenceBuilder(Boolean validationEnabled) {
    this(new RouteTargetReference(), validationEnabled);
  }
  public RouteTargetReferenceBuilder(RouteTargetReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteTargetReferenceBuilder(RouteTargetReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteTargetReference(), validationEnabled);
  }
  public RouteTargetReferenceBuilder(RouteTargetReferenceFluent<?> fluent,RouteTargetReference instance) {
    this(fluent, instance, false);
  }
  public RouteTargetReferenceBuilder(RouteTargetReferenceFluent<?> fluent,RouteTargetReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withWeight(instance.getWeight());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RouteTargetReferenceBuilder(RouteTargetReference instance) {
    this(instance,false);
  }
  public RouteTargetReferenceBuilder(RouteTargetReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withWeight(instance.getWeight());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RouteTargetReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public RouteTargetReference build() {
    RouteTargetReference buildable = new RouteTargetReference(fluent.getKind(),fluent.getName(),fluent.getWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}