package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleBindingRestrictionListBuilder extends RoleBindingRestrictionListFluentImpl<RoleBindingRestrictionListBuilder> implements VisitableBuilder<RoleBindingRestrictionList,RoleBindingRestrictionListBuilder>{
  public RoleBindingRestrictionListBuilder() {
    this(false);
  }
  public RoleBindingRestrictionListBuilder(Boolean validationEnabled) {
    this(new RoleBindingRestrictionList(), validationEnabled);
  }
  public RoleBindingRestrictionListBuilder(RoleBindingRestrictionListFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleBindingRestrictionListBuilder(RoleBindingRestrictionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RoleBindingRestrictionList(), validationEnabled);
  }
  public RoleBindingRestrictionListBuilder(RoleBindingRestrictionListFluent<?> fluent,RoleBindingRestrictionList instance) {
    this(fluent, instance, false);
  }
  public RoleBindingRestrictionListBuilder(RoleBindingRestrictionListFluent<?> fluent,RoleBindingRestrictionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RoleBindingRestrictionListBuilder(RoleBindingRestrictionList instance) {
    this(instance,false);
  }
  public RoleBindingRestrictionListBuilder(RoleBindingRestrictionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RoleBindingRestrictionListFluent<?> fluent;
  Boolean validationEnabled;
  public RoleBindingRestrictionList build() {
    RoleBindingRestrictionList buildable = new RoleBindingRestrictionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}