package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceAccessReviewBuilder extends ResourceAccessReviewFluentImpl<ResourceAccessReviewBuilder> implements VisitableBuilder<ResourceAccessReview,ResourceAccessReviewBuilder>{
  public ResourceAccessReviewBuilder() {
    this(false);
  }
  public ResourceAccessReviewBuilder(Boolean validationEnabled) {
    this(new ResourceAccessReview(), validationEnabled);
  }
  public ResourceAccessReviewBuilder(ResourceAccessReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceAccessReviewBuilder(ResourceAccessReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceAccessReview(), validationEnabled);
  }
  public ResourceAccessReviewBuilder(ResourceAccessReviewFluent<?> fluent,ResourceAccessReview instance) {
    this(fluent, instance, false);
  }
  public ResourceAccessReviewBuilder(ResourceAccessReviewFluent<?> fluent,ResourceAccessReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withContent(instance.getContent());
      fluent.withIsNonResourceURL(instance.getIsNonResourceURL());
      fluent.withKind(instance.getKind());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPath(instance.getPath());
      fluent.withResource(instance.getResource());
      fluent.withResourceAPIGroup(instance.getResourceAPIGroup());
      fluent.withResourceAPIVersion(instance.getResourceAPIVersion());
      fluent.withResourceName(instance.getResourceName());
      fluent.withVerb(instance.getVerb());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceAccessReviewBuilder(ResourceAccessReview instance) {
    this(instance,false);
  }
  public ResourceAccessReviewBuilder(ResourceAccessReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withContent(instance.getContent());
      this.withIsNonResourceURL(instance.getIsNonResourceURL());
      this.withKind(instance.getKind());
      this.withNamespace(instance.getNamespace());
      this.withPath(instance.getPath());
      this.withResource(instance.getResource());
      this.withResourceAPIGroup(instance.getResourceAPIGroup());
      this.withResourceAPIVersion(instance.getResourceAPIVersion());
      this.withResourceName(instance.getResourceName());
      this.withVerb(instance.getVerb());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceAccessReviewFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceAccessReview build() {
    ResourceAccessReview buildable = new ResourceAccessReview(fluent.getApiVersion(),fluent.getContent(),fluent.getIsNonResourceURL(),fluent.getKind(),fluent.getNamespace(),fluent.getPath(),fluent.getResource(),fluent.getResourceAPIGroup(),fluent.getResourceAPIVersion(),fluent.getResourceName(),fluent.getVerb());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}