package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentCauseImageTriggerBuilder extends DeploymentCauseImageTriggerFluentImpl<DeploymentCauseImageTriggerBuilder> implements VisitableBuilder<DeploymentCauseImageTrigger,DeploymentCauseImageTriggerBuilder>{
  public DeploymentCauseImageTriggerBuilder() {
    this(false);
  }
  public DeploymentCauseImageTriggerBuilder(Boolean validationEnabled) {
    this(new DeploymentCauseImageTrigger(), validationEnabled);
  }
  public DeploymentCauseImageTriggerBuilder(DeploymentCauseImageTriggerFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentCauseImageTriggerBuilder(DeploymentCauseImageTriggerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentCauseImageTrigger(), validationEnabled);
  }
  public DeploymentCauseImageTriggerBuilder(DeploymentCauseImageTriggerFluent<?> fluent,DeploymentCauseImageTrigger instance) {
    this(fluent, instance, false);
  }
  public DeploymentCauseImageTriggerBuilder(DeploymentCauseImageTriggerFluent<?> fluent,DeploymentCauseImageTrigger instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFrom(instance.getFrom());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentCauseImageTriggerBuilder(DeploymentCauseImageTrigger instance) {
    this(instance,false);
  }
  public DeploymentCauseImageTriggerBuilder(DeploymentCauseImageTrigger instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFrom(instance.getFrom());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentCauseImageTriggerFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentCauseImageTrigger build() {
    DeploymentCauseImageTrigger buildable = new DeploymentCauseImageTrigger(fluent.getFrom());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}