package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterNetworkBuilder extends ClusterNetworkFluentImpl<ClusterNetworkBuilder> implements VisitableBuilder<ClusterNetwork,ClusterNetworkBuilder>{
  public ClusterNetworkBuilder() {
    this(false);
  }
  public ClusterNetworkBuilder(Boolean validationEnabled) {
    this(new ClusterNetwork(), validationEnabled);
  }
  public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterNetwork(), validationEnabled);
  }
  public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent,ClusterNetwork instance) {
    this(fluent, instance, false);
  }
  public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent,ClusterNetwork instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withClusterNetworks(instance.getClusterNetworks());
      fluent.withHostsubnetlength(instance.getHostsubnetlength());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withMtu(instance.getMtu());
      fluent.withNetwork(instance.getNetwork());
      fluent.withPluginName(instance.getPluginName());
      fluent.withServiceNetwork(instance.getServiceNetwork());
      fluent.withVxlanPort(instance.getVxlanPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterNetworkBuilder(ClusterNetwork instance) {
    this(instance,false);
  }
  public ClusterNetworkBuilder(ClusterNetwork instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withClusterNetworks(instance.getClusterNetworks());
      this.withHostsubnetlength(instance.getHostsubnetlength());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withMtu(instance.getMtu());
      this.withNetwork(instance.getNetwork());
      this.withPluginName(instance.getPluginName());
      this.withServiceNetwork(instance.getServiceNetwork());
      this.withVxlanPort(instance.getVxlanPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterNetworkFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterNetwork build() {
    ClusterNetwork buildable = new ClusterNetwork(fluent.getApiVersion(),fluent.getClusterNetworks(),fluent.getHostsubnetlength(),fluent.getKind(),fluent.getMetadata(),fluent.getMtu(),fluent.getNetwork(),fluent.getPluginName(),fluent.getServiceNetwork(),fluent.getVxlanPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}