package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildStatusOutputToBuilder extends BuildStatusOutputToFluentImpl<BuildStatusOutputToBuilder> implements VisitableBuilder<BuildStatusOutputTo,BuildStatusOutputToBuilder>{
  public BuildStatusOutputToBuilder() {
    this(false);
  }
  public BuildStatusOutputToBuilder(Boolean validationEnabled) {
    this(new BuildStatusOutputTo(), validationEnabled);
  }
  public BuildStatusOutputToBuilder(BuildStatusOutputToFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildStatusOutputToBuilder(BuildStatusOutputToFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildStatusOutputTo(), validationEnabled);
  }
  public BuildStatusOutputToBuilder(BuildStatusOutputToFluent<?> fluent,BuildStatusOutputTo instance) {
    this(fluent, instance, false);
  }
  public BuildStatusOutputToBuilder(BuildStatusOutputToFluent<?> fluent,BuildStatusOutputTo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withImageDigest(instance.getImageDigest());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildStatusOutputToBuilder(BuildStatusOutputTo instance) {
    this(instance,false);
  }
  public BuildStatusOutputToBuilder(BuildStatusOutputTo instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withImageDigest(instance.getImageDigest());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildStatusOutputToFluent<?> fluent;
  Boolean validationEnabled;
  public BuildStatusOutputTo build() {
    BuildStatusOutputTo buildable = new BuildStatusOutputTo(fluent.getImageDigest());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}