package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildOutputFluentImpl<A extends BuildOutputFluent<A>> extends BaseFluent<A> implements BuildOutputFluent<A>{
  public BuildOutputFluentImpl() {
  }
  public BuildOutputFluentImpl(BuildOutput instance) {
    if (instance != null) {
      this.withImageLabels(instance.getImageLabels());
      this.withPushSecret(instance.getPushSecret());
      this.withTo(instance.getTo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ImageLabelBuilder> imageLabels = new ArrayList<ImageLabelBuilder>();
  private LocalObjectReferenceBuilder pushSecret;
  private ObjectReferenceBuilder to;
  private Map<String,Object> additionalProperties;
  public A addToImageLabels(int index,ImageLabel item) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    ImageLabelBuilder builder = new ImageLabelBuilder(item);
    if (index < 0 || index >= imageLabels.size()) { _visitables.get("imageLabels").add(builder); imageLabels.add(builder); } else { _visitables.get("imageLabels").add(index, builder); imageLabels.add(index, builder);}
    return (A)this;
  }
  public A setToImageLabels(int index,ImageLabel item) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    ImageLabelBuilder builder = new ImageLabelBuilder(item);
    if (index < 0 || index >= imageLabels.size()) { _visitables.get("imageLabels").add(builder); imageLabels.add(builder); } else { _visitables.get("imageLabels").set(index, builder); imageLabels.set(index, builder);}
    return (A)this;
  }
  public A addToImageLabels(io.fabric8.openshift.api.model.ImageLabel... items) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
  }
  public A addAllToImageLabels(Collection<ImageLabel> items) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
  }
  public A removeFromImageLabels(io.fabric8.openshift.api.model.ImageLabel... items) {
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder);if (this.imageLabels != null) {this.imageLabels.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageLabels(Collection<ImageLabel> items) {
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder);if (this.imageLabels != null) {this.imageLabels.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageLabels(Predicate<ImageLabelBuilder> predicate) {
    if (imageLabels == null) return (A) this;
    final Iterator<ImageLabelBuilder> each = imageLabels.iterator();
    final List visitables = _visitables.get("imageLabels");
    while (each.hasNext()) {
      ImageLabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImageLabels instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageLabel> getImageLabels() {
    return imageLabels != null ? build(imageLabels) : null;
  }
  public List<ImageLabel> buildImageLabels() {
    return imageLabels != null ? build(imageLabels) : null;
  }
  public ImageLabel buildImageLabel(int index) {
    return this.imageLabels.get(index).build();
  }
  public ImageLabel buildFirstImageLabel() {
    return this.imageLabels.get(0).build();
  }
  public ImageLabel buildLastImageLabel() {
    return this.imageLabels.get(imageLabels.size() - 1).build();
  }
  public ImageLabel buildMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
    for (ImageLabelBuilder item: imageLabels) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
    for (ImageLabelBuilder item: imageLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImageLabels(List<ImageLabel> imageLabels) {
    if (this.imageLabels != null) { _visitables.get("imageLabels").clear();}
    if (imageLabels != null) {this.imageLabels = new ArrayList(); for (ImageLabel item : imageLabels){this.addToImageLabels(item);}} else { this.imageLabels = null;} return (A) this;
  }
  public A withImageLabels(io.fabric8.openshift.api.model.ImageLabel... imageLabels) {
    if (this.imageLabels != null) {this.imageLabels.clear(); _visitables.remove("imageLabels"); }
    if (imageLabels != null) {for (ImageLabel item :imageLabels){ this.addToImageLabels(item);}} return (A) this;
  }
  public Boolean hasImageLabels() {
    return imageLabels != null && !imageLabels.isEmpty();
  }
  public A addNewImageLabel(String name,String value) {
    return (A)addToImageLabels(new ImageLabel(name, value));
  }
  public BuildOutputFluentImpl.ImageLabelsNested<A> addNewImageLabel() {
    return new BuildOutputFluentImpl.ImageLabelsNestedImpl();
  }
  public BuildOutputFluentImpl.ImageLabelsNested<A> addNewImageLabelLike(ImageLabel item) {
    return new BuildOutputFluentImpl.ImageLabelsNestedImpl(-1, item);
  }
  public BuildOutputFluentImpl.ImageLabelsNested<A> setNewImageLabelLike(int index,ImageLabel item) {
    return new BuildOutputFluentImpl.ImageLabelsNestedImpl(index, item);
  }
  public BuildOutputFluentImpl.ImageLabelsNested<A> editImageLabel(int index) {
    if (imageLabels.size() <= index) throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  public BuildOutputFluentImpl.ImageLabelsNested<A> editFirstImageLabel() {
    if (imageLabels.size() == 0) throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
    return setNewImageLabelLike(0, buildImageLabel(0));
  }
  public BuildOutputFluentImpl.ImageLabelsNested<A> editLastImageLabel() {
    int index = imageLabels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  public BuildOutputFluentImpl.ImageLabelsNested<A> editMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageLabels.size();i++) { 
    if (predicate.test(imageLabels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageLabels. No match found.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  
  /**
   * This method has been deprecated, please use method buildPushSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getPushSecret() {
    return this.pushSecret!=null ?this.pushSecret.build():null;
  }
  public LocalObjectReference buildPushSecret() {
    return this.pushSecret!=null ?this.pushSecret.build():null;
  }
  public A withPushSecret(LocalObjectReference pushSecret) {
    _visitables.get("pushSecret").remove(this.pushSecret);
    if (pushSecret!=null){ this.pushSecret= new LocalObjectReferenceBuilder(pushSecret); _visitables.get("pushSecret").add(this.pushSecret);} else { this.pushSecret = null; _visitables.get("pushSecret").remove(this.pushSecret); } return (A) this;
  }
  public Boolean hasPushSecret() {
    return this.pushSecret != null;
  }
  public A withNewPushSecret(String name) {
    return (A)withPushSecret(new LocalObjectReference(name));
  }
  public BuildOutputFluentImpl.PushSecretNested<A> withNewPushSecret() {
    return new BuildOutputFluentImpl.PushSecretNestedImpl();
  }
  public BuildOutputFluentImpl.PushSecretNested<A> withNewPushSecretLike(LocalObjectReference item) {
    return new BuildOutputFluentImpl.PushSecretNestedImpl(item);
  }
  public BuildOutputFluentImpl.PushSecretNested<A> editPushSecret() {
    return withNewPushSecretLike(getPushSecret());
  }
  public BuildOutputFluentImpl.PushSecretNested<A> editOrNewPushSecret() {
    return withNewPushSecretLike(getPushSecret() != null ? getPushSecret(): new LocalObjectReferenceBuilder().build());
  }
  public BuildOutputFluentImpl.PushSecretNested<A> editOrNewPushSecretLike(LocalObjectReference item) {
    return withNewPushSecretLike(getPushSecret() != null ? getPushSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTo instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getTo() {
    return this.to!=null ?this.to.build():null;
  }
  public ObjectReference buildTo() {
    return this.to!=null ?this.to.build():null;
  }
  public A withTo(ObjectReference to) {
    _visitables.get("to").remove(this.to);
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.get("to").add(this.to);} else { this.to = null; _visitables.get("to").remove(this.to); } return (A) this;
  }
  public Boolean hasTo() {
    return this.to != null;
  }
  public BuildOutputFluentImpl.ToNested<A> withNewTo() {
    return new BuildOutputFluentImpl.ToNestedImpl();
  }
  public BuildOutputFluentImpl.ToNested<A> withNewToLike(ObjectReference item) {
    return new BuildOutputFluentImpl.ToNestedImpl(item);
  }
  public BuildOutputFluentImpl.ToNested<A> editTo() {
    return withNewToLike(getTo());
  }
  public BuildOutputFluentImpl.ToNested<A> editOrNewTo() {
    return withNewToLike(getTo() != null ? getTo(): new ObjectReferenceBuilder().build());
  }
  public BuildOutputFluentImpl.ToNested<A> editOrNewToLike(ObjectReference item) {
    return withNewToLike(getTo() != null ? getTo(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildOutputFluentImpl that = (BuildOutputFluentImpl) o;
    if (!java.util.Objects.equals(imageLabels, that.imageLabels)) return false;

    if (!java.util.Objects.equals(pushSecret, that.pushSecret)) return false;

    if (!java.util.Objects.equals(to, that.to)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(imageLabels,  pushSecret,  to,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (imageLabels != null && !imageLabels.isEmpty()) { sb.append("imageLabels:"); sb.append(imageLabels + ","); }
    if (pushSecret != null) { sb.append("pushSecret:"); sb.append(pushSecret + ","); }
    if (to != null) { sb.append("to:"); sb.append(to + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImageLabelsNestedImpl<N> extends ImageLabelFluentImpl<BuildOutputFluentImpl.ImageLabelsNested<N>> implements BuildOutputFluentImpl.ImageLabelsNested<N>,Nested<N>{
    ImageLabelsNestedImpl(int index,ImageLabel item) {
      this.index = index;
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelsNestedImpl() {
      this.index = -1;
      this.builder = new ImageLabelBuilder(this);
    }
    ImageLabelBuilder builder;
    int index;
    public N and() {
      return (N) BuildOutputFluentImpl.this.setToImageLabels(index,builder.build());
    }
    public N endImageLabel() {
      return and();
    }
    
  }
  class PushSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<BuildOutputFluentImpl.PushSecretNested<N>> implements BuildOutputFluentImpl.PushSecretNested<N>,Nested<N>{
    PushSecretNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    PushSecretNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) BuildOutputFluentImpl.this.withPushSecret(builder.build());
    }
    public N endPushSecret() {
      return and();
    }
    
  }
  class ToNestedImpl<N> extends ObjectReferenceFluentImpl<BuildOutputFluentImpl.ToNested<N>> implements BuildOutputFluentImpl.ToNested<N>,Nested<N>{
    ToNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ToNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) BuildOutputFluentImpl.this.withTo(builder.build());
    }
    public N endTo() {
      return and();
    }
    
  }
  
}