package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildConfigStatusBuilder extends BuildConfigStatusFluentImpl<BuildConfigStatusBuilder> implements VisitableBuilder<BuildConfigStatus,BuildConfigStatusBuilder>{
  public BuildConfigStatusBuilder() {
    this(false);
  }
  public BuildConfigStatusBuilder(Boolean validationEnabled) {
    this(new BuildConfigStatus(), validationEnabled);
  }
  public BuildConfigStatusBuilder(BuildConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildConfigStatusBuilder(BuildConfigStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildConfigStatus(), validationEnabled);
  }
  public BuildConfigStatusBuilder(BuildConfigStatusFluent<?> fluent,BuildConfigStatus instance) {
    this(fluent, instance, false);
  }
  public BuildConfigStatusBuilder(BuildConfigStatusFluent<?> fluent,BuildConfigStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withImageChangeTriggers(instance.getImageChangeTriggers());
      fluent.withLastVersion(instance.getLastVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildConfigStatusBuilder(BuildConfigStatus instance) {
    this(instance,false);
  }
  public BuildConfigStatusBuilder(BuildConfigStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withImageChangeTriggers(instance.getImageChangeTriggers());
      this.withLastVersion(instance.getLastVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildConfigStatusFluent<?> fluent;
  Boolean validationEnabled;
  public BuildConfigStatus build() {
    BuildConfigStatus buildable = new BuildConfigStatus(fluent.getImageChangeTriggers(),fluent.getLastVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}