package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildConfigSpecFluentImpl<A extends BuildConfigSpecFluent<A>> extends BaseFluent<A> implements BuildConfigSpecFluent<A>{
  public BuildConfigSpecFluentImpl() {
  }
  public BuildConfigSpecFluentImpl(BuildConfigSpec instance) {
    if (instance != null) {
      this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
      this.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit());
      this.withMountTrustedCA(instance.getMountTrustedCA());
      this.withNodeSelector(instance.getNodeSelector());
      this.withOutput(instance.getOutput());
      this.withPostCommit(instance.getPostCommit());
      this.withResources(instance.getResources());
      this.withRevision(instance.getRevision());
      this.withRunPolicy(instance.getRunPolicy());
      this.withServiceAccount(instance.getServiceAccount());
      this.withSource(instance.getSource());
      this.withStrategy(instance.getStrategy());
      this.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit());
      this.withTriggers(instance.getTriggers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Long completionDeadlineSeconds;
  private Integer failedBuildsHistoryLimit;
  private Boolean mountTrustedCA;
  private Map<String,String> nodeSelector;
  private BuildOutputBuilder output;
  private BuildPostCommitSpecBuilder postCommit;
  private ResourceRequirementsBuilder resources;
  private SourceRevisionBuilder revision;
  private String runPolicy;
  private String serviceAccount;
  private BuildSourceBuilder source;
  private BuildStrategyBuilder strategy;
  private Integer successfulBuildsHistoryLimit;
  private ArrayList<BuildTriggerPolicyBuilder> triggers = new ArrayList<BuildTriggerPolicyBuilder>();
  private Map<String,Object> additionalProperties;
  public Long getCompletionDeadlineSeconds() {
    return this.completionDeadlineSeconds;
  }
  public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
    this.completionDeadlineSeconds=completionDeadlineSeconds; return (A) this;
  }
  public Boolean hasCompletionDeadlineSeconds() {
    return this.completionDeadlineSeconds != null;
  }
  public Integer getFailedBuildsHistoryLimit() {
    return this.failedBuildsHistoryLimit;
  }
  public A withFailedBuildsHistoryLimit(Integer failedBuildsHistoryLimit) {
    this.failedBuildsHistoryLimit=failedBuildsHistoryLimit; return (A) this;
  }
  public Boolean hasFailedBuildsHistoryLimit() {
    return this.failedBuildsHistoryLimit != null;
  }
  public Boolean getMountTrustedCA() {
    return this.mountTrustedCA;
  }
  public A withMountTrustedCA(Boolean mountTrustedCA) {
    this.mountTrustedCA=mountTrustedCA; return (A) this;
  }
  public Boolean hasMountTrustedCA() {
    return this.mountTrustedCA != null;
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOutput instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildOutput getOutput() {
    return this.output!=null ?this.output.build():null;
  }
  public BuildOutput buildOutput() {
    return this.output!=null ?this.output.build():null;
  }
  public A withOutput(BuildOutput output) {
    _visitables.get("output").remove(this.output);
    if (output!=null){ this.output= new BuildOutputBuilder(output); _visitables.get("output").add(this.output);} else { this.output = null; _visitables.get("output").remove(this.output); } return (A) this;
  }
  public Boolean hasOutput() {
    return this.output != null;
  }
  public BuildConfigSpecFluentImpl.OutputNested<A> withNewOutput() {
    return new BuildConfigSpecFluentImpl.OutputNestedImpl();
  }
  public BuildConfigSpecFluentImpl.OutputNested<A> withNewOutputLike(BuildOutput item) {
    return new BuildConfigSpecFluentImpl.OutputNestedImpl(item);
  }
  public BuildConfigSpecFluentImpl.OutputNested<A> editOutput() {
    return withNewOutputLike(getOutput());
  }
  public BuildConfigSpecFluentImpl.OutputNested<A> editOrNewOutput() {
    return withNewOutputLike(getOutput() != null ? getOutput(): new BuildOutputBuilder().build());
  }
  public BuildConfigSpecFluentImpl.OutputNested<A> editOrNewOutputLike(BuildOutput item) {
    return withNewOutputLike(getOutput() != null ? getOutput(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPostCommit instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildPostCommitSpec getPostCommit() {
    return this.postCommit!=null ?this.postCommit.build():null;
  }
  public BuildPostCommitSpec buildPostCommit() {
    return this.postCommit!=null ?this.postCommit.build():null;
  }
  public A withPostCommit(BuildPostCommitSpec postCommit) {
    _visitables.get("postCommit").remove(this.postCommit);
    if (postCommit!=null){ this.postCommit= new BuildPostCommitSpecBuilder(postCommit); _visitables.get("postCommit").add(this.postCommit);} else { this.postCommit = null; _visitables.get("postCommit").remove(this.postCommit); } return (A) this;
  }
  public Boolean hasPostCommit() {
    return this.postCommit != null;
  }
  public BuildConfigSpecFluentImpl.PostCommitNested<A> withNewPostCommit() {
    return new BuildConfigSpecFluentImpl.PostCommitNestedImpl();
  }
  public BuildConfigSpecFluentImpl.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item) {
    return new BuildConfigSpecFluentImpl.PostCommitNestedImpl(item);
  }
  public BuildConfigSpecFluentImpl.PostCommitNested<A> editPostCommit() {
    return withNewPostCommitLike(getPostCommit());
  }
  public BuildConfigSpecFluentImpl.PostCommitNested<A> editOrNewPostCommit() {
    return withNewPostCommitLike(getPostCommit() != null ? getPostCommit(): new BuildPostCommitSpecBuilder().build());
  }
  public BuildConfigSpecFluentImpl.PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item) {
    return withNewPostCommitLike(getPostCommit() != null ? getPostCommit(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public BuildConfigSpecFluentImpl.ResourcesNested<A> withNewResources() {
    return new BuildConfigSpecFluentImpl.ResourcesNestedImpl();
  }
  public BuildConfigSpecFluentImpl.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new BuildConfigSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public BuildConfigSpecFluentImpl.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public BuildConfigSpecFluentImpl.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public BuildConfigSpecFluentImpl.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRevision instead.
   * @return The buildable object.
   */
  @Deprecated
  public SourceRevision getRevision() {
    return this.revision!=null ?this.revision.build():null;
  }
  public SourceRevision buildRevision() {
    return this.revision!=null ?this.revision.build():null;
  }
  public A withRevision(SourceRevision revision) {
    _visitables.get("revision").remove(this.revision);
    if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.get("revision").add(this.revision);} else { this.revision = null; _visitables.get("revision").remove(this.revision); } return (A) this;
  }
  public Boolean hasRevision() {
    return this.revision != null;
  }
  public BuildConfigSpecFluentImpl.RevisionNested<A> withNewRevision() {
    return new BuildConfigSpecFluentImpl.RevisionNestedImpl();
  }
  public BuildConfigSpecFluentImpl.RevisionNested<A> withNewRevisionLike(SourceRevision item) {
    return new BuildConfigSpecFluentImpl.RevisionNestedImpl(item);
  }
  public BuildConfigSpecFluentImpl.RevisionNested<A> editRevision() {
    return withNewRevisionLike(getRevision());
  }
  public BuildConfigSpecFluentImpl.RevisionNested<A> editOrNewRevision() {
    return withNewRevisionLike(getRevision() != null ? getRevision(): new SourceRevisionBuilder().build());
  }
  public BuildConfigSpecFluentImpl.RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
    return withNewRevisionLike(getRevision() != null ? getRevision(): item);
  }
  public String getRunPolicy() {
    return this.runPolicy;
  }
  public A withRunPolicy(String runPolicy) {
    this.runPolicy=runPolicy; return (A) this;
  }
  public Boolean hasRunPolicy() {
    return this.runPolicy != null;
  }
  public String getServiceAccount() {
    return this.serviceAccount;
  }
  public A withServiceAccount(String serviceAccount) {
    this.serviceAccount=serviceAccount; return (A) this;
  }
  public Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildSource getSource() {
    return this.source!=null ?this.source.build():null;
  }
  public BuildSource buildSource() {
    return this.source!=null ?this.source.build():null;
  }
  public A withSource(BuildSource source) {
    _visitables.get("source").remove(this.source);
    if (source!=null){ this.source= new BuildSourceBuilder(source); _visitables.get("source").add(this.source);} else { this.source = null; _visitables.get("source").remove(this.source); } return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public BuildConfigSpecFluentImpl.SourceNested<A> withNewSource() {
    return new BuildConfigSpecFluentImpl.SourceNestedImpl();
  }
  public BuildConfigSpecFluentImpl.SourceNested<A> withNewSourceLike(BuildSource item) {
    return new BuildConfigSpecFluentImpl.SourceNestedImpl(item);
  }
  public BuildConfigSpecFluentImpl.SourceNested<A> editSource() {
    return withNewSourceLike(getSource());
  }
  public BuildConfigSpecFluentImpl.SourceNested<A> editOrNewSource() {
    return withNewSourceLike(getSource() != null ? getSource(): new BuildSourceBuilder().build());
  }
  public BuildConfigSpecFluentImpl.SourceNested<A> editOrNewSourceLike(BuildSource item) {
    return withNewSourceLike(getSource() != null ? getSource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildStrategy getStrategy() {
    return this.strategy!=null ?this.strategy.build():null;
  }
  public BuildStrategy buildStrategy() {
    return this.strategy!=null ?this.strategy.build():null;
  }
  public A withStrategy(BuildStrategy strategy) {
    _visitables.get("strategy").remove(this.strategy);
    if (strategy!=null){ this.strategy= new BuildStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} else { this.strategy = null; _visitables.get("strategy").remove(this.strategy); } return (A) this;
  }
  public Boolean hasStrategy() {
    return this.strategy != null;
  }
  public BuildConfigSpecFluentImpl.StrategyNested<A> withNewStrategy() {
    return new BuildConfigSpecFluentImpl.StrategyNestedImpl();
  }
  public BuildConfigSpecFluentImpl.StrategyNested<A> withNewStrategyLike(BuildStrategy item) {
    return new BuildConfigSpecFluentImpl.StrategyNestedImpl(item);
  }
  public BuildConfigSpecFluentImpl.StrategyNested<A> editStrategy() {
    return withNewStrategyLike(getStrategy());
  }
  public BuildConfigSpecFluentImpl.StrategyNested<A> editOrNewStrategy() {
    return withNewStrategyLike(getStrategy() != null ? getStrategy(): new BuildStrategyBuilder().build());
  }
  public BuildConfigSpecFluentImpl.StrategyNested<A> editOrNewStrategyLike(BuildStrategy item) {
    return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
  }
  public Integer getSuccessfulBuildsHistoryLimit() {
    return this.successfulBuildsHistoryLimit;
  }
  public A withSuccessfulBuildsHistoryLimit(Integer successfulBuildsHistoryLimit) {
    this.successfulBuildsHistoryLimit=successfulBuildsHistoryLimit; return (A) this;
  }
  public Boolean hasSuccessfulBuildsHistoryLimit() {
    return this.successfulBuildsHistoryLimit != null;
  }
  public A addToTriggers(int index,BuildTriggerPolicy item) {
    if (this.triggers == null) {this.triggers = new ArrayList<BuildTriggerPolicyBuilder>();}
    BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
    if (index < 0 || index >= triggers.size()) { _visitables.get("triggers").add(builder); triggers.add(builder); } else { _visitables.get("triggers").add(index, builder); triggers.add(index, builder);}
    return (A)this;
  }
  public A setToTriggers(int index,BuildTriggerPolicy item) {
    if (this.triggers == null) {this.triggers = new ArrayList<BuildTriggerPolicyBuilder>();}
    BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
    if (index < 0 || index >= triggers.size()) { _visitables.get("triggers").add(builder); triggers.add(builder); } else { _visitables.get("triggers").set(index, builder); triggers.set(index, builder);}
    return (A)this;
  }
  public A addToTriggers(io.fabric8.openshift.api.model.BuildTriggerPolicy... items) {
    if (this.triggers == null) {this.triggers = new ArrayList<BuildTriggerPolicyBuilder>();}
    for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A addAllToTriggers(Collection<BuildTriggerPolicy> items) {
    if (this.triggers == null) {this.triggers = new ArrayList<BuildTriggerPolicyBuilder>();}
    for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A removeFromTriggers(io.fabric8.openshift.api.model.BuildTriggerPolicy... items) {
    for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
  }
  public A removeAllFromTriggers(Collection<BuildTriggerPolicy> items) {
    for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTriggers(Predicate<BuildTriggerPolicyBuilder> predicate) {
    if (triggers == null) return (A) this;
    final Iterator<BuildTriggerPolicyBuilder> each = triggers.iterator();
    final List visitables = _visitables.get("triggers");
    while (each.hasNext()) {
      BuildTriggerPolicyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTriggers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BuildTriggerPolicy> getTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public List<BuildTriggerPolicy> buildTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public BuildTriggerPolicy buildTrigger(int index) {
    return this.triggers.get(index).build();
  }
  public BuildTriggerPolicy buildFirstTrigger() {
    return this.triggers.get(0).build();
  }
  public BuildTriggerPolicy buildLastTrigger() {
    return this.triggers.get(triggers.size() - 1).build();
  }
  public BuildTriggerPolicy buildMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate) {
    for (BuildTriggerPolicyBuilder item: triggers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate) {
    for (BuildTriggerPolicyBuilder item: triggers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTriggers(List<BuildTriggerPolicy> triggers) {
    if (this.triggers != null) { _visitables.get("triggers").clear();}
    if (triggers != null) {this.triggers = new ArrayList(); for (BuildTriggerPolicy item : triggers){this.addToTriggers(item);}} else { this.triggers = null;} return (A) this;
  }
  public A withTriggers(io.fabric8.openshift.api.model.BuildTriggerPolicy... triggers) {
    if (this.triggers != null) {this.triggers.clear(); _visitables.remove("triggers"); }
    if (triggers != null) {for (BuildTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (A) this;
  }
  public Boolean hasTriggers() {
    return triggers != null && !triggers.isEmpty();
  }
  public BuildConfigSpecFluentImpl.TriggersNested<A> addNewTrigger() {
    return new BuildConfigSpecFluentImpl.TriggersNestedImpl();
  }
  public BuildConfigSpecFluentImpl.TriggersNested<A> addNewTriggerLike(BuildTriggerPolicy item) {
    return new BuildConfigSpecFluentImpl.TriggersNestedImpl(-1, item);
  }
  public BuildConfigSpecFluentImpl.TriggersNested<A> setNewTriggerLike(int index,BuildTriggerPolicy item) {
    return new BuildConfigSpecFluentImpl.TriggersNestedImpl(index, item);
  }
  public BuildConfigSpecFluentImpl.TriggersNested<A> editTrigger(int index) {
    if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public BuildConfigSpecFluentImpl.TriggersNested<A> editFirstTrigger() {
    if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
    return setNewTriggerLike(0, buildTrigger(0));
  }
  public BuildConfigSpecFluentImpl.TriggersNested<A> editLastTrigger() {
    int index = triggers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public BuildConfigSpecFluentImpl.TriggersNested<A> editMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggers.size();i++) { 
    if (predicate.test(triggers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildConfigSpecFluentImpl that = (BuildConfigSpecFluentImpl) o;
    if (!java.util.Objects.equals(completionDeadlineSeconds, that.completionDeadlineSeconds)) return false;

    if (!java.util.Objects.equals(failedBuildsHistoryLimit, that.failedBuildsHistoryLimit)) return false;

    if (!java.util.Objects.equals(mountTrustedCA, that.mountTrustedCA)) return false;

    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;

    if (!java.util.Objects.equals(output, that.output)) return false;

    if (!java.util.Objects.equals(postCommit, that.postCommit)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(revision, that.revision)) return false;

    if (!java.util.Objects.equals(runPolicy, that.runPolicy)) return false;

    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(strategy, that.strategy)) return false;

    if (!java.util.Objects.equals(successfulBuildsHistoryLimit, that.successfulBuildsHistoryLimit)) return false;

    if (!java.util.Objects.equals(triggers, that.triggers)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(completionDeadlineSeconds,  failedBuildsHistoryLimit,  mountTrustedCA,  nodeSelector,  output,  postCommit,  resources,  revision,  runPolicy,  serviceAccount,  source,  strategy,  successfulBuildsHistoryLimit,  triggers,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (completionDeadlineSeconds != null) { sb.append("completionDeadlineSeconds:"); sb.append(completionDeadlineSeconds + ","); }
    if (failedBuildsHistoryLimit != null) { sb.append("failedBuildsHistoryLimit:"); sb.append(failedBuildsHistoryLimit + ","); }
    if (mountTrustedCA != null) { sb.append("mountTrustedCA:"); sb.append(mountTrustedCA + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (output != null) { sb.append("output:"); sb.append(output + ","); }
    if (postCommit != null) { sb.append("postCommit:"); sb.append(postCommit + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision + ","); }
    if (runPolicy != null) { sb.append("runPolicy:"); sb.append(runPolicy + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (successfulBuildsHistoryLimit != null) { sb.append("successfulBuildsHistoryLimit:"); sb.append(successfulBuildsHistoryLimit + ","); }
    if (triggers != null && !triggers.isEmpty()) { sb.append("triggers:"); sb.append(triggers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withMountTrustedCA() {
    return withMountTrustedCA(true);
  }
  class OutputNestedImpl<N> extends BuildOutputFluentImpl<BuildConfigSpecFluentImpl.OutputNested<N>> implements BuildConfigSpecFluentImpl.OutputNested<N>,Nested<N>{
    OutputNestedImpl(BuildOutput item) {
      this.builder = new BuildOutputBuilder(this, item);
    }
    OutputNestedImpl() {
      this.builder = new BuildOutputBuilder(this);
    }
    BuildOutputBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withOutput(builder.build());
    }
    public N endOutput() {
      return and();
    }
    
  }
  class PostCommitNestedImpl<N> extends BuildPostCommitSpecFluentImpl<BuildConfigSpecFluentImpl.PostCommitNested<N>> implements BuildConfigSpecFluentImpl.PostCommitNested<N>,Nested<N>{
    PostCommitNestedImpl(BuildPostCommitSpec item) {
      this.builder = new BuildPostCommitSpecBuilder(this, item);
    }
    PostCommitNestedImpl() {
      this.builder = new BuildPostCommitSpecBuilder(this);
    }
    BuildPostCommitSpecBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withPostCommit(builder.build());
    }
    public N endPostCommit() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<BuildConfigSpecFluentImpl.ResourcesNested<N>> implements BuildConfigSpecFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<BuildConfigSpecFluentImpl.RevisionNested<N>> implements BuildConfigSpecFluentImpl.RevisionNested<N>,Nested<N>{
    RevisionNestedImpl(SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    RevisionNestedImpl() {
      this.builder = new SourceRevisionBuilder(this);
    }
    SourceRevisionBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withRevision(builder.build());
    }
    public N endRevision() {
      return and();
    }
    
  }
  class SourceNestedImpl<N> extends BuildSourceFluentImpl<BuildConfigSpecFluentImpl.SourceNested<N>> implements BuildConfigSpecFluentImpl.SourceNested<N>,Nested<N>{
    SourceNestedImpl(BuildSource item) {
      this.builder = new BuildSourceBuilder(this, item);
    }
    SourceNestedImpl() {
      this.builder = new BuildSourceBuilder(this);
    }
    BuildSourceBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withSource(builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  class StrategyNestedImpl<N> extends BuildStrategyFluentImpl<BuildConfigSpecFluentImpl.StrategyNested<N>> implements BuildConfigSpecFluentImpl.StrategyNested<N>,Nested<N>{
    StrategyNestedImpl(BuildStrategy item) {
      this.builder = new BuildStrategyBuilder(this, item);
    }
    StrategyNestedImpl() {
      this.builder = new BuildStrategyBuilder(this);
    }
    BuildStrategyBuilder builder;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy() {
      return and();
    }
    
  }
  class TriggersNestedImpl<N> extends BuildTriggerPolicyFluentImpl<BuildConfigSpecFluentImpl.TriggersNested<N>> implements BuildConfigSpecFluentImpl.TriggersNested<N>,Nested<N>{
    TriggersNestedImpl(int index,BuildTriggerPolicy item) {
      this.index = index;
      this.builder = new BuildTriggerPolicyBuilder(this, item);
    }
    TriggersNestedImpl() {
      this.index = -1;
      this.builder = new BuildTriggerPolicyBuilder(this);
    }
    BuildTriggerPolicyBuilder builder;
    int index;
    public N and() {
      return (N) BuildConfigSpecFluentImpl.this.setToTriggers(index,builder.build());
    }
    public N endTrigger() {
      return and();
    }
    
  }
  
}