/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.GoogleIdentityProvider;
import io.fabric8.openshift.api.model.config.v1.GoogleIdentityProviderFluent;
import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.config.v1.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.SecretNameReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class GoogleIdentityProviderFluentImpl<A extends GoogleIdentityProviderFluent<A>>
extends BaseFluent<A>
implements GoogleIdentityProviderFluent<A> {
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private String hostedDomain;
    private Map<String, Object> additionalProperties;

    public GoogleIdentityProviderFluentImpl() {
    }

    public GoogleIdentityProviderFluentImpl(GoogleIdentityProvider instance) {
        if (instance != null) {
            this.withClientID(instance.getClientID());
            this.withClientSecret(instance.getClientSecret());
            this.withHostedDomain(instance.getHostedDomain());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public A withClientID(String clientID) {
        this.clientID = clientID;
        return (A)this;
    }

    @Override
    public Boolean hasClientID() {
        return this.clientID != null;
    }

    @Override
    @Deprecated
    public SecretNameReference getClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public SecretNameReference buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public A withClientSecret(SecretNameReference clientSecret) {
        this._visitables.get((Object)"clientSecret").remove(this.clientSecret);
        if (clientSecret != null) {
            this.clientSecret = new SecretNameReferenceBuilder(clientSecret);
            this._visitables.get((Object)"clientSecret").add(this.clientSecret);
        } else {
            this.clientSecret = null;
            this._visitables.get((Object)"clientSecret").remove(this.clientSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    @Override
    public A withNewClientSecret(String name) {
        return this.withClientSecret(new SecretNameReference(name));
    }

    @Override
    public GoogleIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNestedImpl();
    }

    @Override
    public GoogleIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNestedImpl(item);
    }

    @Override
    public GoogleIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret());
    }

    @Override
    public GoogleIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public GoogleIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : item);
    }

    @Override
    public String getHostedDomain() {
        return this.hostedDomain;
    }

    @Override
    public A withHostedDomain(String hostedDomain) {
        this.hostedDomain = hostedDomain;
        return (A)this;
    }

    @Override
    public Boolean hasHostedDomain() {
        return this.hostedDomain != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GoogleIdentityProviderFluentImpl that = (GoogleIdentityProviderFluentImpl)o;
        if (!Objects.equals(this.clientID, that.clientID)) {
            return false;
        }
        if (!Objects.equals(this.clientSecret, that.clientSecret)) {
            return false;
        }
        if (!Objects.equals(this.hostedDomain, that.hostedDomain)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.clientID, this.clientSecret, this.hostedDomain, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientID != null) {
            sb.append("clientID:");
            sb.append(this.clientID + ",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append(this.clientSecret + ",");
        }
        if (this.hostedDomain != null) {
            sb.append("hostedDomain:");
            sb.append(this.hostedDomain + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ClientSecretNestedImpl<N>
    extends SecretNameReferenceFluentImpl<GoogleIdentityProviderFluent.ClientSecretNested<N>>
    implements GoogleIdentityProviderFluent.ClientSecretNested<N>,
    Nested<N> {
        SecretNameReferenceBuilder builder;

        ClientSecretNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        ClientSecretNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)GoogleIdentityProviderFluentImpl.this.withClientSecret(this.builder.build());
        }

        @Override
        public N endClientSecret() {
            return this.and();
        }
    }
}

