package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TagEventConditionBuilder extends TagEventConditionFluentImpl<TagEventConditionBuilder> implements VisitableBuilder<TagEventCondition,TagEventConditionBuilder>{
  public TagEventConditionBuilder() {
    this(false);
  }
  public TagEventConditionBuilder(Boolean validationEnabled) {
    this(new TagEventCondition(), validationEnabled);
  }
  public TagEventConditionBuilder(TagEventConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public TagEventConditionBuilder(TagEventConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TagEventCondition(), validationEnabled);
  }
  public TagEventConditionBuilder(TagEventConditionFluent<?> fluent,TagEventCondition instance) {
    this(fluent, instance, false);
  }
  public TagEventConditionBuilder(TagEventConditionFluent<?> fluent,TagEventCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGeneration(instance.getGeneration());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TagEventConditionBuilder(TagEventCondition instance) {
    this(instance,false);
  }
  public TagEventConditionBuilder(TagEventCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGeneration(instance.getGeneration());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TagEventConditionFluent<?> fluent;
  Boolean validationEnabled;
  public TagEventCondition build() {
    TagEventCondition buildable = new TagEventCondition(fluent.getGeneration(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}