package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectRulesReviewBuilder extends SubjectRulesReviewFluentImpl<SubjectRulesReviewBuilder> implements VisitableBuilder<SubjectRulesReview,SubjectRulesReviewBuilder>{
  public SubjectRulesReviewBuilder() {
    this(false);
  }
  public SubjectRulesReviewBuilder(Boolean validationEnabled) {
    this(new SubjectRulesReview(), validationEnabled);
  }
  public SubjectRulesReviewBuilder(SubjectRulesReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectRulesReviewBuilder(SubjectRulesReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubjectRulesReview(), validationEnabled);
  }
  public SubjectRulesReviewBuilder(SubjectRulesReviewFluent<?> fluent,SubjectRulesReview instance) {
    this(fluent, instance, false);
  }
  public SubjectRulesReviewBuilder(SubjectRulesReviewFluent<?> fluent,SubjectRulesReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubjectRulesReviewBuilder(SubjectRulesReview instance) {
    this(instance,false);
  }
  public SubjectRulesReviewBuilder(SubjectRulesReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubjectRulesReviewFluent<?> fluent;
  Boolean validationEnabled;
  public SubjectRulesReview build() {
    SubjectRulesReview buildable = new SubjectRulesReview(fluent.getApiVersion(),fluent.getKind(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}