package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StageInfoBuilder extends StageInfoFluentImpl<StageInfoBuilder> implements VisitableBuilder<StageInfo,StageInfoBuilder>{
  public StageInfoBuilder() {
    this(false);
  }
  public StageInfoBuilder(Boolean validationEnabled) {
    this(new StageInfo(), validationEnabled);
  }
  public StageInfoBuilder(StageInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public StageInfoBuilder(StageInfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StageInfo(), validationEnabled);
  }
  public StageInfoBuilder(StageInfoFluent<?> fluent,StageInfo instance) {
    this(fluent, instance, false);
  }
  public StageInfoBuilder(StageInfoFluent<?> fluent,StageInfo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDurationMilliseconds(instance.getDurationMilliseconds());
      fluent.withName(instance.getName());
      fluent.withStartTime(instance.getStartTime());
      fluent.withSteps(instance.getSteps());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StageInfoBuilder(StageInfo instance) {
    this(instance,false);
  }
  public StageInfoBuilder(StageInfo instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDurationMilliseconds(instance.getDurationMilliseconds());
      this.withName(instance.getName());
      this.withStartTime(instance.getStartTime());
      this.withSteps(instance.getSteps());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StageInfoFluent<?> fluent;
  Boolean validationEnabled;
  public StageInfo build() {
    StageInfo buildable = new StageInfo(fluent.getDurationMilliseconds(),fluent.getName(),fluent.getStartTime(),fluent.getSteps());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}