package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SourceBuildStrategyFluentImpl<A extends SourceBuildStrategyFluent<A>> extends BaseFluent<A> implements SourceBuildStrategyFluent<A>{
  public SourceBuildStrategyFluentImpl() {
  }
  public SourceBuildStrategyFluentImpl(SourceBuildStrategy instance) {
    if (instance != null) {
      this.withEnv(instance.getEnv());
      this.withForcePull(instance.getForcePull());
      this.withFrom(instance.getFrom());
      this.withIncremental(instance.getIncremental());
      this.withPullSecret(instance.getPullSecret());
      this.withScripts(instance.getScripts());
      this.withVolumes(instance.getVolumes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<EnvVar> env = new ArrayList<EnvVar>();
  private Boolean forcePull;
  private ObjectReferenceBuilder from;
  private Boolean incremental;
  private LocalObjectReferenceBuilder pullSecret;
  private String scripts;
  private ArrayList<BuildVolumeBuilder> volumes = new ArrayList<BuildVolumeBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public A removeAllFromEnv(Collection<EnvVar> items) {
    for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public List<EnvVar> getEnv() {
    return this.env;
  }
  public EnvVar getEnv(int index) {
    return this.env.get(index);
  }
  public EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  public EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<EnvVar> env) {
    if (env != null) {this.env = new ArrayList(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public Boolean getForcePull() {
    return this.forcePull;
  }
  public A withForcePull(Boolean forcePull) {
    this.forcePull=forcePull; return (A) this;
  }
  public Boolean hasForcePull() {
    return this.forcePull != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public ObjectReference buildFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public A withFrom(ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} else { this.from = null; _visitables.get("from").remove(this.from); } return (A) this;
  }
  public Boolean hasFrom() {
    return this.from != null;
  }
  public SourceBuildStrategyFluentImpl.FromNested<A> withNewFrom() {
    return new SourceBuildStrategyFluentImpl.FromNestedImpl();
  }
  public SourceBuildStrategyFluentImpl.FromNested<A> withNewFromLike(ObjectReference item) {
    return new SourceBuildStrategyFluentImpl.FromNestedImpl(item);
  }
  public SourceBuildStrategyFluentImpl.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public SourceBuildStrategyFluentImpl.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
  }
  public SourceBuildStrategyFluentImpl.FromNested<A> editOrNewFromLike(ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  public Boolean getIncremental() {
    return this.incremental;
  }
  public A withIncremental(Boolean incremental) {
    this.incremental=incremental; return (A) this;
  }
  public Boolean hasIncremental() {
    return this.incremental != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPullSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getPullSecret() {
    return this.pullSecret!=null ?this.pullSecret.build():null;
  }
  public LocalObjectReference buildPullSecret() {
    return this.pullSecret!=null ?this.pullSecret.build():null;
  }
  public A withPullSecret(LocalObjectReference pullSecret) {
    _visitables.get("pullSecret").remove(this.pullSecret);
    if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} else { this.pullSecret = null; _visitables.get("pullSecret").remove(this.pullSecret); } return (A) this;
  }
  public Boolean hasPullSecret() {
    return this.pullSecret != null;
  }
  public A withNewPullSecret(String name) {
    return (A)withPullSecret(new LocalObjectReference(name));
  }
  public SourceBuildStrategyFluentImpl.PullSecretNested<A> withNewPullSecret() {
    return new SourceBuildStrategyFluentImpl.PullSecretNestedImpl();
  }
  public SourceBuildStrategyFluentImpl.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
    return new SourceBuildStrategyFluentImpl.PullSecretNestedImpl(item);
  }
  public SourceBuildStrategyFluentImpl.PullSecretNested<A> editPullSecret() {
    return withNewPullSecretLike(getPullSecret());
  }
  public SourceBuildStrategyFluentImpl.PullSecretNested<A> editOrNewPullSecret() {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new LocalObjectReferenceBuilder().build());
  }
  public SourceBuildStrategyFluentImpl.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
  }
  public String getScripts() {
    return this.scripts;
  }
  public A withScripts(String scripts) {
    this.scripts=scripts; return (A) this;
  }
  public Boolean hasScripts() {
    return this.scripts != null;
  }
  public A addToVolumes(int index,BuildVolume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<BuildVolumeBuilder>();}
    BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").add(index, builder); volumes.add(index, builder);}
    return (A)this;
  }
  public A setToVolumes(int index,BuildVolume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<BuildVolumeBuilder>();}
    BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").set(index, builder); volumes.set(index, builder);}
    return (A)this;
  }
  public A addToVolumes(io.fabric8.openshift.api.model.BuildVolume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<BuildVolumeBuilder>();}
    for (BuildVolume item : items) {BuildVolumeBuilder builder = new BuildVolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A addAllToVolumes(Collection<BuildVolume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<BuildVolumeBuilder>();}
    for (BuildVolume item : items) {BuildVolumeBuilder builder = new BuildVolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.openshift.api.model.BuildVolume... items) {
    for (BuildVolume item : items) {BuildVolumeBuilder builder = new BuildVolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<BuildVolume> items) {
    for (BuildVolume item : items) {BuildVolumeBuilder builder = new BuildVolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumes(Predicate<BuildVolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<BuildVolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      BuildVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BuildVolume> getVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public List<BuildVolume> buildVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public BuildVolume buildVolume(int index) {
    return this.volumes.get(index).build();
  }
  public BuildVolume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public BuildVolume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public BuildVolume buildMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
    for (BuildVolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
    for (BuildVolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<BuildVolume> volumes) {
    if (this.volumes != null) { _visitables.get("volumes").clear();}
    if (volumes != null) {this.volumes = new ArrayList(); for (BuildVolume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.openshift.api.model.BuildVolume... volumes) {
    if (this.volumes != null) {this.volumes.clear(); _visitables.remove("volumes"); }
    if (volumes != null) {for (BuildVolume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public SourceBuildStrategyFluentImpl.VolumesNested<A> addNewVolume() {
    return new SourceBuildStrategyFluentImpl.VolumesNestedImpl();
  }
  public SourceBuildStrategyFluentImpl.VolumesNested<A> addNewVolumeLike(BuildVolume item) {
    return new SourceBuildStrategyFluentImpl.VolumesNestedImpl(-1, item);
  }
  public SourceBuildStrategyFluentImpl.VolumesNested<A> setNewVolumeLike(int index,BuildVolume item) {
    return new SourceBuildStrategyFluentImpl.VolumesNestedImpl(index, item);
  }
  public SourceBuildStrategyFluentImpl.VolumesNested<A> editVolume(int index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public SourceBuildStrategyFluentImpl.VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  public SourceBuildStrategyFluentImpl.VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public SourceBuildStrategyFluentImpl.VolumesNested<A> editMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SourceBuildStrategyFluentImpl that = (SourceBuildStrategyFluentImpl) o;
    if (!java.util.Objects.equals(env, that.env)) return false;

    if (!java.util.Objects.equals(forcePull, that.forcePull)) return false;

    if (!java.util.Objects.equals(from, that.from)) return false;

    if (!java.util.Objects.equals(incremental, that.incremental)) return false;

    if (!java.util.Objects.equals(pullSecret, that.pullSecret)) return false;

    if (!java.util.Objects.equals(scripts, that.scripts)) return false;

    if (!java.util.Objects.equals(volumes, that.volumes)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(env,  forcePull,  from,  incremental,  pullSecret,  scripts,  volumes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (forcePull != null) { sb.append("forcePull:"); sb.append(forcePull + ","); }
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (incremental != null) { sb.append("incremental:"); sb.append(incremental + ","); }
    if (pullSecret != null) { sb.append("pullSecret:"); sb.append(pullSecret + ","); }
    if (scripts != null) { sb.append("scripts:"); sb.append(scripts + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withForcePull() {
    return withForcePull(true);
  }
  public A withIncremental() {
    return withIncremental(true);
  }
  class FromNestedImpl<N> extends ObjectReferenceFluentImpl<SourceBuildStrategyFluentImpl.FromNested<N>> implements SourceBuildStrategyFluentImpl.FromNested<N>,Nested<N>{
    FromNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) SourceBuildStrategyFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<SourceBuildStrategyFluentImpl.PullSecretNested<N>> implements SourceBuildStrategyFluentImpl.PullSecretNested<N>,Nested<N>{
    PullSecretNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    PullSecretNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) SourceBuildStrategyFluentImpl.this.withPullSecret(builder.build());
    }
    public N endPullSecret() {
      return and();
    }
    
  }
  class VolumesNestedImpl<N> extends BuildVolumeFluentImpl<SourceBuildStrategyFluentImpl.VolumesNested<N>> implements SourceBuildStrategyFluentImpl.VolumesNested<N>,Nested<N>{
    VolumesNestedImpl(int index,BuildVolume item) {
      this.index = index;
      this.builder = new BuildVolumeBuilder(this, item);
    }
    VolumesNestedImpl() {
      this.index = -1;
      this.builder = new BuildVolumeBuilder(this);
    }
    BuildVolumeBuilder builder;
    int index;
    public N and() {
      return (N) SourceBuildStrategyFluentImpl.this.setToVolumes(index,builder.build());
    }
    public N endVolume() {
      return and();
    }
    
  }
  
}