package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoutePortBuilder extends RoutePortFluentImpl<RoutePortBuilder> implements VisitableBuilder<RoutePort,RoutePortBuilder>{
  public RoutePortBuilder() {
    this(false);
  }
  public RoutePortBuilder(Boolean validationEnabled) {
    this(new RoutePort(), validationEnabled);
  }
  public RoutePortBuilder(RoutePortFluent<?> fluent) {
    this(fluent, false);
  }
  public RoutePortBuilder(RoutePortFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RoutePort(), validationEnabled);
  }
  public RoutePortBuilder(RoutePortFluent<?> fluent,RoutePort instance) {
    this(fluent, instance, false);
  }
  public RoutePortBuilder(RoutePortFluent<?> fluent,RoutePort instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withTargetPort(instance.getTargetPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RoutePortBuilder(RoutePort instance) {
    this(instance,false);
  }
  public RoutePortBuilder(RoutePort instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withTargetPort(instance.getTargetPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RoutePortFluent<?> fluent;
  Boolean validationEnabled;
  public RoutePort build() {
    RoutePort buildable = new RoutePort(fluent.getTargetPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}